/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.jxdinfo.hussar.workflow.util.BpmActivityExceptionUtil;
import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.message.ExceptionMessageParam;

public abstract class NeedsActiveTaskCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public NeedsActiveTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public T execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiIllegalArgumentException(BpmActivityExceptionUtil.getExceptionMessage(14102));
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiException(BpmActivityExceptionUtil.getExceptionMessage(14101));
        }
        String processInstId = task.getProcessInstanceId();
        ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(processInstId);
        if (task.isSuspended() || execution.isSuspended()) {
            ExecutionEntity executionEntity = task.getExecution();
            ExceptionMessageParam messageParam = new ExceptionMessageParam();
            messageParam.setProcessKey(executionEntity.getProcessDefinitionId().split(":")[0]);
            messageParam.setProcessName(executionEntity.getProcessDefinition().getName());
            messageParam.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
            messageParam.setTaskDefinitionKey(task.getTaskDefinitionKey());
            messageParam.setTaskDefinitionName(task.getName());
            String startUserId = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(execution.getProcessInstanceId()).getStartUserId();
            messageParam.setStartUserId(startUserId);
            ActivitiException activitiException = new ActivitiException(BpmActivityExceptionUtil.getExceptionMessage(14118), messageParam);
            BpmActivityExceptionUtil.pushExceptionMessage(activitiException);
            BpmActivityExceptionUtil.throwBpmException(activitiException);
        }
        return this.execute(commandContext, task);
    }

    protected abstract T execute(CommandContext var1, TaskEntity var2);

    protected String getSuspendedTaskException() {
        return "Cannot execute operation: task is suspended";
    }
}

