/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.ModelQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;

public class ModelQueryImpl
extends AbstractQuery<ModelQuery, Model>
implements ModelQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String category;
    protected String categoryLike;
    protected String categoryNotEquals;
    protected String name;
    protected String nameLike;
    protected String key;
    protected Integer version;
    protected boolean latest;
    protected String deploymentId;
    protected boolean notDeployed;
    protected boolean deployed;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String appId;
    protected String appName;
    protected String organId;
    protected String modelType;

    public ModelQueryImpl() {
    }

    public ModelQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ModelQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public ModelQueryImpl modelId(String modelId) {
        this.id = modelId;
        return this;
    }

    @Override
    public ModelQueryImpl modelCategory(String category) {
        if (category == null) {
            throw new ActivitiIllegalArgumentException("category is null");
        }
        this.category = category;
        return this;
    }

    @Override
    public ModelQueryImpl modelCategoryLike(String categoryLike) {
        if (categoryLike == null) {
            throw new ActivitiIllegalArgumentException("categoryLike is null");
        }
        this.categoryLike = categoryLike;
        return this;
    }

    @Override
    public ModelQueryImpl modelCategoryNotEquals(String categoryNotEquals) {
        if (categoryNotEquals == null) {
            throw new ActivitiIllegalArgumentException("categoryNotEquals is null");
        }
        this.categoryNotEquals = categoryNotEquals;
        return this;
    }

    @Override
    public ModelQueryImpl modelName(String name) {
        if (name == null) {
            throw new ActivitiIllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    @Override
    public ModelQueryImpl modelNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiIllegalArgumentException("nameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public ModelQuery modelKey(String key) {
        if (key == null) {
            throw new ActivitiIllegalArgumentException("key is null");
        }
        this.key = key;
        return this;
    }

    @Override
    public ModelQueryImpl modelVersion(Integer version) {
        if (version == null) {
            throw new ActivitiIllegalArgumentException("version is null");
        }
        if (version <= 0) {
            throw new ActivitiIllegalArgumentException("version must be positive");
        }
        this.version = version;
        return this;
    }

    @Override
    public ModelQuery latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public ModelQuery deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new ActivitiIllegalArgumentException("DeploymentId is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public ModelQuery notDeployed() {
        if (this.deployed) {
            throw new ActivitiIllegalArgumentException("Invalid usage: cannot use deployed() and notDeployed() in the same query");
        }
        this.notDeployed = true;
        return this;
    }

    @Override
    public ModelQuery deployed() {
        if (this.notDeployed) {
            throw new ActivitiIllegalArgumentException("Invalid usage: cannot use deployed() and notDeployed() in the same query");
        }
        this.deployed = true;
        return this;
    }

    @Override
    public ModelQuery modelTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("Model tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ModelQuery modelTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("Model tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    @Override
    public ModelQuery modelWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public ModelQuery modelAppId(String appId) {
        if (appId == null) {
            throw new ActivitiIllegalArgumentException("Model appId id is null");
        }
        this.appId = appId;
        return this;
    }

    @Override
    public ModelQuery modelAppName(String appName) {
        if (appName == null) {
            throw new ActivitiIllegalArgumentException("Model appName id is null");
        }
        this.appName = appName;
        return this;
    }

    @Override
    public ModelQuery organId(String organId) {
        this.organId = organId;
        return this;
    }

    @Override
    public ModelQuery orderByModelCategory() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.MODEL_CATEGORY);
    }

    @Override
    public ModelQuery orderByModelId() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.MODEL_ID);
    }

    @Override
    public ModelQuery orderByModelKey() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.MODEL_KEY);
    }

    @Override
    public ModelQuery orderByModelVersion() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.MODEL_VERSION);
    }

    @Override
    public ModelQuery orderByModelName() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.MODEL_NAME);
    }

    @Override
    public ModelQuery orderByCreateTime() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.MODEL_CREATE_TIME);
    }

    @Override
    public ModelQuery orderByLastUpdateTime() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.MODEL_LAST_UPDATE_TIME);
    }

    @Override
    public ModelQuery orderByTenantId() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.MODEL_TENANT_ID);
    }

    @Override
    public ModelQuery orderByAppId() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.APP_ID);
    }

    @Override
    public ModelQuery orderByAppName() {
        return (ModelQuery)this.orderBy(ModelQueryProperty.APP_NAME);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getModelEntityManager().findModelCountByQueryCriteria(this);
    }

    @Override
    public List<Model> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getModelEntityManager().findModelsByQueryCriteria(this, page);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getOrganId() {
        return this.organId;
    }

    public String getModelType() {
        return this.modelType;
    }
}

