/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.asyncexecutor.AcquiredJobEntities;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;

public class AcquireAsyncJobsDueCmd
implements Command<AcquiredJobEntities> {
    private final AsyncExecutor asyncExecutor;

    public AcquireAsyncJobsDueCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public AcquiredJobEntities execute(CommandContext commandContext) {
        AcquiredJobEntities acquiredJobs = new AcquiredJobEntities();
        List<JobEntity> jobs = commandContext.getJobEntityManager().findAsyncJobsDueToExecute(new Page(0, this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition()));
        for (JobEntity job : jobs) {
            this.lockJob(commandContext, job, this.asyncExecutor.getAsyncJobLockTimeInMillis());
            acquiredJobs.addJob(job);
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, JobEntity job, int lockTimeInMillis) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

