/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.event.AbstractEventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;

public class SignalEventHandler
extends AbstractEventHandler {
    public static final String EVENT_HANDLER_TYPE = "signal";

    @Override
    public String getEventHandlerType() {
        return EVENT_HANDLER_TYPE;
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        if (eventSubscription.getExecutionId() != null) {
            super.handleEvent(eventSubscription, payload, commandContext);
        } else if (eventSubscription.getProcessDefinitionId() != null) {
            String processDefinitionId = eventSubscription.getProcessDefinitionId();
            DeploymentManager deploymentCache = Context.getProcessEngineConfiguration().getDeploymentManager();
            ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for id '" + processDefinitionId + "'", ProcessDefinition.class);
            }
            ActivityImpl startActivity = processDefinition.findActivity(eventSubscription.getActivityId());
            if (startActivity == null) {
                throw new ActivitiException("Could no handle signal: no start activity found with id " + eventSubscription.getActivityId());
            }
            ExecutionEntity processInstance = processDefinition.createProcessInstance(null, startActivity, null);
            if (processInstance == null) {
                throw new ActivitiException("Could not handle signal: no process instance started");
            }
            if (payload != null && payload instanceof Map) {
                Map variables = (Map)payload;
                processInstance.setVariables(variables);
            }
            processInstance.start();
        } else {
            throw new ActivitiException("Invalid signal handling: no execution nor process definition set");
        }
    }
}

