/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.runtime.Execution;

public class GetExecutionVariableInstancesCmd
implements Command<Map<String, VariableInstance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected Collection<String> variableNames;
    protected boolean isLocal;
    protected String locale;
    protected boolean withLocalizationFallback;

    public GetExecutionVariableInstancesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        this.executionId = executionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    public GetExecutionVariableInstancesCmd(String executionId, Collection<String> variableNames, boolean isLocal, String locale, boolean withLocalizationFallback) {
        this.executionId = executionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
        this.locale = locale;
        this.withLocalizationFallback = withLocalizationFallback;
    }

    @Override
    public Map<String, VariableInstance> execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("executionId is null");
        }
        ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        Map<String, VariableInstance> variables = null;
        variables = this.variableNames == null || this.variableNames.isEmpty() ? (this.isLocal ? execution.getVariableInstancesLocal() : execution.getVariableInstances()) : (this.isLocal ? execution.getVariableInstancesLocal(this.variableNames, false) : execution.getVariableInstances(this.variableNames, false));
        if (variables != null && this.locale != null) {
            for (Map.Entry<String, VariableInstance> entry : variables.entrySet()) {
                String variableName = entry.getKey();
                VariableInstance variableEntity = entry.getValue();
                String localizedName = null;
                String localizedDescription = null;
                ObjectNode languageNode = Context.getLocalizationElementProperties(this.locale, variableName, execution.getProcessDefinitionId(), this.withLocalizationFallback);
                if (languageNode != null) {
                    JsonNode descriptionNode;
                    JsonNode nameNode = languageNode.get("name");
                    if (nameNode != null) {
                        localizedName = nameNode.asText();
                    }
                    if ((descriptionNode = languageNode.get("description")) != null) {
                        localizedDescription = descriptionNode.asText();
                    }
                }
                variableEntity.setLocalizedName(localizedName);
                variableEntity.setLocalizedDescription(localizedDescription);
            }
        }
        return variables;
    }
}

