/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.listener;

import com.jxdinfo.hussar.workflow.util.BpmActivitiSpringContextHolder;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.bpmn.helper.ClassDelegate;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ExecutionListenerInvocation;
import org.activiti.engine.impl.delegate.JavaDelegateInvocation;
import org.activiti.engine.impl.el.FixedValue;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class DelegateExpressionExecutionListener
implements ExecutionListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionExecutionListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void notify(DelegateExecution execution) throws Exception {
        Object delegate = this.expression.getValue(execution);
        ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (delegate instanceof ExecutionListener) {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation((ExecutionListener)delegate, execution));
            return;
        } else if (delegate instanceof JavaDelegate) {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)delegate, execution));
            return;
        } else {
            if (!(delegate instanceof String)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + ExecutionListener.class + " nor " + JavaDelegate.class);
            ((ExecutionEntity)execution).addLocalTempVariable("beanId", (String)delegate);
            Object object = BpmActivitiSpringContextHolder.getBean("DefaultCloudExecutionListener");
            for (FieldDeclaration fieldDeclaration : this.fieldDeclarations) {
                if (!"listenerModel".equals(fieldDeclaration.getName()) && !"requestMethod".equals(fieldDeclaration.getName())) continue;
                ((ExecutionEntity)execution).addLocalTempVariable(fieldDeclaration.getName(), ((FixedValue)fieldDeclaration.getValue()).getExpressionText());
            }
            if (object == null) {
                throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + ExecutionListener.class + " nor " + JavaDelegate.class);
            }
            ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, object);
            if (object instanceof ExecutionListener) {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation((ExecutionListener)object, execution));
                return;
            } else {
                if (!(object instanceof JavaDelegate)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + ExecutionListener.class + " nor " + JavaDelegate.class);
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)object, execution));
            }
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

