/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.BulkDeleteable;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricScopeInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInitializingList;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.TaskStateType;

public class HistoricTaskInstanceEntity
extends HistoricScopeInstanceEntity
implements HistoricTaskInstance,
BulkDeleteable,
PersistentObject {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String name;
    protected String localizedName;
    protected String parentTaskId;
    protected String description;
    protected String localizedDescription;
    protected String owner;
    protected String assignee;
    protected String receiver;
    protected String taskDefinitionKey;
    protected String formKey;
    protected int priority;
    protected Date dueDate;
    protected Date claimTime;
    protected String category;
    protected String tenantId = "";
    protected String subProcessKey;
    protected Integer cycleCount;
    protected Integer processCycleCount;
    protected List<HistoricVariableInstanceEntity> queryVariables;
    protected String formId;
    protected String taskState;
    protected String taskType;
    protected String assistInitiator;
    protected String createHistoryTaskId;

    public HistoricTaskInstanceEntity() {
    }

    public HistoricTaskInstanceEntity(TaskEntity task, ExecutionEntity execution) {
        this.id = task.getId();
        if (execution != null) {
            this.processDefinitionId = execution.getProcessDefinitionId();
            this.processInstanceId = execution.getProcessInstanceId();
            this.executionId = execution.getId();
        } else {
            this.processInstanceId = task.getProcessInstanceId();
        }
        this.name = task.getName();
        this.parentTaskId = task.getParentTaskId();
        this.description = task.getDescription();
        this.owner = task.getOwner();
        this.assignee = task.getAssignee();
        this.receiver = task.getReceiver();
        this.formId = task.getFormId();
        this.subProcessKey = task.getSubProcessKey();
        this.cycleCount = task.getCycleCount();
        this.processCycleCount = task.getProcessCycleCount();
        this.startTime = task.getCreateTime() != null ? task.getCreateTime() : Context.getProcessEngineConfiguration().getClock().getCurrentTime();
        if (task.getFormKey() != null) {
            this.formKey = task.getFormKey();
        }
        if (task.getFormId() != null) {
            this.formId = task.getFormId();
        }
        this.taskDefinitionKey = task.getTaskDefinitionKey();
        this.setPriority(task.getPriority());
        this.setDueDate(task.getDueDate());
        this.setCategory(task.getCategory());
        if (task.getTenantId() != null) {
            this.tenantId = task.getTenantId();
        }
        this.setTaskType(task.getTaskType());
        this.setCreateHistoryTaskId(task.getCreateHistoryTaskId());
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("name", this.name);
        persistentState.put("owner", this.owner);
        persistentState.put("assignee", this.assignee);
        persistentState.put("receiver", this.receiver);
        persistentState.put("endTime", this.endTime);
        persistentState.put("durationInMillis", this.durationInMillis);
        persistentState.put("description", this.description);
        persistentState.put("deleteReason", this.deleteReason);
        persistentState.put("taskDefinitionKey", this.taskDefinitionKey);
        persistentState.put("formKey", this.formKey);
        persistentState.put("formId", this.formId);
        persistentState.put("priority", this.priority);
        persistentState.put("category", this.category);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        if (this.parentTaskId != null) {
            persistentState.put("parentTaskId", this.parentTaskId);
        }
        if (this.dueDate != null) {
            persistentState.put("dueDate", this.dueDate);
        }
        if (this.claimTime != null) {
            persistentState.put("claimTime", this.claimTime);
        }
        if (this.taskState != null) {
            persistentState.put("taskState", this.taskState);
        }
        if (this.taskType != null) {
            persistentState.put("taskType", this.taskType);
        }
        if (this.assistInitiator != null) {
            persistentState.put("assistInitiator", this.assistInitiator);
        }
        if (this.createHistoryTaskId != null) {
            persistentState.put("createHistoryTaskId", this.createHistoryTaskId);
        }
        return persistentState;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setLocalizedName(String name) {
        this.localizedName = name;
    }

    @Override
    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setLocalizedDescription(String description) {
        this.localizedDescription = description;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @Override
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @Override
    public Date getCreateTime() {
        return this.getStartTime();
    }

    @Override
    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @Override
    public String getReceiver() {
        return this.receiver;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    @Override
    public String getFormId() {
        return this.formId;
    }

    @Override
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    @Override
    public Date getClaimTime() {
        return this.claimTime;
    }

    public void setClaimTime(Date claimTime) {
        this.claimTime = claimTime;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Date getTime() {
        return this.getStartTime();
    }

    @Override
    public Long getWorkTimeInMillis() {
        if (this.endTime == null || this.claimTime == null) {
            return null;
        }
        return this.endTime.getTime() - this.claimTime.getTime();
    }

    @Override
    public Map<String, Object> getTaskLocalVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() == null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public void setAssistInitiator(String assistInitiator) {
        this.assistInitiator = assistInitiator;
    }

    @Override
    public String getAssistInitiator() {
        return this.assistInitiator;
    }

    @Override
    public String getCreateHistoryTaskId() {
        return this.createHistoryTaskId;
    }

    public void setCreateHistoryTaskId(String createHistoryTaskId) {
        this.createHistoryTaskId = createHistoryTaskId;
    }

    public List<HistoricVariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new HistoricVariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<HistoricVariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    @Override
    public String getTaskState() {
        return this.taskState;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    @Override
    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @Override
    public String getOriginalAssignee() {
        if (TaskStateType.isEntrust(this)) {
            return this.getOwner();
        }
        return this.getAssignee();
    }

    @Override
    public String getSubProcessKey() {
        return this.subProcessKey;
    }

    public void setSubProcessKey(String subProcessKey) {
        this.subProcessKey = subProcessKey;
    }

    @Override
    public Integer getCycleCount() {
        return this.cycleCount;
    }

    public void setCycleCount(Integer cycleCount) {
        this.cycleCount = cycleCount;
    }

    @Override
    public Integer getProcessCycleCount() {
        return this.processCycleCount;
    }

    public void setProcessCycleCount(Integer processCycleCount) {
        this.processCycleCount = processCycleCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoricTaskInstanceEntity[");
        sb.append("id=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append("]");
        return sb.toString();
    }
}

