/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.jxdinfo.hussar.workflow.util.BpmActivityExceptionUtil;
import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.message.ExceptionMessageParam;

public abstract class NeedsActiveTaskCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public NeedsActiveTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public T execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiIllegalArgumentException("\u4efb\u52a1id\u4e3a\u7a7a");
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiException("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (task.isSuspended()) {
            ExecutionEntity executionEntity = task.getExecution();
            ExceptionMessageParam messageParam = new ExceptionMessageParam();
            messageParam.setProcessKey(executionEntity.getProcessDefinitionId().split(":")[0]);
            messageParam.setProcessName(executionEntity.getProcessDefinition().getName());
            messageParam.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
            messageParam.setTaskDefinitionKey(task.getTaskDefinitionKey());
            messageParam.setTaskDefinitionName(task.getName());
            ActivitiException activitiException = new ActivitiException("\u4efb\u52a1\u5df2\u6302\u8d77", messageParam);
            BpmActivityExceptionUtil.pushExceptionMessage(activitiException);
            BpmActivityExceptionUtil.throwBpmException(activitiException);
        }
        return this.execute(commandContext, task);
    }

    protected abstract T execute(CommandContext var1, TaskEntity var2);

    protected String getSuspendedTaskException() {
        return "Cannot execute operation: task is suspended";
    }
}

