/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.BulkDeleteable;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricScopeInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInitializingList;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;

public class HistoricProcessInstanceEntity
extends HistoricScopeInstanceEntity
implements HistoricProcessInstance,
BulkDeleteable {
    private static final long serialVersionUID = 1L;
    protected String endActivityId;
    protected String businessKey;
    protected String startUserId;
    protected String startActivityId;
    protected String superProcessInstanceId;
    protected String tenantId = "";
    protected String name;
    protected String localizedName;
    protected String description;
    protected String localizedDescription;
    protected List<HistoricVariableInstanceEntity> queryVariables;
    protected String procExtendStringExtra1;
    protected String procExtendStringExtra2;
    protected String procExtendStringExtra3;
    protected String procExtendStringExtra4;
    protected String procExtendStringExtra5;
    protected Integer procExtendIntegerExtra1;
    protected Integer procExtendIntegerExtra2;
    protected Integer procExtendIntegerExtra3;
    protected Integer procExtendIntegerExtra4;
    protected Integer procExtendIntegerExtra5;

    public HistoricProcessInstanceEntity() {
    }

    public HistoricProcessInstanceEntity(ExecutionEntity processInstance) {
        this.id = processInstance.getId();
        this.processInstanceId = processInstance.getId();
        this.businessKey = processInstance.getBusinessKey();
        this.processDefinitionId = processInstance.getProcessDefinitionId();
        this.processDefinitionKey = processInstance.getProcessDefinitionKey();
        this.processDefinitionName = processInstance.getProcessDefinitionName();
        this.processDefinitionVersion = processInstance.getProcessDefinitionVersion();
        this.deploymentId = processInstance.getDeploymentId();
        this.startTime = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
        this.startUserId = Authentication.getAuthenticatedUserId();
        this.startActivityId = processInstance.getActivityId();
        this.superProcessInstanceId = processInstance.getSuperExecution() != null ? processInstance.getSuperExecution().getProcessInstanceId() : null;
        this.procExtendStringExtra1 = processInstance.getProcExtendStringExtra1();
        this.procExtendStringExtra2 = processInstance.getProcExtendStringExtra2();
        this.procExtendStringExtra3 = processInstance.getProcExtendStringExtra3();
        this.procExtendStringExtra4 = processInstance.getProcExtendStringExtra4();
        this.procExtendStringExtra5 = processInstance.getProcExtendStringExtra5();
        this.procExtendIntegerExtra1 = processInstance.getProcExtendIntegerExtra1();
        this.procExtendIntegerExtra2 = processInstance.getProcExtendIntegerExtra2();
        this.procExtendIntegerExtra3 = processInstance.getProcExtendIntegerExtra3();
        this.procExtendIntegerExtra4 = processInstance.getProcExtendIntegerExtra4();
        this.procExtendIntegerExtra5 = processInstance.getProcExtendIntegerExtra5();
        if (processInstance.getTenantId() != null) {
            this.tenantId = processInstance.getTenantId();
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("endTime", this.endTime);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("name", this.name);
        persistentState.put("durationInMillis", this.durationInMillis);
        persistentState.put("deleteReason", this.deleteReason);
        persistentState.put("endStateName", this.endActivityId);
        persistentState.put("superProcessInstanceId", this.superProcessInstanceId);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("processDefinitionKey", this.processDefinitionKey);
        persistentState.put("processDefinitionName", this.processDefinitionName);
        persistentState.put("processDefinitionVersion", this.processDefinitionVersion);
        persistentState.put("deploymentId", this.deploymentId);
        return persistentState;
    }

    @Override
    public String getEndActivityId() {
        return this.endActivityId;
    }

    public void setEndActivityId(String endActivityId) {
        this.endActivityId = endActivityId;
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    @Override
    public String getStartActivityId() {
        return this.startActivityId;
    }

    public void setStartActivityId(String startUserId) {
        this.startActivityId = startUserId;
    }

    @Override
    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    @Override
    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    @Override
    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    @Override
    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public List<HistoricVariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new HistoricVariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<HistoricVariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    public String toString() {
        return "HistoricProcessInstanceEntity[superProcessInstanceId=" + this.superProcessInstanceId + "]";
    }

    @Override
    public void setNotEnd() {
        this.endTime = null;
        this.durationInMillis = null;
        this.endActivityId = null;
    }

    @Override
    public String getProcExtendStringExtra1() {
        return this.procExtendStringExtra1;
    }

    public void setProcExtendStringExtra1(String procExtendStringExtra1) {
        this.procExtendStringExtra1 = procExtendStringExtra1;
    }

    @Override
    public String getProcExtendStringExtra2() {
        return this.procExtendStringExtra2;
    }

    public void setProcExtendStringExtra2(String procExtendStringExtra2) {
        this.procExtendStringExtra2 = procExtendStringExtra2;
    }

    @Override
    public String getProcExtendStringExtra3() {
        return this.procExtendStringExtra3;
    }

    public void setProcExtendStringExtra3(String procExtendStringExtra3) {
        this.procExtendStringExtra3 = procExtendStringExtra3;
    }

    @Override
    public String getProcExtendStringExtra4() {
        return this.procExtendStringExtra4;
    }

    public void setProcExtendStringExtra4(String procExtendStringExtra4) {
        this.procExtendStringExtra4 = procExtendStringExtra4;
    }

    @Override
    public String getProcExtendStringExtra5() {
        return this.procExtendStringExtra5;
    }

    public void setProcExtendStringExtra5(String procExtendStringExtra5) {
        this.procExtendStringExtra5 = procExtendStringExtra5;
    }

    @Override
    public Integer getProcExtendIntegerExtra1() {
        return this.procExtendIntegerExtra1;
    }

    public void setProcExtendIntegerExtra1(Integer procExtendIntegerExtra1) {
        this.procExtendIntegerExtra1 = procExtendIntegerExtra1;
    }

    @Override
    public Integer getProcExtendIntegerExtra2() {
        return this.procExtendIntegerExtra2;
    }

    public void setProcExtendIntegerExtra2(Integer procExtendIntegerExtra2) {
        this.procExtendIntegerExtra2 = procExtendIntegerExtra2;
    }

    @Override
    public Integer getProcExtendIntegerExtra3() {
        return this.procExtendIntegerExtra3;
    }

    public void setProcExtendIntegerExtra3(Integer procExtendIntegerExtra3) {
        this.procExtendIntegerExtra3 = procExtendIntegerExtra3;
    }

    @Override
    public Integer getProcExtendIntegerExtra4() {
        return this.procExtendIntegerExtra4;
    }

    public void setProcExtendIntegerExtra4(Integer procExtendIntegerExtra4) {
        this.procExtendIntegerExtra4 = procExtendIntegerExtra4;
    }

    @Override
    public Integer getProcExtendIntegerExtra5() {
        return this.procExtendIntegerExtra5;
    }

    public void setProcExtendIntegerExtra5(Integer procExtendIntegerExtra5) {
        this.procExtendIntegerExtra5 = procExtendIntegerExtra5;
    }
}

