/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

public class StartProcessInstanceCmd<T>
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected Map<String, Object> variables;
    protected String businessKey;
    protected String tenantId;
    protected String processInstanceName;
    protected String procExtendStringExtra1;
    protected String procExtendStringExtra2;
    protected String procExtendStringExtra3;
    protected String procExtendStringExtra4;
    protected String procExtendStringExtra5;
    protected Integer procExtendIntegerExtra1;
    protected Integer procExtendIntegerExtra2;
    protected Integer procExtendIntegerExtra3;
    protected Integer procExtendIntegerExtra4;
    protected Integer procExtendIntegerExtra5;

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables, String procExtendStringExtra1, String procExtendStringExtra2, String procExtendStringExtra3, String procExtendStringExtra4, String procExtendStringExtra5, Integer procExtendIntegerExtra1, Integer procExtendIntegerExtra2, Integer procExtendIntegerExtra3, Integer procExtendIntegerExtra4, Integer procExtendIntegerExtra5) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.variables = variables;
        this.businessKey = businessKey;
        this.procExtendStringExtra1 = procExtendStringExtra1;
        this.procExtendStringExtra2 = procExtendStringExtra2;
        this.procExtendStringExtra3 = procExtendStringExtra3;
        this.procExtendStringExtra4 = procExtendStringExtra4;
        this.procExtendStringExtra5 = procExtendStringExtra5;
        this.procExtendIntegerExtra1 = procExtendIntegerExtra1;
        this.procExtendIntegerExtra2 = procExtendIntegerExtra2;
        this.procExtendIntegerExtra3 = procExtendIntegerExtra3;
        this.procExtendIntegerExtra4 = procExtendIntegerExtra4;
        this.procExtendIntegerExtra5 = procExtendIntegerExtra5;
    }

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = variables;
    }

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables, String tenantId) {
        this(processDefinitionKey, processDefinitionId, businessKey, variables);
        this.tenantId = tenantId;
    }

    public StartProcessInstanceCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
        this(processInstanceBuilder.getProcessDefinitionKey(), processInstanceBuilder.getProcessDefinitionId(), processInstanceBuilder.getBusinessKey(), processInstanceBuilder.getVariables(), processInstanceBuilder.getTenantId());
        this.processInstanceName = processInstanceBuilder.getProcessInstanceName();
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        DeploymentManager deploymentManager = commandContext.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinitionEntity processDefinition = null;
        if (this.processDefinitionId != null) {
            processDefinition = deploymentManager.findDeployedProcessDefinitionById(this.processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
            }
        } else if (this.processDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId))) {
            processDefinition = deploymentManager.findDeployedLatestProcessDefinitionByKey(this.processDefinitionKey);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "'", ProcessDefinition.class);
            }
        } else if (this.processDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId)) {
            processDefinition = deploymentManager.findDeployedLatestProcessDefinitionByKeyAndTenantId(this.processDefinitionKey, this.tenantId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "' for tenant identifier " + this.tenantId, ProcessDefinition.class);
            }
        } else {
            throw new ActivitiIllegalArgumentException("processDefinitionKey and processDefinitionId are null");
        }
        if (deploymentManager.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new ActivitiException(processDefinition.getName() + "\u5df2\u6302\u8d77");
        }
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.businessKey, this.procExtendStringExtra1, this.procExtendStringExtra2, this.procExtendStringExtra3, this.procExtendStringExtra4, this.procExtendStringExtra5, this.procExtendIntegerExtra1, this.procExtendIntegerExtra2, this.procExtendIntegerExtra3, this.procExtendIntegerExtra4, this.procExtendIntegerExtra5, null);
        this.initializeVariables(processInstance);
        if (this.processInstanceName != null) {
            processInstance.setName(this.processInstanceName);
            commandContext.getHistoryManager().recordProcessInstanceNameChange(processInstance.getId(), this.processInstanceName);
        }
        processInstance.fireEventExecution("beforeStart");
        processInstance.start();
        return processInstance;
    }

    protected void initializeVariables(ExecutionEntity processInstance) {
        if (this.variables != null) {
            processInstance.setVariables(this.variables);
        }
    }
}

