/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.helper.ClassDelegate;
import org.activiti.engine.impl.bpmn.listener.DelegateExpressionTaskListener;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.BulkDeleteable;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.delegate.TaskListenerInvocation;
import org.activiti.engine.impl.el.FixedValue;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.persistence.entity.VariableInitializingList;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableScopeImpl;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.task.DelegationState;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskStateType;
import org.apache.commons.lang3.StringUtils;

public class TaskEntity
extends VariableScopeImpl
implements Task,
DelegateTask,
Serializable,
PersistentObject,
HasRevision,
BulkDeleteable {
    public static final String DELETE_REASON_COMPLETED = "completed";
    public static final String DELETE_REASON_DELETED = "deleted";
    private static final long serialVersionUID = 1L;
    protected int revision;
    protected String owner;
    protected String assignee;
    protected String initialAssignee;
    protected DelegationState delegationState;
    protected String parentTaskId;
    protected String name;
    protected String localizedName;
    protected String description;
    protected String localizedDescription;
    protected int priority = 50;
    protected Date createTime;
    protected Date dueDate;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String category;
    protected boolean isIdentityLinksInitialized = false;
    protected List<IdentityLinkEntity> taskIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected String executionId;
    protected ExecutionEntity execution;
    protected String processInstanceId;
    protected ExecutionEntity processInstance;
    protected String processDefinitionId;
    protected TaskDefinition taskDefinition;
    protected String taskDefinitionKey;
    protected String formKey;
    protected boolean isDeleted;
    protected String eventName;
    protected String tenantId = "";
    protected List<VariableInstanceEntity> queryVariables;
    protected boolean forcedUpdate;
    protected String preempted;
    protected String subProcessKey;
    protected Integer cycleCount;
    protected String taskType;
    protected String createHistoryTaskId;
    protected String urgeState;

    public TaskEntity() {
    }

    public TaskEntity(String taskId) {
        this.id = taskId;
    }

    public static TaskEntity createAndInsert(ActivityExecution execution) {
        TaskEntity task = TaskEntity.create(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        task.insert((ExecutionEntity)execution);
        return task;
    }

    public static TaskEntity createAndInsert(ActivityExecution execution, Date date) {
        TaskEntity task = TaskEntity.create(date);
        task.insert((ExecutionEntity)execution);
        return task;
    }

    public void insert(ExecutionEntity execution) {
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.insert(this);
        if (execution != null && execution.getTenantId() != null) {
            this.setTenantId(execution.getTenantId());
        }
        if (execution != null) {
            execution.addTask(this);
        }
        commandContext.getHistoryManager().recordTaskCreated(this, execution);
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, this));
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, this));
        }
    }

    public void update() {
        this.setOwner(this.getOwner());
        this.setAssignee(this.getAssignee(), true, false);
        this.setDelegationState(this.getDelegationState());
        this.setName(this.getName());
        this.setDescription(this.getDescription());
        this.setPriority(this.getPriority());
        this.setCategory(this.getCategory());
        this.setCreateTime(this.getCreateTime());
        this.setDueDate(this.getDueDate());
        this.setParentTaskId(this.getParentTaskId());
        this.setFormKey(this.formKey);
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.update(this);
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, this));
        }
    }

    public static TaskEntity create(Date createTime) {
        TaskEntity task = new TaskEntity();
        task.isIdentityLinksInitialized = true;
        task.createTime = createTime;
        return task;
    }

    public void complete(Map variablesMap, boolean localScope) {
        if (this.getDelegationState() != null && this.getDelegationState().equals((Object)DelegationState.PENDING)) {
            throw new ActivitiException("A delegated task cannot be completed, but should be resolved instead.");
        }
        this.fireEvent("complete");
        if (Authentication.getAuthenticatedUserId() != null && this.processInstanceId != null) {
            this.getProcessInstance().involveUser(Authentication.getAuthenticatedUserId(), "participant");
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityWithVariablesEvent(ActivitiEventType.TASK_COMPLETED, this, variablesMap, localScope));
        }
        Context.getCommandContext().getTaskEntityManager().deleteTask(this, DELETE_REASON_COMPLETED, false);
        if (this.executionId != null) {
            ExecutionEntity execution = this.getExecution();
            execution.removeTask(this);
            execution.signal(null, null);
        }
    }

    public void complete(Map variablesMap, boolean localScope, String mandator) {
        if (this.getDelegationState() != null && this.getDelegationState().equals((Object)DelegationState.PENDING)) {
            throw new ActivitiException("A delegated task cannot be completed, but should be resolved instead.");
        }
        this.fireEvent("complete");
        if (Authentication.getAuthenticatedUserId() != null && this.processInstanceId != null) {
            this.getProcessInstance().involveUser(Authentication.getAuthenticatedUserId(), "participant");
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityWithVariablesEvent(ActivitiEventType.TASK_COMPLETED, this, variablesMap, localScope));
        }
        String taskState = null;
        String assistInitiator = null;
        if (mandator != null) {
            String assignee = this.getAssignee();
            List<IdentityLinkEntity> identityLinkEntities = this.getIdentityLinks();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                if (!TaskStateType.isEntrust(identityLinkEntity) || !identityLinkEntity.getUserId().equals(assignee)) continue;
                taskState = identityLinkEntity.getTaskState();
                assistInitiator = identityLinkEntity.getAssistInitiator();
                break;
            }
            if (taskState == null) {
                mandator = null;
            }
        }
        Context.getCommandContext().getTaskEntityManager().deleteTask(this, DELETE_REASON_COMPLETED, false, mandator, taskState, assistInitiator);
        if (this.executionId != null) {
            ExecutionEntity execution = this.getExecution();
            execution.removeTask(this);
            execution.signal(null, null);
        }
    }

    @Override
    public void delegate(String userId) {
        this.setDelegationState(DelegationState.PENDING);
        if (this.getOwner() == null) {
            this.setOwner(this.getAssignee());
        }
        this.setAssignee(userId, true, true);
    }

    public void resolve() {
        this.setDelegationState(DelegationState.RESOLVED);
        this.setAssignee(this.owner, true, true);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("assignee", this.assignee);
        persistentState.put("owner", this.owner);
        persistentState.put("name", this.name);
        persistentState.put("priority", this.priority);
        if (this.executionId != null) {
            persistentState.put("executionId", this.executionId);
        }
        if (this.processDefinitionId != null) {
            persistentState.put("processDefinitionId", this.processDefinitionId);
        }
        if (this.createTime != null) {
            persistentState.put("createTime", this.createTime);
        }
        if (this.description != null) {
            persistentState.put("description", this.description);
        }
        if (this.dueDate != null) {
            persistentState.put("dueDate", this.dueDate);
        }
        if (this.parentTaskId != null) {
            persistentState.put("parentTaskId", this.parentTaskId);
        }
        if (this.delegationState != null) {
            persistentState.put("delegationState", (Object)this.delegationState);
        }
        persistentState.put("suspensionState", this.suspensionState);
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        if (this.taskType != null) {
            persistentState.put("taskType", this.taskType);
        }
        persistentState.put("preempted", this.preempted);
        if (this.createHistoryTaskId != null) {
            persistentState.put("createHistoryTaskId", this.createHistoryTaskId);
        }
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        if (this.getExecution() != null) {
            return this.execution;
        }
        return null;
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setTaskId(this.id);
        variableInstance.setExecutionId(this.executionId);
        variableInstance.setProcessInstanceId(this.processInstanceId);
    }

    @Override
    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceEntityManager().findVariableInstancesByTaskId(this.id);
    }

    @Override
    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableInstanceEntity result = super.createVariableInstance(variableName, value, sourceActivityExecution);
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createVariableEvent(ActivitiEventType.VARIABLE_CREATED, variableName, value, result.getType(), result.getTaskId(), result.getExecutionId(), this.getProcessInstanceId(), this.getProcessDefinitionId()));
        }
        return result;
    }

    @Override
    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        super.updateVariableInstance(variableInstance, value, sourceActivityExecution);
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createVariableEvent(ActivitiEventType.VARIABLE_UPDATED, variableInstance.getName(), value, variableInstance.getType(), variableInstance.getTaskId(), variableInstance.getExecutionId(), this.getProcessInstanceId(), this.getProcessDefinitionId()));
        }
    }

    @Override
    public ExecutionEntity getExecution() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
        }
        return this.execution;
    }

    public void setExecution(DelegateExecution execution) {
        if (execution != null) {
            this.execution = (ExecutionEntity)execution;
            this.executionId = this.execution.getId();
            this.processInstanceId = this.execution.getProcessInstanceId();
            this.processDefinitionId = this.execution.getProcessDefinitionId();
            Context.getCommandContext().getHistoryManager().recordTaskExecutionIdChange(this.id, this.executionId);
        } else {
            this.execution = null;
            this.executionId = null;
            this.processInstanceId = null;
            this.processDefinitionId = null;
        }
    }

    public IdentityLinkEntity addIdentityLink(String userId, String groupId, String type) {
        return this.addIdentityLink(userId, groupId, type, null, null, null);
    }

    public IdentityLinkEntity addIdentityLink(String userId, String groupId, String type, String mandator, String taskState, String assistInitiator) {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        this.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setTask(this);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        identityLinkEntity.setMandator(mandator);
        identityLinkEntity.setTaskState(taskState);
        identityLinkEntity.setAssistInitiator(assistInitiator);
        identityLinkEntity.insert();
        return identityLinkEntity;
    }

    public void deleteIdentityLink(String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinkByTaskUserGroupAndType(this.id, userId, groupId, type);
        ArrayList<String> identityLinkIds = new ArrayList<String>();
        for (IdentityLinkEntity identityLink : identityLinks) {
            Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(identityLink, true);
            identityLinkIds.add(identityLink.getId());
        }
        ArrayList<IdentityLinkEntity> removedIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
        for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
            if (!"candidate".equals(identityLinkEntity.getType()) || identityLinkIds.contains(identityLinkEntity.getId()) || (userId == null || !userId.equals(identityLinkEntity.getUserId())) && (groupId == null || !groupId.equals(identityLinkEntity.getGroupId()))) continue;
            Context.getCommandContext().getIdentityLinkEntityManager().deleteIdentityLink(identityLinkEntity, true);
            removedIdentityLinkEntities.add(identityLinkEntity);
        }
        this.getIdentityLinks().removeAll(removedIdentityLinkEntities);
    }

    @Override
    public List<IdentityLinkEntity> getCandidates() {
        if (this.typeOfPreempted()) {
            ArrayList<IdentityLinkEntity> potentialOwners = new ArrayList<IdentityLinkEntity>();
            for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
                if (!"candidate".equals(identityLinkEntity.getType())) continue;
                potentialOwners.add(identityLinkEntity);
            }
            return potentialOwners;
        }
        return this.getIdentityLinks();
    }

    @Override
    public void addCandidateUser(String userId) {
        this.addIdentityLink(userId, null, "candidate");
    }

    @Override
    public void addCandidateUser(String userId, String mandator, String taskState) {
        if (mandator == null || mandator.equals("")) {
            taskState = null;
        }
        this.addIdentityLink(userId, null, "candidate", mandator, taskState, null);
    }

    @Override
    public void addCandidateUser(String userId, String mandator, String taskState, String assistInitiator) {
        if (mandator == null || mandator.equals("")) {
            taskState = null;
        }
        this.addIdentityLink(userId, null, "candidate", mandator, taskState, assistInitiator);
    }

    @Override
    public void addEntrustCandidateUser(Map<String, String> map) {
        this.addEntrustAssistCandidateUser(map, null);
    }

    @Override
    public void addEntrustAssistCandidateUser(Map<String, String> map, String assistInitiator) {
        for (String userId : map.keySet()) {
            if (map.get(userId) == null) {
                this.addCandidateUser(userId, null, null, assistInitiator);
                continue;
            }
            this.addCandidateUser(map.get(userId), userId, "1", assistInitiator);
        }
    }

    @Override
    public void addCandidateUsers(Collection<String> candidateUsers) {
        for (String candidateUser : candidateUsers) {
            this.addCandidateUser(candidateUser);
        }
    }

    @Override
    public void addCandidateGroup(String groupId) {
        this.addIdentityLink(null, groupId, "candidate");
    }

    @Override
    public void addCandidateGroups(Collection<String> candidateGroups) {
        for (String candidateGroup : candidateGroups) {
            this.addCandidateGroup(candidateGroup);
        }
    }

    @Override
    public void addGroupIdentityLink(String groupId, String identityLinkType) {
        this.addIdentityLink(null, groupId, identityLinkType);
    }

    @Override
    public void addUserIdentityLink(String userId, String identityLinkType) {
        this.addIdentityLink(userId, null, identityLinkType);
    }

    @Override
    public void deleteCandidateGroup(String groupId) {
        this.deleteGroupIdentityLink(groupId, "candidate");
    }

    @Override
    public void deleteCandidateUser(String userId) {
        this.deleteUserIdentityLink(userId, "candidate");
    }

    @Override
    public void deleteGroupIdentityLink(String groupId, String identityLinkType) {
        if (groupId != null) {
            this.deleteIdentityLink(null, groupId, identityLinkType);
        }
    }

    @Override
    public void deleteUserIdentityLink(String userId, String identityLinkType) {
        if (userId != null) {
            this.deleteIdentityLink(userId, null, identityLinkType);
        }
    }

    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.taskIdentityLinkEntities = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinksByTaskId(this.id);
            this.isIdentityLinksInitialized = true;
        }
        return this.taskIdentityLinkEntities;
    }

    public Map<String, Object> getActivityInstanceVariables() {
        if (this.execution != null) {
            return this.execution.getVariables();
        }
        return Collections.EMPTY_MAP;
    }

    public void setExecutionVariables(Map<String, Object> parameters) {
        if (this.getExecution() != null) {
            this.execution.setVariables(parameters);
        }
    }

    public String toString() {
        return "Task[id=" + this.id + ", name=" + this.name + "]";
    }

    @Override
    public void setName(String taskName) {
        this.name = taskName;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskNameChange(this.id, taskName);
        }
    }

    public void setNameWithoutCascade(String taskName) {
        this.name = taskName;
    }

    @Override
    public void setLocalizedName(String name) {
        this.localizedName = name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskDescriptionChange(this.id, description);
        }
    }

    public void setDescriptionWithoutCascade(String description) {
        this.description = description;
    }

    @Override
    public void setLocalizedDescription(String description) {
        this.localizedDescription = description;
    }

    @Override
    public void setAssignee(String assignee) {
        this.setAssignee(assignee, false, false);
    }

    public void setAssignee(String assignee, boolean dispatchAssignmentEvent, boolean dispatchUpdateEvent) {
        CommandContext commandContext = Context.getCommandContext();
        if (assignee == null && this.assignee == null) {
            if (commandContext != null) {
                commandContext.getHistoryManager().recordTaskAssigneeChange(this.id, assignee);
            }
            return;
        }
        this.assignee = assignee;
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskAssigneeChange(this.id, assignee);
            if (assignee != null && this.processInstanceId != null) {
                this.getProcessInstance().involveUser(assignee, "participant");
            }
            if (!StringUtils.equals((CharSequence)this.initialAssignee, (CharSequence)assignee)) {
                this.fireEvent("assignment");
                this.initialAssignee = assignee;
            }
            if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                if (dispatchAssignmentEvent) {
                    commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_ASSIGNED, this));
                }
                if (dispatchUpdateEvent) {
                    commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, this));
                }
            }
        }
    }

    public void setAssigneeWithoutCascade(String assignee) {
        this.assignee = assignee;
        this.initialAssignee = assignee;
    }

    @Override
    public void setOwner(String owner) {
        this.setOwner(owner, false);
    }

    public void setOwner(String owner, boolean dispatchUpdateEvent) {
        if (owner == null && this.owner == null) {
            return;
        }
        this.owner = owner;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskOwnerChange(this.id, owner);
            if (owner != null && this.processInstanceId != null) {
                this.getProcessInstance().involveUser(owner, "participant");
            }
            if (dispatchUpdateEvent && commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && dispatchUpdateEvent) {
                commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, this));
            }
        }
    }

    public void setOwnerWithoutCascade(String owner) {
        this.owner = owner;
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.setDueDate(dueDate, false);
    }

    public void setDueDate(Date dueDate, boolean dispatchUpdateEvent) {
        this.dueDate = dueDate;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskDueDateChange(this.id, dueDate);
            if (dispatchUpdateEvent && commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && dispatchUpdateEvent) {
                commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, this));
            }
        }
    }

    public void setDueDateWithoutCascade(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    public void setPriority(int priority) {
        this.setPriority(priority, false);
    }

    public void setPriority(int priority, boolean dispatchUpdateEvent) {
        this.priority = priority;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskPriorityChange(this.id, priority);
            if (dispatchUpdateEvent && commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && dispatchUpdateEvent) {
                commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, this));
            }
        }
    }

    public void setCategoryWithoutCascade(String category) {
        this.category = category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskCategoryChange(this.id, category);
        }
    }

    public void setPriorityWithoutCascade(int priority) {
        this.priority = priority;
    }

    @Override
    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskParentTaskIdChange(this.id, parentTaskId);
        }
    }

    public void setParentTaskIdWithoutCascade(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public void setTaskDefinitionKeyWithoutCascade(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @Override
    public String getFormKey() {
        return this.formKey;
    }

    @Override
    public void setFormKey(String formKey) {
        this.formKey = formKey;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskFormKeyChange(this.id, formKey);
        }
    }

    public void setFormKeyWithoutCascade(String formKey) {
        this.formKey = formKey;
    }

    public void fireEvent(String taskEventName) {
        TaskDefinition taskDefinition = this.getTaskDefinition();
        if (taskDefinition != null) {
            List<TaskListener> taskEventListeners;
            Process process;
            FlowElement flowElement;
            BpmnModel bpmnModel = Context.getProcessEngineConfiguration().getRepositoryService().getBpmnModel(this.processDefinitionId);
            if (bpmnModel != null && (flowElement = (process = bpmnModel.getMainProcess()).getFlowElement(taskDefinition.getKey())) != null) {
                Map extensionElementsNode = flowElement.getExtensionElements();
                List list = (List)extensionElementsNode.get("extendTaskListener");
                ExecutionEntity executionEntity = this.getExecution();
                ProcessDefinitionImpl processDefinition = executionEntity.getProcessDefinition();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("processName", processDefinition.getName());
                paramMap.put("processDefinitionKey", processDefinition.getKey());
                paramMap.put("processDefinitionId", this.getProcessDefinitionId());
                paramMap.put("processBusinessKey", executionEntity.getProcessBusinessKey());
                paramMap.put("businessKey", executionEntity.getBusinessKey());
                paramMap.put("tenantId", executionEntity.getTenantId());
                paramMap.put("processInstanceId", this.getProcessInstanceId());
                paramMap.put("taskId", this.getId());
                paramMap.put("taskDefinitionName", this.getName());
                paramMap.put("taskDefinitionKey", this.getTaskDefinitionKey());
                if (list != null && list.size() > 0) {
                    for (ExtensionElement extensionElement : list) {
                        Map map = extensionElement.getAttributes();
                        String event = ((ExtensionAttribute)((List)map.get("event")).get(0)).getValue();
                        if (!taskEventName.equals(event)) continue;
                        String type = ((ExtensionAttribute)((List)map.get("type")).get(0)).getValue();
                        String url = ((ExtensionAttribute)((List)map.get("url")).get(0)).getValue();
                        try {
                            if (!"POST".equals(type)) continue;
                        }
                        catch (Exception e) {
                            throw new ActivitiException("Exception while invoking HTPPTaskListener: " + e.getMessage(), e);
                        }
                    }
                }
            }
            if ((taskEventListeners = this.getTaskDefinition().getTaskListener(taskEventName)) != null) {
                for (TaskListener taskListener : taskEventListeners) {
                    ExecutionEntity execution = this.getExecution();
                    if (execution != null) {
                        this.setEventName(taskEventName);
                    }
                    try {
                        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(taskListener, this));
                    }
                    catch (Exception e) {
                        boolean isAsyn = false;
                        if (taskListener instanceof DelegateExpressionTaskListener) {
                            List<FieldDeclaration> fieldExtensionList = ((DelegateExpressionTaskListener)taskListener).getFieldDeclarations();
                            for (FieldDeclaration fieldExtension : fieldExtensionList) {
                                String stringValue;
                                FixedValue newValue;
                                Object realValue;
                                String name = fieldExtension.getName();
                                if (!"isAsyn".equals(name)) continue;
                                Object value = fieldExtension.getValue();
                                if (!(value instanceof FixedValue) || (realValue = (newValue = (FixedValue)value).getValue(null)) == null || !"true".equals(stringValue = realValue.toString())) break;
                                isAsyn = true;
                                break;
                            }
                        }
                        if (isAsyn) continue;
                        throw new ActivitiException("Exception while invoking TaskListener: " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    public boolean isAsyn(String taskEventName) {
        boolean flag = false;
        List<TaskListener> taskEventListeners = this.getTaskDefinition().getTaskListener(taskEventName);
        for (TaskListener taskListener : taskEventListeners) {
            if (!(taskListener instanceof ClassDelegate)) continue;
            boolean findFlag = false;
            ClassDelegate delegate = (ClassDelegate)taskListener;
            List<FieldDeclaration> fieldExtensionList = delegate.getFieldDeclarations();
            for (FieldDeclaration fieldExtension : fieldExtensionList) {
                String stringValue;
                FixedValue newValue;
                Object realValue;
                String name = fieldExtension.getName();
                if (!"isAsyn".equals(name)) continue;
                Object value = fieldExtension.getValue();
                if (value instanceof FixedValue && (realValue = (newValue = (FixedValue)value).getValue(null)) != null && "true".equals(stringValue = realValue.toString())) {
                    flag = true;
                }
                findFlag = true;
                break;
            }
            if (!findFlag) continue;
            break;
        }
        return flag;
    }

    @Override
    protected boolean isActivityIdUsedForDetails() {
        return false;
    }

    @Override
    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new ActivitiException("lazy loading outside command context");
        }
        VariableInstanceEntity variableInstance = commandContext.getVariableInstanceEntityManager().findVariableInstanceByTaskAndName(this.id, variableName);
        return variableInstance;
    }

    @Override
    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new ActivitiException("lazy loading outside command context");
        }
        return commandContext.getVariableInstanceEntityManager().findVariableInstancesByTaskAndNames(this.id, variableNames);
    }

    public void setTaskDefinition(TaskDefinition taskDefinition) {
        this.taskDefinition = taskDefinition;
        this.taskDefinitionKey = taskDefinition.getKey();
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskDefinitionKeyChange(this, this.taskDefinitionKey);
        }
    }

    public TaskDefinition getTaskDefinition() {
        if (this.taskDefinition == null && this.taskDefinitionKey != null) {
            ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
            this.taskDefinition = processDefinition.getTaskDefinitions().get(this.taskDefinitionKey);
        }
        return this.taskDefinition;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.getHistoryManager().recordTaskDefinitionKeyChange(this, taskDefinitionKey);
        }
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public ExecutionEntity getProcessInstance() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.processInstanceId);
        }
        return this.processInstance;
    }

    @Override
    public String getCreateHistoryTaskId() {
        return this.createHistoryTaskId;
    }

    public void setCreateHistoryTaskId(String createHistoryTaskId) {
        this.createHistoryTaskId = createHistoryTaskId;
    }

    public String getUrgeState() {
        return this.urgeState;
    }

    public void setUrgeState(String urgeState) {
        this.urgeState = urgeState;
    }

    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = processInstance;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    @Override
    public void setDelegationState(DelegationState delegationState) {
        this.delegationState = delegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public void setDelegationStateString(String delegationStateString) {
        this.delegationState = delegationStateString != null ? DelegationState.valueOf(DelegationState.class, delegationStateString) : null;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    @Override
    public Map<String, VariableInstanceEntity> getVariableInstanceEntities() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public Map<String, Object> getTaskLocalVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() == null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getPreempted() {
        return this.preempted;
    }

    public void setPreempted(String preempted) {
        this.preempted = preempted;
    }

    @Override
    public boolean typeOfPreempted() {
        return this.preempted != null;
    }

    public List<VariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new VariableInitializingList();
        }
        return this.queryVariables;
    }

    @Override
    public String getSubProcessKey() {
        return this.subProcessKey;
    }

    public void setSubProcessKey(String subProcessKey) {
        this.subProcessKey = subProcessKey;
    }

    @Override
    public Integer getCycleCount() {
        return this.cycleCount;
    }

    public void setCycleCount(Integer cycleCount) {
        this.cycleCount = cycleCount;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    @Override
    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @Override
    public List<IdentityLinkEntity> getIdentityLinkType(String identityLinkType) {
        ArrayList<IdentityLinkEntity> identityLinks = new ArrayList<IdentityLinkEntity>();
        for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
            if (!identityLinkEntity.getType().equals(identityLinkType)) continue;
            identityLinks.add(identityLinkEntity);
        }
        return identityLinks;
    }
}

