/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.db;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.EntityDependencyOrder;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.persistence.entity.EventLogEntryEntity;
import org.apache.ibatis.session.SqlSessionFactory;

public class DbSqlSessionFactory
implements SessionFactory {
    protected static final Map<String, Map<String, String>> databaseSpecificStatements = new HashMap<String, Map<String, String>>();
    public static final Map<String, String> databaseSpecificLimitBeforeStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitAfterStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBetweenStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificOrderByStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseOuterJoinLimitBetweenStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBeforeNativeQueryStatements = new HashMap<String, String>();
    protected static Map<Class<? extends PersistentObject>, Boolean> bulkInsertableMap;
    protected String databaseType;
    protected String databaseTablePrefix = "";
    private boolean tablePrefixIsSchema;
    protected String databaseCatalog;
    protected String databaseSchema;
    protected SqlSessionFactory sqlSessionFactory;
    protected IdGenerator idGenerator;
    protected Map<String, String> statementMappings;
    protected Map<Class<?>, String> insertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> bulkInsertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> updateStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> deleteStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> bulkDeleteStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> selectStatements = new ConcurrentHashMap();
    protected boolean isDbIdentityUsed = true;
    protected boolean isDbHistoryUsed = true;
    protected int maxNrOfStatementsInBulkInsert = 100;

    @Override
    public Class<?> getSessionType() {
        return DbSqlSession.class;
    }

    @Override
    public Session openSession() {
        return new DbSqlSession(this);
    }

    public String getInsertStatement(PersistentObject object) {
        return this.getStatement(object.getClass(), this.insertStatements, "insert");
    }

    public String getInsertStatement(Class<? extends PersistentObject> clazz) {
        return this.getStatement(clazz, this.insertStatements, "insert");
    }

    public String getBulkInsertStatement(Class clazz) {
        return this.getStatement(clazz, this.bulkInsertStatements, "bulkInsert");
    }

    public String getUpdateStatement(PersistentObject object) {
        return this.getStatement(object.getClass(), this.updateStatements, "update");
    }

    public String getDeleteStatement(Class<?> persistentObjectClass) {
        return this.getStatement(persistentObjectClass, this.deleteStatements, "delete");
    }

    public String getBulkDeleteStatement(Class<?> persistentObjectClass) {
        return this.getStatement(persistentObjectClass, this.bulkDeleteStatements, "bulkDelete");
    }

    public String getSelectStatement(Class<?> persistentObjectClass) {
        return this.getStatement(persistentObjectClass, this.selectStatements, "select");
    }

    private String getStatement(Class<?> persistentObjectClass, Map<Class<?>, String> cachedStatements, String prefix) {
        String statement = cachedStatements.get(persistentObjectClass);
        if (statement != null) {
            return statement;
        }
        statement = prefix + persistentObjectClass.getSimpleName();
        statement = statement.substring(0, statement.length() - 6);
        cachedStatements.put(persistentObjectClass, statement);
        return statement;
    }

    protected static void addDatabaseSpecificStatement(String databaseType, String activitiStatement, String ibatisStatement) {
        Map<String, String> specificStatements = databaseSpecificStatements.get(databaseType);
        if (specificStatements == null) {
            specificStatements = new HashMap<String, String>();
            databaseSpecificStatements.put(databaseType, specificStatements);
        }
        specificStatements.put(activitiStatement, ibatisStatement);
    }

    public String mapStatement(String statement) {
        if (this.statementMappings == null) {
            return statement;
        }
        String mappedStatement = this.statementMappings.get(statement);
        return mappedStatement != null ? mappedStatement : statement;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        this.statementMappings = databaseSpecificStatements.get(databaseType);
    }

    public void setBulkInsertEnabled(boolean isBulkInsertEnabled, String databaseType) {
        if (isBulkInsertEnabled) {
            this.initBulkInsertEnabledMap(databaseType);
        }
    }

    protected void initBulkInsertEnabledMap(String databaseType) {
        bulkInsertableMap = new HashMap<Class<? extends PersistentObject>, Boolean>();
        for (Class<? extends PersistentObject> clazz : EntityDependencyOrder.INSERT_ORDER) {
            bulkInsertableMap.put(clazz, Boolean.TRUE);
        }
        if ("oracle".equals(databaseType)) {
            bulkInsertableMap.put(EventLogEntryEntity.class, Boolean.FALSE);
        }
    }

    public Boolean isBulkInsertable(Class<? extends PersistentObject> persistentObjectClass) {
        return bulkInsertableMap != null && bulkInsertableMap.containsKey(persistentObjectClass) && bulkInsertableMap.get(persistentObjectClass) == true;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, String> getStatementMappings() {
        return this.statementMappings;
    }

    public void setStatementMappings(Map<String, String> statementMappings) {
        this.statementMappings = statementMappings;
    }

    public Map<Class<?>, String> getInsertStatements() {
        return this.insertStatements;
    }

    public void setInsertStatements(Map<Class<?>, String> insertStatements) {
        this.insertStatements = insertStatements;
    }

    public Map<Class<?>, String> getBulkInsertStatements() {
        return this.bulkInsertStatements;
    }

    public void setBulkInsertStatements(Map<Class<?>, String> bulkInsertStatements) {
        this.bulkInsertStatements = bulkInsertStatements;
    }

    public Map<Class<?>, String> getUpdateStatements() {
        return this.updateStatements;
    }

    public void setUpdateStatements(Map<Class<?>, String> updateStatements) {
        this.updateStatements = updateStatements;
    }

    public Map<Class<?>, String> getDeleteStatements() {
        return this.deleteStatements;
    }

    public void setDeleteStatements(Map<Class<?>, String> deleteStatements) {
        this.deleteStatements = deleteStatements;
    }

    public Map<Class<?>, String> getBulkDeleteStatements() {
        return this.bulkDeleteStatements;
    }

    public void setBulkDeleteStatements(Map<Class<?>, String> bulkDeleteStatements) {
        this.bulkDeleteStatements = bulkDeleteStatements;
    }

    public Map<Class<?>, String> getSelectStatements() {
        return this.selectStatements;
    }

    public void setSelectStatements(Map<Class<?>, String> selectStatements) {
        this.selectStatements = selectStatements;
    }

    public boolean isDbIdentityUsed() {
        return this.isDbIdentityUsed;
    }

    public void setDbIdentityUsed(boolean isDbIdentityUsed) {
        this.isDbIdentityUsed = isDbIdentityUsed;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public void setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public String getDatabaseCatalog() {
        return this.databaseCatalog;
    }

    public void setDatabaseCatalog(String databaseCatalog) {
        this.databaseCatalog = databaseCatalog;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public void setTablePrefixIsSchema(boolean tablePrefixIsSchema) {
        this.tablePrefixIsSchema = tablePrefixIsSchema;
    }

    public boolean isTablePrefixIsSchema() {
        return this.tablePrefixIsSchema;
    }

    public int getMaxNrOfStatementsInBulkInsert() {
        return this.maxNrOfStatementsInBulkInsert;
    }

    public void setMaxNrOfStatementsInBulkInsert(int maxNrOfStatementsInBulkInsert) {
        this.maxNrOfStatementsInBulkInsert = maxNrOfStatementsInBulkInsert;
    }

    static {
        String defaultOrderBy = " order by ${orderByColumns} ";
        databaseSpecificLimitBeforeStatements.put("h2", "");
        databaseSpecificLimitAfterStatements.put("h2", "LIMIT #{maxResults} OFFSET #{firstResult}");
        databaseSpecificLimitBetweenStatements.put("h2", "");
        databaseOuterJoinLimitBetweenStatements.put("h2", "");
        databaseSpecificOrderByStatements.put("h2", defaultOrderBy);
        databaseSpecificLimitBeforeStatements.put("hsql", "");
        databaseSpecificLimitAfterStatements.put("hsql", "LIMIT #{maxResults} OFFSET #{firstResult}");
        databaseSpecificLimitBetweenStatements.put("hsql", "");
        databaseOuterJoinLimitBetweenStatements.put("hsql", "");
        databaseSpecificOrderByStatements.put("hsql", defaultOrderBy);
        databaseSpecificLimitBeforeStatements.put("mysql", "");
        databaseSpecificLimitAfterStatements.put("mysql", "LIMIT #{maxResults} OFFSET #{firstResult}");
        databaseSpecificLimitBetweenStatements.put("mysql", "");
        databaseOuterJoinLimitBetweenStatements.put("mysql", "");
        databaseSpecificOrderByStatements.put("mysql", defaultOrderBy);
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectProcessDefinitionsByQueryCriteria", "selectProcessDefinitionsByQueryCriteria_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectProcessDefinitionCountByQueryCriteria", "selectProcessDefinitionCountByQueryCriteria_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectDeploymentsByQueryCriteria", "selectDeploymentsByQueryCriteria_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectDeploymentCountByQueryCriteria", "selectDeploymentCountByQueryCriteria_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "selectModelCountByQueryCriteria", "selectModelCountByQueryCriteria_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "updateExecutionTenantIdForDeployment", "updateExecutionTenantIdForDeployment_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "updateTaskTenantIdForDeployment", "updateTaskTenantIdForDeployment_mysql");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mysql", "updateJobTenantIdForDeployment", "updateJobTenantIdForDeployment_mysql");
        databaseSpecificLimitBeforeStatements.put("postgres", "");
        databaseSpecificLimitAfterStatements.put("postgres", "LIMIT #{maxResults} OFFSET #{firstResult}");
        databaseSpecificLimitBetweenStatements.put("postgres", "");
        databaseOuterJoinLimitBetweenStatements.put("postgres", "");
        databaseSpecificOrderByStatements.put("postgres", defaultOrderBy);
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertByteArray", "insertByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertByteArray", "bulkInsertByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateByteArray", "updateByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectByteArray", "selectByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectResourceByDeploymentIdAndResourceName", "selectResourceByDeploymentIdAndResourceName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectResourcesByDeploymentId", "selectResourcesByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertIdentityInfo", "insertIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertIdentityInfo", "bulkInsertIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateIdentityInfo", "updateIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityInfoById", "selectIdentityInfoById_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityInfoByUserIdAndKey", "selectIdentityInfoByUserIdAndKey_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityInfoByUserId", "selectIdentityInfoByUserId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityInfoDetails", "selectIdentityInfoDetails_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertComment", "insertComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertComment", "bulkInsertComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectComment", "selectComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectCommentsByTaskId", "selectCommentsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectCommentsByProcessInstanceId", "selectCommentsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectCommentsByProcessInstanceIdAndType", "selectCommentsByProcessInstanceIdAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectCommentsByType", "selectCommentsByType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectCommentsByTaskIdAndType", "selectCommentsByTaskIdAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventsByTaskId", "selectEventsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertEventLogEntry", "insertEventLogEntry_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertEventLogEntry", "bulkInsertEventLogEntry_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectAllEventLogEntries", "selectAllEventLogEntries_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventLogEntries", "selectEventLogEntries_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventLogEntriesByProcessInstanceId", "selectEventLogEntriesByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectDeploymentById", "selectDeploymentById_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectProcessDefinitionByDeploymentAndKeyAndTenantId", "selectProcessDefinitionByDeploymentAndKeyAndTenantId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertModel", "insertModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertModel", "bulkInsertModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateModel", "updateModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteModel", "deleteModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectModelsByQueryCriteriaSql", "selectModelsByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectModel", "selectModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertProcessDefinition", "insertProcessDefinition_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertDeployment", "insertDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertResource", "bulkInsertResource_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectProcessDefinitionsByQueryCriteria", "selectProcessDefinitionsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectProcessDefinitionsByQueryCriteriaSql", "bulkInsertResource_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityLinksByProcessInstance", "selectIdentityLinksByProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectJobsByExecutionId", "selectJobsByExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTasksByExecutionId", "selectTasksByExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectVariablesByTaskId", "selectVariablesByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricTaskInstanceCountByQueryCriteria", "selectHistoricTaskInstanceCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricTaskInstancesByQueryCriteriaSql", "selectHistoricTaskInstancesByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricProcessInstancesByQueryCriteria", "selectHistoricProcessInstancesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertHistoricVariableInstance", "bulkInsertHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertHistoricTaskInstance", "insertHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertHistoricProcessInstance", "insertHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertHistoricProcessInstance", "bulkInsertHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertHistoricActivityInstance", "bulkInsertHistoricActivityInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertHistoricIdentityLink", "bulkInsertHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertExecution", "insertExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertTask", "insertTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertIdentityLink", "bulkInsertIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertVariableInstance", "bulkInsertVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertAttachment", "insertAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertAttachment", "bulkInsertAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateAttachment", "updateAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteAttachment", "deleteAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectAttachment", "selectAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectAttachmentsByTaskId", "selectAttachmentsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectAttachmentsByProcessInstanceId", "selectAttachmentsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectBytesOfByteArray", "selectBytesOfByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteByteArraysForDeployment", "deleteByteArraysForDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteByteArray", "deleteByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteByteArrayNoRevisionCheck", "deleteByteArrayNoRevisionCheck_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteComment", "deleteComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteCommentsByTaskId", "deleteCommentsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteCommentsByProcessInstanceId", "deleteCommentsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventsByProcessInstanceId", "selectEventsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertDeployment", "bulkInsertDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateDeployment", "updateDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteDeployment", "deleteDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectDeploymentsByQueryCriteria", "selectDeploymentsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteEventLogEntry", "deleteEventLogEntry_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteSignalEventSubscription", "deleteSignalEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteCompensateEventSubscription", "deleteCompensateEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteMessageEventSubscription", "deleteMessageEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteEventSubscriptionsForProcessDefinition", "deleteEventSubscriptionsForProcessDefinition_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventSubscription", "selectEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventSubscriptionByQueryCriteria", "selectEventSubscriptionByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventSubscriptionCountByQueryCriteria", "selectEventSubscriptionCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventSubscriptionByQueryCriteriaSql", "selectEventSubscriptionByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectSignalEventSubscriptionsByProcessInstanceAndEventName", "selectSignalEventSubscriptionsByProcessInstanceAndEventName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectSignalEventSubscriptionsByExecution", "selectSignalEventSubscriptionsByExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectSignalEventSubscriptionsByNameAndExecution", "selectSignalEventSubscriptionsByNameAndExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventSubscriptionsByExecution", "selectEventSubscriptionsByExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventSubscriptionsByExecutionAndType", "selectEventSubscriptionsByExecutionAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventSubscriptionsByExecutionTypeAndActivity", "selectEventSubscriptionsByExecutionTypeAndActivity_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventSubscriptionsByTypeAndProcessDefinitionId", "selectEventSubscriptionsByTypeAndProcessDefinitionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectEventSubscriptionsByNameAndExecution", "selectEventSubscriptionsByNameAndExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertMessageEventSubscription", "insertMessageEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertMessageEventSubscription", "bulkInsertMessageEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateMessageEventSubscription", "updateMessageEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertSignalEventSubscription", "insertSignalEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertSignalEventSubscription", "bulkInsertSignalEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateSignalEventSubscription", "updateSignalEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertCompensateEventSubscription", "insertCompensateEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertCompensateEventSubscription", "bulkInsertCompensateEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateCompensateEventSubscription", "updateCompensateEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTaskByQueryCriteria", "selectTaskByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTask", "selectTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectVariableInstanceByTaskAndName", "selectVariableInstanceByTaskAndName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectVariableInstancesByTaskAndNames", "selectVariableInstancesByTaskAndNames_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertHistoricVariableInstance", "insertHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertVariableInstance", "insertVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertGroup", "insertGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertGroup", "bulkInsertGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateGroup", "updateGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteGroup", "deleteGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectGroup", "selectGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectGroupsByUserId", "selectGroupsByUserId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectGroupsByUserIdAndGroupType", "selectGroupsByUserIdAndGroupType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectGroupByQueryCriteria", "selectGroupByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateTask", "updateTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertHistoricActivityInstance", "insertHistoricActivityInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateHistoricActivityInstance", "updateHistoricActivityInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteHistoricActivityInstancesByProcessInstanceId", "deleteHistoricActivityInstancesByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricActivityInstance", "selectHistoricActivityInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricActivityInstancesByQueryCriteria", "selectHistoricActivityInstancesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricActivityInstanceCountByQueryCriteria", "selectHistoricActivityInstanceCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricActivityInstancesByQueryCriteriaSql", "selectHistoricActivityInstancesByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityLinksByTask", "selectIdentityLinksByTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertHistoricFormProperty", "insertHistoricFormProperty_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertHistoricFormProperty", "bulkInsertHistoricFormProperty_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertHistoricDetailVariableInstanceUpdate", "insertHistoricDetailVariableInstanceUpdate_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertHistoricDetailVariableInstanceUpdate", "bulkInsertHistoricDetailVariableInstanceUpdate_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteHistoricDetailAssignment", "deleteHistoricDetailAssignment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteHistoricDetailTransitionInstance", "deleteHistoricDetailTransitionInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteHistoricDetailVariableInstanceUpdate", "deleteHistoricDetailVariableInstanceUpdate_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteHistoricFormProperty", "deleteHistoricFormProperty_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricDetailsByQueryCriteria", "selectHistoricDetailsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricDetailCountByQueryCriteria", "selectHistoricDetailCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricDetailsByQueryCriteriaSql", "selectHistoricDetailsByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertHistoricIdentityLink", "insertHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteHistoricIdentityLink", "deleteHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkDeleteHistoricIdentityLink", "bulkDeleteHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricIdentityLink", "selectHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricIdentityLinksByTask", "selectHistoricIdentityLinksByTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricIdentityLinksByProcessInstance", "selectHistoricIdentityLinksByProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricIdentityLinkByTaskUserGroupAndType", "selectHistoricIdentityLinkByTaskUserGroupAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateHistoricProcessInstance", "updateHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteHistoricProcessInstance", "deleteHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkDeleteHistoricProcessInstance", "bulkDeleteHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricProcessInstance", "selectHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertHistoricTaskInstance", "bulkInsertHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateHistoricTaskInstance", "updateHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteHistoricTaskInstance", "deleteHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkDeleteHistoricTaskInstance", "bulkDeleteHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricTaskInstance", "selectHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricTasksByParentTaskId", "selectHistoricTasksByParentTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricTaskInstanceIdsByProcessInstanceId", "selectHistoricTaskInstanceIdsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteIdentityInfo", "deleteIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertIdentityLink", "insertIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteIdentityLink", "deleteIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityLink", "selectIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityLinkByTaskUserGroupAndType", "selectIdentityLinkByTaskUserGroupAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectIdentityLinkByProcessInstanceUserGroupAndType", "selectIdentityLinkByProcessInstanceUserGroupAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteJob", "deleteJob_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkDeleteJob", "bulkDeleteJob_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteTimer", "deleteTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkDeleteTimer", "bulkDeleteTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteMessage", "deleteMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkDeleteMessage", "bulkDeleteMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateJobTenantIdForDeployment", "updateJobTenantIdForDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectJob", "selectJob_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectJobByQueryCriteria", "selectJobByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectJobCountByQueryCriteria", "selectJobCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectJobByQueryCriteriaSql", "selectJobByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertTimer", "insertTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertTimer", "bulkInsertTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateTimer", "updateTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTimersByExecutionId", "selectTimersByExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertMessage", "bulkInsertMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertMessage", "insertMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateMessage", "updateMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "unacquireJob", "unacquireJob_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectModelsByQueryCriteria", "selectModelsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectModelCountByQueryCriteria", "selectModelCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertProcessDefinition", "bulkInsertProcessDefinition_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateProcessDefinition", "updateProcessDefinition_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateProcessDefinitionTenantIdForDeploymentId", "updateProcessDefinitionTenantIdForDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteProcessDefinitionsByDeploymentId", "deleteProcessDefinitionsByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectProcessDefinitionCountByQueryCriteria", "selectProcessDefinitionCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectProcessDefinitionsByQueryCriteriaSql", "selectProcessDefinitionsByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectProcessDefinitionByDeploymentAndKey", "selectProcessDefinitionByDeploymentAndKey_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertProcessDefinitionInfo", "insertProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertProcessDefinitionInfo", "bulkInsertProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateProcessDefinitionInfo", "updateProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteProcessDefinitionInfo", "deleteProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectProcessDefinitionInfo", "selectProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteProperty", "deleteProperty_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertResource", "insertResource_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteResourcesByDeploymentId", "deleteResourcesByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectResourceNamesByDeploymentId", "selectResourceNamesByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectResourceByDeploymentIdAndResourceName", "selectResourceByDeploymentIdAndResourceName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateVariableInstance", "updateVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteVariableInstance", "deleteVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkDeleteVariableInstance", "bulkDeleteVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectVariableInstance", "selectVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectVariablesByExecutionId", "selectVariablesByExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectVariablesByExecutionIds", "selectVariablesByExecutionIds_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectVariableInstanceByExecutionAndName", "selectVariableInstanceByExecutionAndName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectVariableInstancesByExecutionAndNames", "selectVariableInstancesByExecutionAndNames_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectVariablesByTaskIds", "selectVariablesByTaskIds_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertTask", "bulkInsertTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateTaskTenantIdForDeployment", "updateTaskTenantIdForDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteTask", "deleteTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkDeleteTask", "bulkDeleteTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTasksByParentTaskId", "selectTasksByParentTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTasksByProcessInstanceId", "selectTasksByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTaskCountByQueryCriteria", "selectTaskCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTaskByQueryCriteriaSql", "selectTaskByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTaskWithVariablesByQueryCriteria", "selectTaskWithVariablesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectTaskWithVariablesByQueryCriteriaSql", "selectTaskWithVariablesByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "commonSelectTaskByQueryCriteriaSql", "commonSelectTaskByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertExecution", "bulkInsertExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateExecution", "updateExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateExecutionTenantIdForDeployment", "updateExecutionTenantIdForDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateProcessInstanceLockTime", "updateProcessInstanceLockTime_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "clearProcessInstanceLockTime", "clearProcessInstanceLockTime_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteExecution", "deleteExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectExecution", "selectExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectExecutionsByParentExecutionId", "selectExecutionsByParentExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectSubProcessInstanceBySuperExecutionId", "selectSubProcessInstanceBySuperExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectExecutionsByProcessInstanceId", "selectExecutionsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectExecutionsByQueryCriteria", "selectExecutionsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricTaskInstancesByQueryCriteria", "selectHistoricTaskInstancesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricTaskInstancesWithVariablesByQueryCriteria", "selectHistoricTaskInstancesWithVariablesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricTaskInstancesWithVariablesByQueryCriteriaSql", "selectHistoricTaskInstancesWithVariablesByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "commonSelectHistoricTaskInstancesByQueryCriteriaSql", "commonSelectHistoricTaskInstancesByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkDeleteHistoricVariableInstance", "bulkDeleteHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteHistoricVariableInstance", "deleteHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateHistoricVariableInstance", "updateHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricVariableInstanceByQueryCriteria", "selectHistoricVariableInstanceByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricVariableInstanceCountByQueryCriteria", "selectHistoricVariableInstanceCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricVariableInstanceByQueryCriteriaSql", "selectHistoricVariableInstanceByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectHistoricVariableInstanceByVariableInstanceId", "selectHistoricVariableInstanceByVariableInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectProcessInstanceByQueryCriteria", "selectProcessInstanceByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectProcessInstanceCountByQueryCriteria", "selectProcessInstanceCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectExecutionsByQueryCriteriaSql", "selectExecutionsByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "commonSelectExecutionsByQueryCriteriaSql", "commonSelectExecutionsByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectGroupByQueryCriteriaSql", "selectGroupByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "insertUser", "insertUser_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "bulkInsertUser", "bulkInsertUser_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "updateUser", "updateUser_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "deleteUser", "deleteUser_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectUserById", "selectUserById_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectUserByQueryCriteria", "selectUserByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectUserCountByQueryCriteria", "selectUserCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("postgres", "selectUserByQueryCriteriaSql", "selectUserByQueryCriteriaSql_postgres");
        databaseSpecificLimitBeforeStatements.put("oracle", "select * from ( select a.*, ROWNUM rnum from (");
        databaseSpecificLimitAfterStatements.put("oracle", "  ) a where ROWNUM < #{lastRow}) where rnum  >= #{firstRow}");
        databaseSpecificLimitBetweenStatements.put("oracle", "");
        databaseOuterJoinLimitBetweenStatements.put("oracle", "");
        databaseSpecificOrderByStatements.put("oracle", defaultOrderBy);
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_integerBoolean");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "selectUnlockedTimersByDuedate", "selectUnlockedTimersByDuedate_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "insertEventLogEntry", "insertEventLogEntry_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertVariableInstance", "bulkInsertVariableInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertUser", "bulkInsertUser_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertTask", "bulkInsertTask_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertResource", "bulkInsertResource_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertProperty", "bulkInsertProperty_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertProcessDefinition", "bulkInsertProcessDefinition_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertModel", "bulkInsertModel_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertMembership", "bulkInsertMembership_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertTimer", "bulkInsertTimer_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertMessage", "bulkInsertMessage_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertIdentityInfo", "bulkInsertIdentityInfo_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertIdentityLink", "bulkInsertIdentityLink_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertMembership", "bulkInsertMembership_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertTimer", "bulkInsertTimer_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertMessage", "bulkInsertMessage_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertHistoricVariableInstance", "bulkInsertHistoricVariableInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertHistoricTaskInstance", "bulkInsertHistoricTaskInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertHistoricProcessInstance", "bulkInsertHistoricProcessInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertHistoricIdentityLink", "bulkInsertHistoricIdentityLink_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertHistoricDetailVariableInstanceUpdate", "bulkInsertHistoricDetailVariableInstanceUpdate_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertHistoricFormProperty", "bulkInsertHistoricFormProperty_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertHistoricActivityInstance", "bulkInsertHistoricActivityInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertGroup", "bulkInsertGroup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertExecution", "bulkInsertExecution_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertMessageEventSubscription", "bulkInsertMessageEventSubscription_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertSignalEventSubscription", "bulkInsertSignalEventSubscription_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertCompensateEventSubscription", "bulkInsertCompensateEventSubscription_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertEventLogEntry", "bulkInsertEventLogEntry_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertDeployment", "bulkInsertDeployment_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertComment", "bulkInsertComment_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertByteArray", "bulkInsertByteArray_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertEventLogEntry", "bulkInsertEventLogEntry_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertDeployment", "bulkInsertDeployment_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertComment", "bulkInsertComment_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertByteArray", "bulkInsertByteArray_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oracle", "bulkInsertAttachment", "bulkInsertAttachment_oracle");
        databaseSpecificLimitBeforeStatements.put("db2", "SELECT SUB.* FROM (");
        databaseSpecificLimitAfterStatements.put("db2", ")RES ) SUB WHERE SUB.rnk >= #{firstRow} AND SUB.rnk < #{lastRow}");
        databaseSpecificLimitBetweenStatements.put("db2", ", row_number() over (ORDER BY ${orderByColumns}) rnk FROM ( select distinct RES.* ");
        databaseOuterJoinLimitBetweenStatements.put("db2", ", row_number() over (ORDER BY ${mssqlOrDB2OrderBy}) rnk FROM ( select distinct ");
        databaseSpecificOrderByStatements.put("db2", "");
        databaseSpecificLimitBeforeNativeQueryStatements.put("db2", "SELECT SUB.* FROM ( select RES.* , row_number() over (ORDER BY ${orderByColumns}) rnk FROM (");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_integerBoolean");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectExecutionByNativeQuery", "selectExecutionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricActivityInstanceByNativeQuery", "selectHistoricActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricProcessInstanceByNativeQuery", "selectHistoricProcessInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricTaskInstanceByNativeQuery", "selectHistoricTaskInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectTaskByNativeQuery", "selectTaskByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectProcessDefinitionByNativeQuery", "selectProcessDefinitionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectDeploymentByNativeQuery", "selectDeploymentByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectGroupByNativeQuery", "selectGroupByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectUserByNativeQuery", "selectUserByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectModelByNativeQuery", "selectModelByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricDetailByNativeQuery", "selectHistoricDetailByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricVariableInstanceByNativeQuery", "selectHistoricVariableInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectTaskWithVariablesByQueryCriteria", "selectTaskWithVariablesByQueryCriteria_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectProcessInstanceWithVariablesByQueryCriteria", "selectProcessInstanceWithVariablesByQueryCriteria_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricProcessInstancesWithVariablesByQueryCriteria", "selectHistoricProcessInstancesWithVariablesByQueryCriteria_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("db2", "selectHistoricTaskInstancesWithVariablesByQueryCriteria", "selectHistoricTaskInstancesWithVariablesByQueryCriteria_mssql_or_db2");
        databaseSpecificLimitBeforeStatements.put("mssql", "SELECT SUB.* FROM (");
        databaseSpecificLimitAfterStatements.put("mssql", ")RES ) SUB WHERE SUB.rnk >= #{firstRow} AND SUB.rnk < #{lastRow}");
        databaseSpecificLimitBetweenStatements.put("mssql", ", row_number() over (ORDER BY ${orderByColumns}) rnk FROM ( select distinct RES.* ");
        databaseOuterJoinLimitBetweenStatements.put("mssql", ", row_number() over (ORDER BY ${mssqlOrDB2OrderBy}) rnk FROM ( select distinct ");
        databaseSpecificOrderByStatements.put("mssql", "");
        databaseSpecificLimitBeforeNativeQueryStatements.put("mssql", "SELECT SUB.* FROM ( select RES.* , row_number() over (ORDER BY ${orderByColumns}) rnk FROM (");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_integerBoolean");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectExecutionByNativeQuery", "selectExecutionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricActivityInstanceByNativeQuery", "selectHistoricActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricProcessInstanceByNativeQuery", "selectHistoricProcessInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricTaskInstanceByNativeQuery", "selectHistoricTaskInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectTaskByNativeQuery", "selectTaskByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectProcessDefinitionByNativeQuery", "selectProcessDefinitionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectDeploymentByNativeQuery", "selectDeploymentByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectGroupByNativeQuery", "selectGroupByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectUserByNativeQuery", "selectUserByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectModelByNativeQuery", "selectModelByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricDetailByNativeQuery", "selectHistoricDetailByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricVariableInstanceByNativeQuery", "selectHistoricVariableInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectTaskWithVariablesByQueryCriteria", "selectTaskWithVariablesByQueryCriteria_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectProcessInstanceWithVariablesByQueryCriteria", "selectProcessInstanceWithVariablesByQueryCriteria_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricProcessInstancesWithVariablesByQueryCriteria", "selectHistoricProcessInstancesWithVariablesByQueryCriteria_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement("mssql", "selectHistoricTaskInstancesWithVariablesByQueryCriteria", "selectHistoricTaskInstancesWithVariablesByQueryCriteria_mssql_or_db2");
        databaseSpecificLimitBeforeStatements.put("dm", "select * from ( select a.*, ROWNUM rnum from (");
        databaseSpecificLimitAfterStatements.put("dm", "  ) a where ROWNUM < #{lastRow}) where rnum  >= #{firstRow}");
        databaseSpecificLimitBetweenStatements.put("dm", "");
        databaseOuterJoinLimitBetweenStatements.put("dm", "");
        databaseSpecificOrderByStatements.put("dm", defaultOrderBy);
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_integerBoolean");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "selectUnlockedTimersByDuedate", "selectUnlockedTimersByDuedate_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "insertEventLogEntry", "insertEventLogEntry_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertVariableInstance", "bulkInsertVariableInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertUser", "bulkInsertUser_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertTask", "bulkInsertTask_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertResource", "bulkInsertResource_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertProperty", "bulkInsertProperty_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertProcessDefinition", "bulkInsertProcessDefinition_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertModel", "bulkInsertModel_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertMembership", "bulkInsertMembership_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertTimer", "bulkInsertTimer_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertMessage", "bulkInsertMessage_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertIdentityInfo", "bulkInsertIdentityInfo_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertIdentityLink", "bulkInsertIdentityLink_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertMembership", "bulkInsertMembership_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertTimer", "bulkInsertTimer_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertMessage", "bulkInsertMessage_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertHistoricVariableInstance", "bulkInsertHistoricVariableInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertHistoricTaskInstance", "bulkInsertHistoricTaskInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertHistoricProcessInstance", "bulkInsertHistoricProcessInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertHistoricIdentityLink", "bulkInsertHistoricIdentityLink_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertHistoricDetailVariableInstanceUpdate", "bulkInsertHistoricDetailVariableInstanceUpdate_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertHistoricFormProperty", "bulkInsertHistoricFormProperty_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertHistoricActivityInstance", "bulkInsertHistoricActivityInstance_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertGroup", "bulkInsertGroup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertExecution", "bulkInsertExecution_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertMessageEventSubscription", "bulkInsertMessageEventSubscription_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertSignalEventSubscription", "bulkInsertSignalEventSubscription_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertCompensateEventSubscription", "bulkInsertCompensateEventSubscription_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertEventLogEntry", "bulkInsertEventLogEntry_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertDeployment", "bulkInsertDeployment_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertComment", "bulkInsertComment_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertByteArray", "bulkInsertByteArray_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertEventLogEntry", "bulkInsertEventLogEntry_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertDeployment", "bulkInsertDeployment_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertComment", "bulkInsertComment_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertByteArray", "bulkInsertByteArray_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement("dm", "bulkInsertAttachment", "bulkInsertAttachment_oracle");
        databaseSpecificLimitBeforeStatements.put("oscar", "select * from ( select a.*, ROWNUM rnum from (");
        databaseSpecificLimitAfterStatements.put("oscar", "  ) a ) where rnum  between #{firstRow} and #{lastRow}-1 ");
        databaseSpecificLimitBetweenStatements.put("oscar", "");
        databaseOuterJoinLimitBetweenStatements.put("oscar", "");
        databaseSpecificOrderByStatements.put("oscar", defaultOrderBy);
        DbSqlSessionFactory.addDatabaseSpecificStatement("oscar", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_integerBoolean");
        DbSqlSessionFactory.addDatabaseSpecificStatement("oscar", "selectUnlockedTimersByDuedate", "selectUnlockedTimersByDuedate_oracle");
        databaseSpecificLimitBeforeStatements.put("kingbase", "");
        databaseSpecificLimitAfterStatements.put("kingbase", "LIMIT #{maxResults} OFFSET #{firstResult}");
        databaseSpecificLimitBetweenStatements.put("kingbase", "");
        databaseOuterJoinLimitBetweenStatements.put("kingbase", "");
        databaseSpecificOrderByStatements.put("kingbase", defaultOrderBy);
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertByteArray", "insertByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertByteArray", "bulkInsertByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateByteArray", "updateByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectByteArray", "selectByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectResourceByDeploymentIdAndResourceName", "selectResourceByDeploymentIdAndResourceName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectResourcesByDeploymentId", "selectResourcesByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertIdentityInfo", "insertIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertIdentityInfo", "bulkInsertIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateIdentityInfo", "updateIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectIdentityInfoById", "selectIdentityInfoById_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectIdentityInfoByUserIdAndKey", "selectIdentityInfoByUserIdAndKey_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectIdentityInfoByUserId", "selectIdentityInfoByUserId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectIdentityInfoDetails", "selectIdentityInfoDetails_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertComment", "insertComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertComment", "bulkInsertComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectComment", "selectComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectCommentsByTaskId", "selectCommentsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectCommentsByProcessInstanceId", "selectCommentsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectCommentsByProcessInstanceIdAndType", "selectCommentsByProcessInstanceIdAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectCommentsByType", "selectCommentsByType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectCommentsByTaskIdAndType", "selectCommentsByTaskIdAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventsByTaskId", "selectEventsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertEventLogEntry", "insertEventLogEntry_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertEventLogEntry", "bulkInsertEventLogEntry_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectAllEventLogEntries", "selectAllEventLogEntries_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventLogEntries", "selectEventLogEntries_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventLogEntriesByProcessInstanceId", "selectEventLogEntriesByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectDeploymentById", "selectDeploymentById_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectProcessDefinitionByDeploymentAndKeyAndTenantId", "selectProcessDefinitionByDeploymentAndKeyAndTenantId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertModel", "insertModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertModel", "bulkInsertModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateModel", "updateModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteModel", "deleteModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectModelsByQueryCriteriaSql", "selectModelsByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectModel", "selectModel_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertProcessDefinition", "insertProcessDefinition_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertDeployment", "insertDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertResource", "bulkInsertResource_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectProcessDefinitionsByQueryCriteria", "selectProcessDefinitionsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectProcessDefinitionsByQueryCriteriaSql", "bulkInsertResource_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectIdentityLinksByProcessInstance", "selectIdentityLinksByProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectJobsByExecutionId", "selectJobsByExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectTasksByExecutionId", "selectTasksByExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectVariablesByTaskId", "selectVariablesByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricTaskInstanceCountByQueryCriteria", "selectHistoricTaskInstanceCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricProcessInstancesByQueryCriteria", "selectHistoricProcessInstancesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricProcessInstancesByQueryCriteriaSql", "selectHistoricProcessInstancesByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "commonSelectHistoricProcessInstancesByQueryCriteriaSql", "commonSelectHistoricProcessInstancesByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertHistoricVariableInstance", "bulkInsertHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertHistoricTaskInstance", "insertHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertHistoricProcessInstance", "insertHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertHistoricProcessInstance", "bulkInsertHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertHistoricActivityInstance", "bulkInsertHistoricActivityInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertHistoricIdentityLink", "bulkInsertHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertExecution", "insertExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertTask", "insertTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertIdentityLink", "bulkInsertIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertVariableInstance", "bulkInsertVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertAttachment", "insertAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertAttachment", "bulkInsertAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateAttachment", "updateAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteAttachment", "deleteAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectAttachment", "selectAttachment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectAttachmentsByTaskId", "selectAttachmentsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectAttachmentsByProcessInstanceId", "selectAttachmentsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectBytesOfByteArray", "selectBytesOfByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteByteArraysForDeployment", "deleteByteArraysForDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteByteArray", "deleteByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteByteArrayNoRevisionCheck", "deleteByteArrayNoRevisionCheck_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteComment", "deleteComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteCommentsByTaskId", "deleteCommentsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteCommentsByProcessInstanceId", "deleteCommentsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventsByProcessInstanceId", "selectEventsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertDeployment", "bulkInsertDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateDeployment", "updateDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteDeployment", "deleteDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectDeploymentsByQueryCriteria", "selectDeploymentsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectDeploymentByQueryCriteria", "selectDeploymentByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectDeploymentsByQueryCriteriaSql", "selectDeploymentsByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteEventLogEntry", "deleteEventLogEntry_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteSignalEventSubscription", "deleteSignalEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteCompensateEventSubscription", "deleteCompensateEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteMessageEventSubscription", "deleteMessageEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteEventSubscriptionsForProcessDefinition", "deleteEventSubscriptionsForProcessDefinition_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventSubscription", "selectEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventSubscriptionByQueryCriteria", "selectEventSubscriptionByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventSubscriptionCountByQueryCriteria", "selectEventSubscriptionCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventSubscriptionByQueryCriteriaSql", "selectEventSubscriptionByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectSignalEventSubscriptionsByProcessInstanceAndEventName", "selectSignalEventSubscriptionsByProcessInstanceAndEventName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectSignalEventSubscriptionsByExecution", "selectSignalEventSubscriptionsByExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectSignalEventSubscriptionsByNameAndExecution", "selectSignalEventSubscriptionsByNameAndExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventSubscriptionsByExecution", "selectEventSubscriptionsByExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventSubscriptionsByExecutionAndType", "selectEventSubscriptionsByExecutionAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventSubscriptionsByExecutionTypeAndActivity", "selectEventSubscriptionsByExecutionTypeAndActivity_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventSubscriptionsByTypeAndProcessDefinitionId", "selectEventSubscriptionsByTypeAndProcessDefinitionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectEventSubscriptionsByNameAndExecution", "selectEventSubscriptionsByNameAndExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertMessageEventSubscription", "insertMessageEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertMessageEventSubscription", "bulkInsertMessageEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateMessageEventSubscription", "updateMessageEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertSignalEventSubscription", "insertSignalEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertSignalEventSubscription", "bulkInsertSignalEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateSignalEventSubscription", "updateSignalEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertCompensateEventSubscription", "insertCompensateEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertCompensateEventSubscription", "bulkInsertCompensateEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateCompensateEventSubscription", "updateCompensateEventSubscription_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectTaskByQueryCriteria", "selectTaskByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectTask", "selectTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectVariableInstanceByTaskAndName", "selectVariableInstanceByTaskAndName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectVariableInstancesByTaskAndNames", "selectVariableInstancesByTaskAndNames_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertHistoricVariableInstance", "insertHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertVariableInstance", "insertVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertGroup", "insertGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertGroup", "bulkInsertGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateGroup", "updateGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteGroup", "deleteGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectGroup", "selectGroup_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectGroupsByUserId", "selectGroupsByUserId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectGroupsByUserIdAndGroupType", "selectGroupsByUserIdAndGroupType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectGroupByQueryCriteria", "selectGroupByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateTask", "updateTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertHistoricActivityInstance", "insertHistoricActivityInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateHistoricActivityInstance", "updateHistoricActivityInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteHistoricActivityInstancesByProcessInstanceId", "deleteHistoricActivityInstancesByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricActivityInstance", "selectHistoricActivityInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricActivityInstancesByQueryCriteria", "selectHistoricActivityInstancesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricActivityInstanceCountByQueryCriteria", "selectHistoricActivityInstanceCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectIdentityLinksByTask", "selectIdentityLinksByTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertHistoricFormProperty", "insertHistoricFormProperty_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertHistoricFormProperty", "bulkInsertHistoricFormProperty_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertHistoricDetailVariableInstanceUpdate", "insertHistoricDetailVariableInstanceUpdate_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertHistoricDetailVariableInstanceUpdate", "bulkInsertHistoricDetailVariableInstanceUpdate_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteHistoricDetailAssignment", "deleteHistoricDetailAssignment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteHistoricDetailTransitionInstance", "deleteHistoricDetailTransitionInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteHistoricDetailVariableInstanceUpdate", "deleteHistoricDetailVariableInstanceUpdate_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteHistoricFormProperty", "deleteHistoricFormProperty_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricDetailsByQueryCriteria", "selectHistoricDetailsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricDetailCountByQueryCriteria", "selectHistoricDetailCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertHistoricIdentityLink", "insertHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteHistoricIdentityLink", "deleteHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteHistoricIdentityLink", "bulkDeleteHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricIdentityLink", "selectHistoricIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricIdentityLinksByTask", "selectHistoricIdentityLinksByTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricIdentityLinksByProcessInstance", "selectHistoricIdentityLinksByProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricIdentityLinkByTaskUserGroupAndType", "selectHistoricIdentityLinkByTaskUserGroupAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateHistoricProcessInstance", "updateHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteHistoricProcessInstance", "deleteHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteHistoricProcessInstance", "bulkDeleteHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricProcessInstance", "selectHistoricProcessInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertHistoricTaskInstance", "bulkInsertHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateHistoricTaskInstance", "updateHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteHistoricTaskInstance", "deleteHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteHistoricTaskInstance", "bulkDeleteHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricTaskInstance", "selectHistoricTaskInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricTasksByParentTaskId", "selectHistoricTasksByParentTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricTaskInstanceIdsByProcessInstanceId", "selectHistoricTaskInstanceIdsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteIdentityInfo", "deleteIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertIdentityLink", "insertIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteIdentityLink", "deleteIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteIdentityLink", "bulkDeleteIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectIdentityLink", "selectIdentityLink_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectIdentityLinkByTaskUserGroupAndType", "selectIdentityLinkByTaskUserGroupAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectIdentityLinkByProcessInstanceUserGroupAndType", "selectIdentityLinkByProcessInstanceUserGroupAndType_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteJob", "deleteJob_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteJob", "bulkDeleteJob_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteTimer", "deleteTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteTimer", "bulkDeleteTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteMessage", "deleteMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteMessage", "bulkDeleteMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateJobTenantIdForDeployment", "updateJobTenantIdForDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectJob", "selectJob_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectExclusiveJobsToExecute", "selectExclusiveJobsToExecute_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectJobByQueryCriteria", "selectJobByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectJobCountByQueryCriteria", "selectJobCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertTimer", "insertTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertTimer", "bulkInsertTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateTimer", "updateTimer_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectTimersByExecutionId", "selectTimersByExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertMessage", "bulkInsertMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertMessage", "insertMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateMessage", "updateMessage_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "unacquireJob", "unacquireJob_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectModelsByQueryCriteria", "selectModelsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectModelCountByQueryCriteria", "selectModelCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertProcessDefinition", "bulkInsertProcessDefinition_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateProcessDefinition", "updateProcessDefinition_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateProcessDefinitionTenantIdForDeploymentId", "updateProcessDefinitionTenantIdForDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteProcessDefinitionsByDeploymentId", "deleteProcessDefinitionsByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectProcessDefinitionCountByQueryCriteria", "selectProcessDefinitionCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectProcessDefinitionsByQueryCriteriaSql", "selectProcessDefinitionsByQueryCriteriaSql_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectProcessDefinitionByDeploymentAndKey", "selectProcessDefinitionByDeploymentAndKey_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertProcessDefinitionInfo", "insertProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertProcessDefinitionInfo", "bulkInsertProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateProcessDefinitionInfo", "updateProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteProcessDefinitionInfo", "deleteProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectProcessDefinitionInfo", "selectProcessDefinitionInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteProperty", "deleteProperty_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "insertResource", "insertResource_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteResourcesByDeploymentId", "deleteResourcesByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectResourceNamesByDeploymentId", "selectResourceNamesByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectResourceByDeploymentIdAndResourceName", "selectResourceByDeploymentIdAndResourceName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateVariableInstance", "updateVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteVariableInstance", "deleteVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteVariableInstance", "bulkDeleteVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectVariableInstance", "selectVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectVariablesByExecutionId", "selectVariablesByExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectVariablesByExecutionIds", "selectVariablesByExecutionIds_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectVariableInstanceByExecutionAndName", "selectVariableInstanceByExecutionAndName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectVariableInstancesByExecutionAndNames", "selectVariableInstancesByExecutionAndNames_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectVariablesByTaskIds", "selectVariablesByTaskIds_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertTask", "bulkInsertTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateTaskTenantIdForDeployment", "updateTaskTenantIdForDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteTask", "deleteTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteTask", "bulkDeleteTask_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectTasksByParentTaskId", "selectTasksByParentTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectTasksByProcessInstanceId", "selectTasksByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectTaskCountByQueryCriteria", "selectTaskCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectTaskWithVariablesByQueryCriteria", "selectTaskWithVariablesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkInsertExecution", "bulkInsertExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateExecution", "updateExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateExecutionTenantIdForDeployment", "updateExecutionTenantIdForDeployment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateProcessInstanceLockTime", "updateProcessInstanceLockTime_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "clearProcessInstanceLockTime", "clearProcessInstanceLockTime_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteExecution", "deleteExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectExecution", "selectExecution_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectExecutionsByParentExecutionId", "selectExecutionsByParentExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectSubProcessInstanceBySuperExecutionId", "selectSubProcessInstanceBySuperExecutionId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectExecutionsByProcessInstanceId", "selectExecutionsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectExecutionsByQueryCriteria", "selectExecutionsByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricTaskInstancesByQueryCriteria", "selectHistoricTaskInstancesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricTaskInstancesWithVariablesByQueryCriteria", "selectHistoricTaskInstancesWithVariablesByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "bulkDeleteHistoricVariableInstance", "bulkDeleteHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "deleteHistoricVariableInstance", "deleteHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "updateHistoricVariableInstance", "updateHistoricVariableInstance_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricVariableInstanceByQueryCriteria", "selectHistoricVariableInstanceByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricVariableInstanceCountByQueryCriteria", "selectHistoricVariableInstanceCountByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectHistoricVariableInstanceByVariableInstanceId", "selectHistoricVariableInstanceByVariableInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectProcessInstanceByQueryCriteria", "selectProcessInstanceByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement("kingbase", "selectProcessInstanceCountByQueryCriteria", "selectProcessInstanceCountByQueryCriteria_postgres");
    }
}

