/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;

public class AddCommentCmd
implements Command<Comment> {
    protected String taskId;
    protected String processInstanceId;
    protected String type;
    protected String message;

    public AddCommentCmd(String taskId, String processInstanceId, String message) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.message = message;
    }

    public AddCommentCmd(String taskId, String processInstanceId, String type, String message) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.type = type;
        this.message = message;
    }

    @Override
    public Comment execute(CommandContext commandContext) {
        if (this.taskId != null) {
            TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
            if (task == null) {
                throw new ActivitiObjectNotFoundException("Cannot find task with id " + this.taskId, Task.class);
            }
            if (task.isSuspended()) {
                throw new ActivitiException(this.getSuspendedTaskException());
            }
        }
        if (this.processInstanceId != null) {
            ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this.processInstanceId);
            if (execution == null) {
                throw new ActivitiObjectNotFoundException("execution " + this.processInstanceId + " doesn't exist", Execution.class);
            }
            if (execution.isSuspended()) {
                throw new ActivitiException(this.getSuspendedExceptionMessage());
            }
        }
        String userId = Authentication.getAuthenticatedUserId();
        CommentEntity comment = new CommentEntity();
        comment.setUserId(userId);
        comment.setType(this.type == null ? "comment" : this.type);
        comment.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        comment.setTaskId(this.taskId);
        comment.setProcessInstanceId(this.processInstanceId);
        comment.setAction("AddComment");
        String eventMessage = this.message.replaceAll("\\s+", " ");
        if (eventMessage.length() > 1303) {
            eventMessage = eventMessage.substring(0, 1300) + "...";
        }
        comment.setMessage(eventMessage);
        comment.setFullMessage(this.message);
        commandContext.getCommentEntityManager().insert(comment);
        return comment;
    }

    protected String getSuspendedTaskException() {
        return "Cannot add a comment to a suspended task";
    }

    protected String getSuspendedExceptionMessage() {
        return "Cannot add a comment to a suspended execution";
    }
}

