/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.impl.persistence.entity.GroupIdentityManager;

public class GroupEntityManager
extends AbstractManager
implements GroupIdentityManager {
    @Override
    public Group createNewGroup(String groupId) {
        return new GroupEntity(groupId);
    }

    @Override
    public void insertGroup(Group group) {
        this.getDbSqlSession().insert((PersistentObject)((Object)group));
        if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, group));
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, group));
        }
    }

    @Override
    public void updateGroup(Group updatedGroup) {
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        dbSqlSession.update((GroupEntity)updatedGroup);
        if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, updatedGroup));
        }
    }

    @Override
    public void deleteGroup(String groupId) {
        GroupEntity group = this.getDbSqlSession().selectById(GroupEntity.class, groupId);
        if (group != null) {
            if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createMembershipEvent(ActivitiEventType.MEMBERSHIPS_DELETED, groupId, null));
            }
            this.getDbSqlSession().delete("deleteMembershipsByGroupId", groupId);
            this.getDbSqlSession().delete(group);
            if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, group));
            }
        }
    }

    @Override
    public GroupQuery createNewGroupQuery() {
        return new GroupQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutor());
    }

    @Override
    public List<Group> findGroupByQueryCriteria(GroupQueryImpl query, Page page) {
        return this.getDbSqlSession().selectList("selectGroupByQueryCriteria", query, page);
    }

    @Override
    public long findGroupCountByQueryCriteria(GroupQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectGroupCountByQueryCriteria", query);
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        return this.getDbSqlSession().selectList("selectGroupsByUserId", userId);
    }

    @Override
    public List<Group> findGroupsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectGroupByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findGroupCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectGroupCountByNativeQuery", parameterMap);
    }

    @Override
    public boolean isNewGroup(Group group) {
        return ((GroupEntity)group).getRevision() == 0;
    }
}

