/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.BulkDeleteable;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricScopeInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInitializingList;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;

public class HistoricProcessInstanceEntity
extends HistoricScopeInstanceEntity
implements HistoricProcessInstance,
BulkDeleteable {
    private static final long serialVersionUID = 1L;
    protected String endActivityId;
    protected String businessKey;
    protected String startUserId;
    protected String startActivityId;
    protected String superProcessInstanceId;
    protected String tenantId = "";
    protected String name;
    protected String localizedName;
    protected String description;
    protected String localizedDescription;
    protected List<HistoricVariableInstanceEntity> queryVariables;
    protected String dataDetail;
    protected String processTitle;
    protected String completeFrom;
    protected String firstUserTaskActivityId;
    protected String completeType;
    protected String jumpInfo;
    protected String mainActId;
    protected Integer processCycleCount;
    protected Integer securityLevel;
    protected String rectificationBusinessKey;
    protected Long originalProcInstId;
    protected String rectificationFormKey;
    protected String departmentId;
    protected String postId;
    protected String processState;

    public HistoricProcessInstanceEntity() {
    }

    public HistoricProcessInstanceEntity(ExecutionEntity processInstance) {
        this.id = processInstance.getId();
        this.processInstanceId = processInstance.getId();
        this.businessKey = processInstance.getBusinessKey();
        this.processDefinitionId = processInstance.getProcessDefinitionId();
        this.processDefinitionKey = processInstance.getProcessDefinitionKey();
        this.processDefinitionName = processInstance.getProcessDefinitionName();
        this.processDefinitionVersion = processInstance.getProcessDefinitionVersion();
        this.dataDetail = processInstance.getDataDetail();
        this.processTitle = processInstance.getProcessTitle();
        this.deploymentId = processInstance.getDeploymentId();
        this.startTime = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
        this.startUserId = Authentication.getAuthenticatedUserId();
        this.startActivityId = processInstance.getActivityId();
        String string = this.superProcessInstanceId = processInstance.getSuperExecution() != null ? processInstance.getSuperExecution().getProcessInstanceId() : null;
        if (processInstance.getTenantId() != null) {
            this.tenantId = processInstance.getTenantId();
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("endTime", this.endTime);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("name", this.name);
        persistentState.put("durationInMillis", this.durationInMillis);
        persistentState.put("deleteReason", this.deleteReason);
        persistentState.put("endStateName", this.endActivityId);
        persistentState.put("superProcessInstanceId", this.superProcessInstanceId);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("processDefinitionKey", this.processDefinitionKey);
        persistentState.put("processDefinitionName", this.processDefinitionName);
        persistentState.put("processDefinitionVersion", this.processDefinitionVersion);
        persistentState.put("deploymentId", this.deploymentId);
        persistentState.put("dataDetail", this.dataDetail);
        persistentState.put("processTitle", this.processTitle);
        persistentState.put("completeFrom", this.completeFrom);
        persistentState.put("firstUserTaskActivityId", this.firstUserTaskActivityId);
        persistentState.put("completeType", this.completeType);
        persistentState.put("jumpInfo", this.jumpInfo);
        persistentState.put("processCycleCount", this.processCycleCount);
        persistentState.put("securityLevel", this.securityLevel);
        persistentState.put("rectificationFormKey", this.rectificationFormKey);
        persistentState.put("rectificationBusinessKey", this.rectificationBusinessKey);
        persistentState.put("processState", this.processState);
        return persistentState;
    }

    @Override
    public String getEndActivityId() {
        return this.endActivityId;
    }

    public void setEndActivityId(String endActivityId) {
        this.endActivityId = endActivityId;
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    @Override
    public String getStartActivityId() {
        return this.startActivityId;
    }

    public void setStartActivityId(String startUserId) {
        this.startActivityId = startUserId;
    }

    @Override
    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    @Override
    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    @Override
    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    @Override
    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public String getRectificationBusinessKey() {
        return this.rectificationBusinessKey;
    }

    public void setRectificationBusinessKey(String rectificationBusinessKey) {
        this.rectificationBusinessKey = rectificationBusinessKey;
    }

    public Long getOriginalProcInstId() {
        return this.originalProcInstId;
    }

    @Override
    public String getStringOriginalProcInstId() {
        if (this.originalProcInstId != null) {
            return this.originalProcInstId.toString();
        }
        return null;
    }

    public void setOriginalProcInstId(Long originalProcInstId) {
        this.originalProcInstId = originalProcInstId;
    }

    public List<HistoricVariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new HistoricVariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<HistoricVariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    @Override
    public String getDataDetail() {
        return this.dataDetail;
    }

    public void setDataDetail(String dataDetail) {
        this.dataDetail = dataDetail;
    }

    @Override
    public String getProcessTitle() {
        return this.processTitle;
    }

    public void setProcessTitle(String processTitle) {
        this.processTitle = processTitle;
    }

    @Override
    public String getDepartmentId() {
        return this.departmentId;
    }

    @Override
    public String getCompleteFrom() {
        return this.completeFrom;
    }

    public void setCompleteFrom(String completeFrom) {
        this.completeFrom = completeFrom;
    }

    @Override
    public String getFirstUserTaskActivityId() {
        return this.firstUserTaskActivityId;
    }

    public void setFirstUserTaskActivityId(String firstUserTaskActivityId) {
        this.firstUserTaskActivityId = firstUserTaskActivityId;
    }

    @Override
    public String getCompleteType() {
        return this.completeType;
    }

    public void setCompleteType(String completeType) {
        this.completeType = completeType;
    }

    @Override
    public String getJumpInfo() {
        return this.jumpInfo;
    }

    public void setJumpInfo(String jumpInfo) {
        this.jumpInfo = jumpInfo;
    }

    @Override
    public String getMainActId() {
        return this.mainActId;
    }

    public void setMainActId(String mainActId) {
        this.mainActId = mainActId;
    }

    @Override
    public Integer getProcessCycleCount() {
        return this.processCycleCount;
    }

    public void setProcessCycleCount(Integer processCycleCount) {
        this.processCycleCount = processCycleCount;
    }

    @Override
    public Integer getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(Integer securityLevel) {
        this.securityLevel = securityLevel;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    @Override
    public String getRectificationFormKey() {
        return this.rectificationFormKey;
    }

    public void setRectificationFormKey(String rectificationFormKey) {
        this.rectificationFormKey = rectificationFormKey;
    }

    @Override
    public String getPostId() {
        return this.postId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public String getProcessState() {
        return this.processState;
    }

    public void setProcessState(String processState) {
        this.processState = processState;
    }

    public String toString() {
        return "HistoricProcessInstanceEntity[superProcessInstanceId=" + this.superProcessInstanceId + "]";
    }
}

