/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.enums.ActivitiExceptionEnum;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public abstract class NeedsActiveTaskCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public NeedsActiveTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public T execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiIllegalArgumentException(ActivitiExceptionEnum.ACTIVITI_TASK_ID_IS_NULL.getMessage());
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiException(ActivitiExceptionEnum.ACTIVITI_TASK_NOT_EXIST.getMessage());
        }
        if (task.isSuspended()) {
            throw new ActivitiException(ActivitiExceptionEnum.ACTIVITI_TASK_SUSPENDED.getMessage());
        }
        return this.execute(commandContext, task);
    }

    protected abstract T execute(CommandContext var1, TaskEntity var2);

    protected String getSuspendedTaskException() {
        return "Cannot execute operation: task is suspended";
    }
}

