/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.task.TaskDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskActivityBehavior.class);
    protected String userTaskId;
    protected TaskDefinition taskDefinition;

    public UserTaskActivityBehavior(String userTaskId, TaskDefinition taskDefinition) {
        this.userTaskId = userTaskId;
        this.taskDefinition = taskDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        boolean skipUserTask;
        Object formKey;
        Object category;
        Object priority;
        Object dueDate;
        TaskEntity task = TaskEntity.createAndInsert(execution);
        task.setExecution(execution);
        Expression activeNameExpression = null;
        Expression activeDescriptionExpression = null;
        Expression activeDueDateExpression = null;
        Expression activePriorityExpression = null;
        Expression activeCategoryExpression = null;
        Expression activeFormKeyExpression = null;
        Expression activeSkipExpression = null;
        Expression activeAssigneeExpression = null;
        Expression activeOwnerExpression = null;
        Set<Expression> activeCandidateUserExpressions = null;
        Set<Expression> activeCandidateGroupExpressions = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties(this.userTaskId, execution.getProcessDefinitionId());
            activeNameExpression = this.getActiveValue(this.taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
            this.taskDefinition.setNameExpression(activeNameExpression);
            activeDescriptionExpression = this.getActiveValue(this.taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
            this.taskDefinition.setDescriptionExpression(activeDescriptionExpression);
            activeDueDateExpression = this.getActiveValue(this.taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
            this.taskDefinition.setDueDateExpression(activeDueDateExpression);
            activePriorityExpression = this.getActiveValue(this.taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
            this.taskDefinition.setPriorityExpression(activePriorityExpression);
            activeCategoryExpression = this.getActiveValue(this.taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
            this.taskDefinition.setCategoryExpression(activeCategoryExpression);
            activeFormKeyExpression = this.getActiveValue(this.taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
            this.taskDefinition.setFormKeyExpression(activeFormKeyExpression);
            activeSkipExpression = this.getActiveValue(this.taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            this.taskDefinition.setSkipExpression(activeSkipExpression);
            activeAssigneeExpression = this.getActiveValue(this.taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
            this.taskDefinition.setAssigneeExpression(activeAssigneeExpression);
            activeOwnerExpression = this.getActiveValue(this.taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
            this.taskDefinition.setOwnerExpression(activeOwnerExpression);
            activeCandidateUserExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
            this.taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
            activeCandidateGroupExpressions = this.getActiveValueSet(this.taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
            this.taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
        } else {
            activeNameExpression = this.taskDefinition.getNameExpression();
            activeDescriptionExpression = this.taskDefinition.getDescriptionExpression();
            activeDueDateExpression = this.taskDefinition.getDueDateExpression();
            activePriorityExpression = this.taskDefinition.getPriorityExpression();
            activeCategoryExpression = this.taskDefinition.getCategoryExpression();
            activeFormKeyExpression = this.taskDefinition.getFormKeyExpression();
            activeSkipExpression = this.taskDefinition.getSkipExpression();
            activeAssigneeExpression = this.taskDefinition.getAssigneeExpression();
            activeOwnerExpression = this.taskDefinition.getOwnerExpression();
            activeCandidateUserExpressions = this.taskDefinition.getCandidateUserIdExpressions();
            activeCandidateGroupExpressions = this.taskDefinition.getCandidateGroupIdExpressions();
        }
        task.setTaskDefinition(this.taskDefinition);
        if (activeNameExpression != null) {
            String name = null;
            try {
                name = (String)activeNameExpression.getValue(execution);
            }
            catch (ActivitiException e) {
                name = activeNameExpression.getExpressionText();
                LOGGER.warn("property not found in task name expression " + e.getMessage());
            }
            task.setName(name);
        }
        if (activeDescriptionExpression != null) {
            String description = null;
            try {
                description = (String)activeDescriptionExpression.getValue(execution);
            }
            catch (ActivitiException e) {
                description = activeDescriptionExpression.getExpressionText();
                LOGGER.warn("property not found in task description expression " + e.getMessage());
            }
            task.setDescription(description);
        }
        if (activeDueDateExpression != null && (dueDate = activeDueDateExpression.getValue(execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.taskDefinition.getBusinessCalendarNameExpression().getValue(execution).toString());
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
            }
        }
        if (activePriorityExpression != null && (priority = activePriorityExpression.getValue(execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority));
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
            }
        }
        if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue(execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
            }
        }
        if (activeFormKeyExpression != null && (formKey = activeFormKeyExpression.getValue(execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
            }
        }
        boolean bl = skipUserTask = SkipExpressionUtil.isSkipExpressionEnabled(execution, activeSkipExpression) && SkipExpressionUtil.shouldSkipFlowElement(execution, activeSkipExpression);
        if (!skipUserTask) {
            this.handleAssignments(activeAssigneeExpression, activeOwnerExpression, activeCandidateUserExpressions, activeCandidateGroupExpressions, task, execution);
        }
        task.fireEvent("create");
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_CREATED, task));
        }
        if (skipUserTask) {
            task.complete(null, false);
        }
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (!((ExecutionEntity)execution).getTasks().isEmpty()) {
            throw new ActivitiException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    protected void handleAssignments(Expression assigneeExpression, Expression ownerExpression, Set<Expression> candidateUserExpressions, Set<Expression> candidateGroupExpressions, TaskEntity task, ActivityExecution execution) {
        Object value;
        Map<String, Set<Expression>> identityLinks;
        Object value2;
        if (assigneeExpression != null) {
            Object assigneeExpressionValue = assigneeExpression.getValue(execution);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            task.setAssignee(assigneeValue, true, false);
        }
        if (ownerExpression != null) {
            Iterator<Expression> ownerExpressionValue = ownerExpression.getValue(execution);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            task.setOwner(ownerValue);
        }
        if (candidateGroupExpressions != null && !candidateGroupExpressions.isEmpty()) {
            for (Expression groupIdExpr : candidateGroupExpressions) {
                value2 = groupIdExpr.getValue(execution);
                if (value2 instanceof String) {
                    List<String> candidates = this.extractCandidates((String)value2);
                    task.addCandidateGroups(candidates);
                    continue;
                }
                if (value2 instanceof Collection) {
                    task.addCandidateGroups((Collection)value2);
                    continue;
                }
                throw new ActivitiIllegalArgumentException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (candidateUserExpressions != null && !candidateUserExpressions.isEmpty()) {
            for (Expression userIdExpr : candidateUserExpressions) {
                value2 = userIdExpr.getValue(execution);
                if (value2 instanceof String) {
                    List<String> candiates = this.extractCandidates((String)value2);
                    for (String userId : candiates) {
                        task.addIdentityLink(userId, null, "candidate", null, null, null);
                    }
                    continue;
                }
                if (value2 instanceof Collection) {
                    for (Expression userId : (Collection)value2) {
                        task.addIdentityLink(userId.toString(), null, "candidate", null, null, null);
                    }
                    continue;
                }
                throw new ActivitiException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (!this.taskDefinition.getCustomUserIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomUserIdentityLinkExpressions();
            for (String identityLinkType : identityLinks.keySet()) {
                for (Expression idExpression : identityLinks.get(identityLinkType)) {
                    value = idExpression.getValue(execution);
                    if (value instanceof String) {
                        List<String> userIds = this.extractCandidates((String)value);
                        for (String userId : userIds) {
                            task.addUserIdentityLink(userId, identityLinkType);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator userIdSet = ((Collection)value).iterator();
                        while (userIdSet.hasNext()) {
                            task.addUserIdentityLink((String)userIdSet.next(), identityLinkType);
                        }
                        continue;
                    }
                    throw new ActivitiException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
        if (!this.taskDefinition.getCustomGroupIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomGroupIdentityLinkExpressions();
            for (String identityLinkType : identityLinks.keySet()) {
                for (Expression idExpression : identityLinks.get(identityLinkType)) {
                    value = idExpression.getValue(execution);
                    if (value instanceof String) {
                        List<String> groupIds = this.extractCandidates((String)value);
                        for (String groupId : groupIds) {
                            task.addGroupIdentityLink(groupId, identityLinkType);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator groupIdSet = ((Collection)value).iterator();
                        while (groupIdSet.hasNext()) {
                            task.addGroupIdentityLink((String)groupIdSet.next(), identityLinkType);
                        }
                        continue;
                    }
                    throw new ActivitiException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Expression activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.size() == 0) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }
}

