/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import java.util.List;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmException;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public abstract class AbstractEventAtomicOperation
implements AtomicOperation {
    @Override
    public boolean isAsync(InterpretableExecution execution) {
        return false;
    }

    @Override
    public void execute(InterpretableExecution execution) {
        ScopeImpl scope = this.getScope(execution);
        List<ExecutionListener> exectionListeners = scope.getExecutionListeners(this.getEventName());
        int executionListenerIndex = execution.getExecutionListenerIndex();
        if (exectionListeners.size() > executionListenerIndex) {
            execution.setEventName(this.getEventName());
            execution.setEventSource(scope);
            ExecutionListener listener = exectionListeners.get(executionListenerIndex);
            try {
                listener.notify(execution);
            }
            catch (RuntimeException e) {
                ExecutionEntity executionEntity = (ExecutionEntity)execution;
                boolean isAsyn = executionEntity.isAsyn(this.getEventName());
                if (!isAsyn) {
                    throw e;
                }
            }
            catch (Exception e) {
                throw new PvmException("couldn't execute event listener : " + e.getMessage(), e);
            }
            execution.setExecutionListenerIndex(executionListenerIndex + 1);
            execution.performOperation(this);
        } else {
            execution.setExecutionListenerIndex(0);
            execution.setEventName(null);
            execution.setEventSource(null);
            this.eventNotificationsCompleted(execution);
        }
    }

    protected abstract ScopeImpl getScope(InterpretableExecution var1);

    protected abstract String getEventName();

    protected abstract void eventNotificationsCompleted(InterpretableExecution var1);
}

