/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.BulkDeleteable;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;

public class IdentityLinkEntity
implements Serializable,
IdentityLink,
BulkDeleteable,
PersistentObject {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String type;
    protected String userId;
    protected String groupId;
    protected String taskId;
    protected String processInstanceId;
    protected String processDefId;
    protected TaskEntity task;
    protected ExecutionEntity processInstance;
    protected ProcessDefinitionEntity processDef;
    protected String mandator;
    protected String organId;
    protected String taskState;
    protected String assistInitiator;
    protected String mandatorOrganId;

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("id", this.id);
        persistentState.put("type", this.type);
        if (this.userId != null) {
            persistentState.put("userId", this.userId);
        }
        if (this.groupId != null) {
            persistentState.put("groupId", this.groupId);
        }
        if (this.taskId != null) {
            persistentState.put("taskId", this.taskId);
        }
        if (this.processInstanceId != null) {
            persistentState.put("processInstanceId", this.processInstanceId);
        }
        if (this.processDefId != null) {
            persistentState.put("processDefId", this.processDefId);
        }
        if (this.mandator != null) {
            persistentState.put("mandator", this.mandator);
        }
        if (this.organId != null) {
            persistentState.put("organId", this.organId);
        }
        if (this.taskState != null) {
            persistentState.put("taskState", this.taskState);
        }
        if (this.assistInitiator != null) {
            persistentState.put("assistInitiator", this.assistInitiator);
        }
        if (this.mandator != null) {
            persistentState.put("mandatorOrganId", this.mandatorOrganId);
        }
        return persistentState;
    }

    public void insert() {
        Context.getCommandContext().getDbSqlSession().insert(this);
        Context.getCommandContext().getHistoryManager().recordIdentityLinkCreated(this);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, this));
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, this));
        }
    }

    public boolean isUser() {
        return this.userId != null;
    }

    public boolean isGroup() {
        return this.groupId != null;
    }

    public boolean isEntrust() {
        return this.taskState != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (this.groupId != null && userId != null) {
            throw new ActivitiException("Cannot assign a userId to a task assignment that already has a groupId");
        }
        this.userId = userId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        if (this.userId != null && groupId != null) {
            throw new ActivitiException("Cannot assign a groupId to a task assignment that already has a userId");
        }
        this.groupId = groupId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    @Override
    public String getMandator() {
        return this.mandator;
    }

    public void setMandator(String mandator) {
        this.mandator = mandator;
    }

    @Override
    public String getMandatorOrganId() {
        return this.mandatorOrganId;
    }

    public void setMandatorOrganId(String mandatorOrganId) {
        this.mandatorOrganId = mandatorOrganId;
    }

    @Override
    public String getOrganId() {
        return this.organId;
    }

    public void setOrganId(String organId) {
        this.organId = organId;
    }

    @Override
    public String getTaskState() {
        return this.taskState;
    }

    @Override
    public String getOriginalUserId() {
        if (TaskStateType.isEntrust(this)) {
            return this.mandator;
        }
        return this.userId;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    public TaskEntity getTask() {
        if (this.task == null && this.taskId != null) {
            this.task = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        }
        return this.task;
    }

    public void setTask(TaskEntity task) {
        this.task = task;
        this.taskId = task.getId();
    }

    public ExecutionEntity getProcessInstance() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.processInstanceId);
        }
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = processInstance;
        this.processInstanceId = processInstance.getId();
    }

    public ProcessDefinitionEntity getProcessDef() {
        if (this.processDef == null && this.processDefId != null) {
            this.processDef = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(this.processDefId);
        }
        return this.processDef;
    }

    public void setProcessDef(ProcessDefinitionEntity processDef) {
        this.processDef = processDef;
        this.processDefId = processDef.getId();
    }

    public String getAssistInitiator() {
        return this.assistInitiator;
    }

    public void setAssistInitiator(String assistInitiator) {
        this.assistInitiator = assistInitiator;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IdentityLinkEntity[id=").append(this.id);
        sb.append(", type=").append(this.type);
        if (this.userId != null) {
            sb.append(", userId=").append(this.userId);
        }
        if (this.groupId != null) {
            sb.append(", groupId=").append(this.groupId);
        }
        if (this.taskId != null) {
            sb.append(", taskId=").append(this.taskId);
        }
        if (this.processInstanceId != null) {
            sb.append(", processInstanceId=").append(this.processInstanceId);
        }
        if (this.processDefId != null) {
            sb.append(", processDefId=").append(this.processDefId);
        }
        if (this.mandator != null) {
            sb.append(", mandator=").append(this.mandator);
        }
        if (this.organId != null) {
            sb.append(", organId=").append(this.organId);
        }
        if (this.taskState != null) {
            sb.append(", taskState=").append(this.taskState);
        }
        if (this.taskState != null) {
            sb.append(", mandatorOrganId=").append(this.mandatorOrganId);
        }
        sb.append("]");
        return sb.toString();
    }
}

