/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Event;

public class CommentEntity
implements Comment,
Event,
PersistentObject,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_EVENT = "event";
    public static final String TYPE_COMMENT = "comment";
    protected String id;
    protected String type;
    protected String userId;
    protected Date time;
    protected String taskId;
    protected String processInstanceId;
    protected String action;
    protected String message;
    protected String fullMessage;
    protected String deptId;
    public static String MESSAGE_PARTS_MARKER = "_|_";
    public static Pattern MESSAGE_PARTS_MARKER_REGEX = Pattern.compile("_\\|_");

    @Override
    public Object getPersistentState() {
        return CommentEntity.class;
    }

    public byte[] getFullMessageBytes() {
        return this.fullMessage != null ? this.fullMessage.getBytes() : null;
    }

    public void setFullMessageBytes(byte[] fullMessageBytes) {
        this.fullMessage = fullMessageBytes != null ? new String(fullMessageBytes) : null;
    }

    public void setMessage(String[] messageParts) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String part : messageParts) {
            if (part != null) {
                stringBuilder.append(part.replace(MESSAGE_PARTS_MARKER, " | "));
                stringBuilder.append(MESSAGE_PARTS_MARKER);
                continue;
            }
            stringBuilder.append("null");
            stringBuilder.append(MESSAGE_PARTS_MARKER);
        }
        for (int i = 0; i < MESSAGE_PARTS_MARKER.length(); ++i) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        this.message = stringBuilder.toString();
    }

    @Override
    public List<String> getMessageParts() {
        String[] parts;
        if (this.message == null) {
            return null;
        }
        ArrayList<String> messageParts = new ArrayList<String>();
        for (String part : parts = MESSAGE_PARTS_MARKER_REGEX.split(this.message)) {
            if ("null".equals(part)) {
                messageParts.add(null);
                continue;
            }
            messageParts.add(part);
        }
        return messageParts;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getFullMessage() {
        return this.fullMessage;
    }

    public void setFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public static void addComment(String userId, String taskId, String comment, String deptId) {
        CommentEntity commentEntity = new CommentEntity();
        commentEntity.setUserId(userId);
        commentEntity.setDeptId(deptId);
        commentEntity.setType("complete");
        CommandContext commandContext = Context.getCommandContext();
        commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        commentEntity.setTaskId(taskId);
        commentEntity.setProcessInstanceId(null);
        commentEntity.setAction("AddComment");
        String eventMessage = comment.replaceAll("\\s+", " ");
        if (eventMessage.length() > 1503) {
            eventMessage = eventMessage.substring(0, 1500) + "...";
        }
        commentEntity.setMessage(eventMessage);
        commentEntity.setFullMessage(comment);
        commandContext.getCommentEntityManager().insert(commentEntity);
    }
}

