/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.context.Context;

public class UelExpressionCondition
implements Condition {
    private static final long serialVersionUID = 1L;
    private static final Pattern BPM_NEXT_NODE_REGEX = Pattern.compile("bpm_next_node [!=]= '([^'])*'");
    protected String initialConditionExpression;

    public UelExpressionCondition(String conditionExpression) {
        this.initialConditionExpression = conditionExpression;
    }

    @Override
    public boolean evaluate(String sequenceFlowId, DelegateExecution execution) {
        String conditionExpression = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode elementProperties = Context.getBpmnOverrideElementProperties(sequenceFlowId, execution.getProcessDefinitionId());
            conditionExpression = this.getActiveValue(this.initialConditionExpression, "sequenceFlowCondition", elementProperties);
        } else {
            conditionExpression = this.initialConditionExpression;
        }
        Expression expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(conditionExpression);
        Matcher matcher = BPM_NEXT_NODE_REGEX.matcher(expression.getExpressionText());
        String bpmNextNodeConditionValue = null;
        boolean isContains = false;
        if (matcher.find()) {
            String bpmNextNodeCondition = matcher.group();
            isContains = bpmNextNodeCondition.contains("==");
            bpmNextNodeConditionValue = bpmNextNodeCondition.substring(18, bpmNextNodeCondition.length() - 1);
        }
        Object result = null;
        String nextNodes = (String)Context.getCommandContext().getAttribute("bpm_next_node");
        if (nextNodes != null && bpmNextNodeConditionValue != null) {
            boolean contains = Arrays.asList(nextNodes.split(",")).contains(bpmNextNodeConditionValue);
            if (isContains && contains) {
                execution.setVariable("bpm_next_node", bpmNextNodeConditionValue);
            } else {
                execution.setVariable("bpm_next_node", "");
            }
            result = expression.getValue(execution);
            execution.removeVariable("bpm_next_node");
        } else {
            result = expression.getValue(execution);
        }
        if (result == null) {
            throw new ActivitiException("condition expression returns null");
        }
        if (!(result instanceof Boolean)) {
            throw new ActivitiException("condition expression returns non-Boolean: " + result + " (" + result.getClass().getName() + ")");
        }
        return (Boolean)result;
    }

    protected String getActiveValue(String originalValue, String propertyName, ObjectNode elementProperties) {
        JsonNode overrideValueNode;
        String activeValue = originalValue;
        if (elementProperties != null && (overrideValueNode = elementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : overrideValueNode.asText();
        }
        return activeValue;
    }
}

