/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cfg;

import com.baomidou.dynamic.datasource.tx.ConnectionFactory;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import java.util.UUID;
import org.activiti.engine.impl.interceptor.AbstractCommandInterceptor;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefinedTransactionInterceptor
extends AbstractCommandInterceptor {
    private static Logger log = LoggerFactory.getLogger(DefinedTransactionInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig commandConfig, Command<T> command) {
        if (!StringUtils.isEmpty((Object)TransactionContext.getXID())) {
            return this.next.execute(commandConfig, command);
        }
        boolean state = true;
        String xid = UUID.randomUUID().toString();
        TransactionContext.bind((String)xid);
        T result = null;
        try {
            result = this.next.execute(commandConfig, command);
        }
        catch (Exception e) {
            state = false;
            log.error("\u4e8b\u52a1\u62e6\u622a\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
        finally {
            ConnectionFactory.notify((Boolean)state);
            TransactionContext.remove();
        }
        return result;
    }
}

