/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.listener;

import com.jxdinfo.hussar.bpm.core.util.BpmActivitiSpringContextHolder;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.user.PluginUser;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.FormDesignPropertyUtil;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.bpmn.helper.ClassDelegate;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ExecutionListenerInvocation;
import org.activiti.engine.impl.delegate.JavaDelegateInvocation;

public class DelegateExpressionExecutionListener
implements ExecutionListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionExecutionListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void notify(DelegateExecution execution) throws Exception {
        Object delegate = this.expression.getValue(execution);
        ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (delegate instanceof ExecutionListener) {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation((ExecutionListener)delegate, execution));
            return;
        } else if (delegate instanceof JavaDelegate) {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)delegate, execution));
            return;
        } else {
            if (!(delegate instanceof String)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + ExecutionListener.class + " nor " + JavaDelegate.class);
            Object object = null;
            if (FormDesignPropertyUtil.getPluginMode().booleanValue()) {
                PluginUser pluginUser = BpmActivitiSpringContextHolder.getBean(PluginUser.class);
                object = pluginUser.getPluginBean((String)delegate);
            } else {
                object = BpmActivitiSpringContextHolder.getBean((String)delegate);
            }
            if (object == null) {
                throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + ExecutionListener.class + " nor " + JavaDelegate.class);
            }
            ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, object);
            if (object instanceof ExecutionListener) {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation((ExecutionListener)object, execution));
                return;
            } else {
                if (!(object instanceof JavaDelegate)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + ExecutionListener.class + " nor " + JavaDelegate.class);
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)object, execution));
            }
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

