/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.commons.lang3.StringUtils;

public class ServiceTaskExpressionActivityBehavior
extends TaskActivityBehavior {
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    protected String resultVariable;

    public ServiceTaskExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, String resultVariable) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.resultVariable = resultVariable;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        Object value = null;
        try {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(execution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(execution, this.skipExpression)) {
                String overrideExpression;
                ObjectNode taskElementProperties;
                if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = Context.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = taskElementProperties.get("serviceTaskExpression").asText())) && !overrideExpression.equals(this.expression.getExpressionText())) {
                    this.expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideExpression);
                }
                value = this.expression.getValue(execution);
                if (this.resultVariable != null) {
                    execution.setVariable(this.resultVariable, value);
                }
            }
            this.leave(execution);
        }
        catch (Exception exc) {
            BpmnError error = null;
            for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof BpmnError)) continue;
                error = (BpmnError)cause;
                break;
            }
            if (error != null) {
                ErrorPropagation.propagateError(error, execution);
            }
            throw exc;
        }
    }
}

