/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.transaction;

import com.jxdinfo.hussar.support.transaction.core.enums.Propagation;
import com.jxdinfo.hussar.support.transaction.core.support.TransactionInfo;
import com.jxdinfo.hussar.support.transaction.core.support.executor.TransactionalExecutor;
import com.jxdinfo.hussar.support.transaction.core.support.rollback.RollbackRule;
import com.jxdinfo.hussar.support.transaction.plugin.db.support.template.TransactionalTemplate;
import java.util.LinkedHashSet;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.interceptor.AbstractCommandInterceptor;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="spring.datasource.dynamic", name={"seata"}, havingValue="false", matchIfMissing=true)
public class DefinedTransactionInterceptor
extends AbstractCommandInterceptor {
    private static Logger log = LoggerFactory.getLogger(DefinedTransactionInterceptor.class);
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();

    @Override
    public <T> T execute(final CommandConfig commandConfig, final Command<T> command) {
        Object result = null;
        try {
            result = this.transactionalTemplate.execute(new TransactionalExecutor(){

                public Object execute() throws Throwable {
                    return DefinedTransactionInterceptor.this.next.execute(commandConfig, command);
                }

                public TransactionInfo getTransactionInfo() {
                    TransactionInfo txInfo = new TransactionInfo();
                    txInfo.setPropagation(DefinedTransactionInterceptor.this.getPropagation(commandConfig));
                    txInfo.setLockRetryInternal(0);
                    txInfo.setLockRetryTimes(60000);
                    LinkedHashSet<RollbackRule> rollbackRules = new LinkedHashSet<RollbackRule>();
                    rollbackRules.add(new RollbackRule(Exception.class));
                    txInfo.setRollbackRules(rollbackRules);
                    return txInfo;
                }
            });
        }
        catch (Throwable e) {
            log.error("Activiti\u4e8b\u52a1\u62e6\u622a\u6267\u884c\u5f02\u5e38", e);
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    private Propagation getPropagation(CommandConfig config) {
        switch (config.getTransactionPropagation()) {
            case NOT_SUPPORTED: {
                return Propagation.NOT_SUPPORTED;
            }
            case REQUIRED: {
                return Propagation.REQUIRED;
            }
            case REQUIRES_NEW: {
                return Propagation.REQUIRES_NEW;
            }
        }
        throw new ActivitiIllegalArgumentException("Unsupported transaction propagation: " + (Object)((Object)config.getTransactionPropagation()));
    }
}

