/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.listener;

import com.jxdinfo.hussar.support.hotloaded.framework.integration.user.PluginUser;
import com.jxdinfo.hussar.workflow.util.BpmActivitiSpringContextHolder;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.FormDesignPropertyUtil;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.bpmn.helper.ClassDelegate;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.TaskListenerInvocation;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionTaskListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    public List<FieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void notify(DelegateTask delegateTask) {
        Object delegate = this.expression.getValue(delegateTask.getExecution());
        ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (delegate instanceof TaskListener) {
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)delegate, delegateTask));
                return;
            }
            catch (Exception e) {
                throw new ActivitiException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
        }
        if (!(delegate instanceof String)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + TaskListener.class);
        Object object = null;
        if (FormDesignPropertyUtil.getPluginMode().booleanValue()) {
            PluginUser pluginUser = BpmActivitiSpringContextHolder.getBean(PluginUser.class);
            object = pluginUser.getPluginBean((String)delegate);
        } else if (FormDesignPropertyUtil.isStartAlone().booleanValue()) {
            delegateTask.setVariableLocal("beanId", (String)delegate);
            object = BpmActivitiSpringContextHolder.getBean("DefaultCloudTaskListener");
        } else {
            object = BpmActivitiSpringContextHolder.getBean((String)delegate);
        }
        if (!(object instanceof TaskListener)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did not resolve to an implementation of " + TaskListener.class);
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)object, delegateTask));
            return;
        }
        catch (Exception e) {
            throw new ActivitiException("Exception while invoking TaskListener: " + e.getMessage(), e);
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

