/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.impl.replay;

import java.util.Map;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationEventHandler;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayUserTaskCompleteEventHandler
implements SimulationEventHandler {
    private static Logger log = LoggerFactory.getLogger(ReplayUserTaskCompleteEventHandler.class);

    @Override
    public void handle(SimulationEvent event) {
        String taskDefinitionKey = (String)event.getProperty("taskDefinitionKey");
        String processInstanceId = (String)event.getProperty("processInstanceId");
        String simulationRunId = SimulationRunContext.getSimulationRunId();
        ProcessInstance processInstance = (ProcessInstance)SimulationRunContext.getRuntimeService().createProcessInstanceQuery().variableValueEquals("_replay.processInstanceId", (Object)processInstanceId).variableValueEquals("_replay.simulationRunId", (Object)simulationRunId).singleResult();
        Task task = (Task)((TaskQuery)((TaskQuery)SimulationRunContext.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).taskDefinitionKey(taskDefinitionKey)).singleResult();
        Map variables = (Map)event.getProperty("taskVariables");
        if (variables != null) {
            if (event.getProperty("variablesLocalScope") != null && ((Boolean)event.getProperty("variablesLocalScope")).booleanValue()) {
                SimulationRunContext.getTaskService().complete(task.getId(), variables, true);
            } else {
                SimulationRunContext.getTaskService().complete(task.getId(), variables);
            }
            log.debug("completed {}, {}, {}", new Object[]{task, task.getName(), variables});
        } else {
            SimulationRunContext.getTaskService().complete(task.getId());
            log.debug("completed {}, {}", (Object)task, (Object)task.getName());
        }
    }

    @Override
    public void init() {
    }
}

