/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.delegate.event.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.delegate.event.Function;
import org.activiti.engine.event.EventLogEntry;

public class EventLogTransformer {
    protected List<Function<EventLogEntry, SimulationEvent>> transformers;

    public EventLogTransformer(List<Function<EventLogEntry, SimulationEvent>> transformers) {
        this.transformers = transformers;
    }

    public List<SimulationEvent> transform(List<EventLogEntry> eventLog) {
        ArrayList<SimulationEvent> simulationEvents = new ArrayList<SimulationEvent>();
        for (EventLogEntry logEntry : eventLog) {
            simulationEvents.addAll(this.transformEntry(logEntry));
        }
        return simulationEvents;
    }

    protected Collection<SimulationEvent> transformEntry(EventLogEntry event) {
        ArrayList<SimulationEvent> simEvents = new ArrayList<SimulationEvent>();
        for (Function<EventLogEntry, SimulationEvent> t : this.transformers) {
            SimulationEvent simEvent = t.apply(event);
            if (simEvent == null) continue;
            simEvents.add(simEvent);
        }
        return simEvents;
    }
}

