/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.delegate.event.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.activiti.crystalball.simulator.CrystalballException;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.delegate.event.impl.EventLog2SimulationEventFunction;
import org.activiti.engine.event.EventLogEntry;

public class EventLogProcessInstanceCreateTransformer
extends EventLog2SimulationEventFunction {
    public static final String PROCESS_INSTANCE_ID = "processInstanceId";
    private final String processDefinitionIdKey;
    private final String businessKey;
    private final String variablesKey;

    public EventLogProcessInstanceCreateTransformer(String simulationEventType, String processDefinitionIdKey, String businessKey, String variablesKey) {
        super(simulationEventType);
        this.processDefinitionIdKey = processDefinitionIdKey;
        this.businessKey = businessKey;
        this.variablesKey = variablesKey;
    }

    @Override
    public SimulationEvent apply(EventLogEntry event) {
        if ("PROCESSINSTANCE_START".equals(event.getType())) {
            Map data;
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                data = (Map)objectMapper.readValue(event.getData(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            }
            catch (IOException e) {
                throw new CrystalballException("unable to parse JSON string.", e);
            }
            String processDefinitionId = (String)data.get("processDefinitionId");
            Map variableMap = (Map)data.get("variables");
            String businessKeyValue = (String)data.get("businessKey");
            String processInstanceId = (String)data.get(PROCESS_INSTANCE_ID);
            HashMap<String, Object> simEventProperties = new HashMap<String, Object>();
            simEventProperties.put(this.processDefinitionIdKey, processDefinitionId);
            simEventProperties.put(this.businessKey, businessKeyValue);
            simEventProperties.put(this.variablesKey, variableMap);
            simEventProperties.put(PROCESS_INSTANCE_ID, processInstanceId);
            return new SimulationEvent.Builder(this.simulationEventType).priority((int)event.getLogNumber()).properties(simEventProperties).build();
        }
        return null;
    }
}

