/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.Process;
import org.apache.commons.lang3.StringUtils;

public class LaneExport
implements BpmnXMLConstants {
    public static void writeLanes(Process process, XMLStreamWriter xtw) throws Exception {
        if (!process.getLanes().isEmpty()) {
            xtw.writeStartElement("laneSet");
            xtw.writeAttribute("id", "laneSet_" + process.getId());
            for (Lane lane : process.getLanes()) {
                xtw.writeStartElement("lane");
                xtw.writeAttribute("id", lane.getId());
                if (StringUtils.isNotEmpty((CharSequence)lane.getName())) {
                    xtw.writeAttribute("name", lane.getName());
                }
                for (String flowNodeRef : lane.getFlowReferences()) {
                    xtw.writeStartElement("flowNodeRef");
                    xtw.writeCharacters(flowNodeRef);
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }
}

