/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import java.util.List;
import java.util.Map;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.runtime.model.impl.IntegrationContextImpl;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.core.common.model.connector.ActionDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.persistence.entity.integration.IntegrationContextEntity;
import org.activiti.runtime.api.connector.VariablesMatchHelper;

public class IntegrationContextBuilder {
    private final VariablesMatchHelper variablesMatchHelper;

    public IntegrationContextBuilder(VariablesMatchHelper variablesMatchHelper) {
        this.variablesMatchHelper = variablesMatchHelper;
    }

    public IntegrationContext from(IntegrationContextEntity integrationContextEntity, DelegateExecution execution, ActionDefinition actionDefinition) {
        IntegrationContextImpl integrationContext = this.buildFromExecution(execution, actionDefinition);
        integrationContext.setId(integrationContextEntity.getId());
        return integrationContext;
    }

    public IntegrationContext from(DelegateExecution execution, ActionDefinition actionDefinition) {
        IntegrationContextImpl integrationContext = this.buildFromExecution(execution, actionDefinition);
        return integrationContext;
    }

    private IntegrationContextImpl buildFromExecution(DelegateExecution execution, ActionDefinition actionDefinition) {
        IntegrationContextImpl integrationContext = new IntegrationContextImpl();
        integrationContext.setProcessInstanceId(execution.getProcessInstanceId());
        integrationContext.setProcessDefinitionId(execution.getProcessDefinitionId());
        integrationContext.setActivityElementId(execution.getCurrentActivityId());
        String implementation = ((ServiceTask)execution.getCurrentFlowElement()).getImplementation();
        integrationContext.setConnectorType(implementation);
        integrationContext.setInBoundVariables(this.buildInBoundVariables(actionDefinition, execution));
        return integrationContext;
    }

    private Map<String, Object> buildInBoundVariables(ActionDefinition actionDefinition, DelegateExecution execution) {
        List inBoundVariableDefinitions;
        List list = inBoundVariableDefinitions = actionDefinition == null ? null : actionDefinition.getInput();
        if (this.variablesMatchHelper != null) {
            return this.variablesMatchHelper.match(execution.getVariables(), inBoundVariableDefinitions);
        }
        return execution.getVariables();
    }
}

