/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class FilterChainProxy
implements Filter,
InitializingBean,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$util$FilterChainProxy == null ? (class$org$acegisecurity$util$FilterChainProxy = FilterChainProxy.class$("org.acegisecurity.util.FilterChainProxy")) : class$org$acegisecurity$util$FilterChainProxy));
    public static final String TOKEN_NONE = "#NONE#";
    private ApplicationContext applicationContext;
    private FilterInvocationDefinitionSource filterInvocationDefinitionSource;
    static /* synthetic */ Class class$org$acegisecurity$util$FilterChainProxy;
    static /* synthetic */ Class class$javax$servlet$Filter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.filterInvocationDefinitionSource, (String)"filterInvocationDefinitionSource must be specified");
        Assert.notNull((Object)this.filterInvocationDefinitionSource.getConfigAttributeDefinitions(), (String)"FilterChainProxy requires the FilterInvocationDefinitionSource to return a non-null response to getConfigAttributeDefinitions()");
    }

    public void destroy() {
        Filter[] filters = this.obtainAllDefinedFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Destroying Filter defined in ApplicationContext: '" + filters[i].toString() + "'"));
            }
            filters[i].destroy();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        ConfigAttributeDefinition cad = this.filterInvocationDefinitionSource.getAttributes(fi);
        if (cad == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(fi.getRequestUrl() + " has no matching filters"));
            }
            chain.doFilter(request, response);
            return;
        }
        Filter[] filters = this.obtainAllDefinedFilters(cad);
        if (filters.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(fi.getRequestUrl() + " has an empty filter list"));
            }
            chain.doFilter(request, response);
            return;
        }
        VirtualFilterChain virtualFilterChain = new VirtualFilterChain(fi, filters);
        virtualFilterChain.doFilter(fi.getRequest(), fi.getResponse());
    }

    public FilterInvocationDefinitionSource getFilterInvocationDefinitionSource() {
        return this.filterInvocationDefinitionSource;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Filter[] filters = this.obtainAllDefinedFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Initializing Filter defined in ApplicationContext: '" + filters[i].toString() + "'"));
            }
            filters[i].init(filterConfig);
        }
    }

    protected Filter[] obtainAllDefinedFilters() {
        Iterator cads = this.filterInvocationDefinitionSource.getConfigAttributeDefinitions();
        LinkedHashSet<Filter> list = new LinkedHashSet<Filter>();
        while (cads.hasNext()) {
            ConfigAttributeDefinition attribDef = (ConfigAttributeDefinition)cads.next();
            Filter[] filters = this.obtainAllDefinedFilters(attribDef);
            for (int i = 0; i < filters.length; ++i) {
                list.add(filters[i]);
            }
        }
        return list.toArray(new Filter[0]);
    }

    private Filter[] obtainAllDefinedFilters(ConfigAttributeDefinition configAttributeDefinition) {
        Vector<Object> list = new Vector<Object>();
        Iterator attributes = configAttributeDefinition.getConfigAttributes();
        while (attributes.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)attributes.next();
            String filterName = attr.getAttribute();
            if (filterName == null) {
                throw new IllegalArgumentException("Configuration attribute: '" + attr + "' returned null to the getAttribute() method, which is invalid when used with FilterChainProxy");
            }
            if (filterName.equals(TOKEN_NONE)) continue;
            list.add(this.applicationContext.getBean(filterName, class$javax$servlet$Filter == null ? FilterChainProxy.class$("javax.servlet.Filter") : class$javax$servlet$Filter));
        }
        return list.toArray(new Filter[list.size()]);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setFilterInvocationDefinitionSource(FilterInvocationDefinitionSource filterInvocationDefinitionSource) {
        this.filterInvocationDefinitionSource = filterInvocationDefinitionSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class VirtualFilterChain
    implements FilterChain {
        private FilterInvocation fi;
        private Filter[] additionalFilters;
        private int currentPosition = 0;

        public VirtualFilterChain(FilterInvocation filterInvocation, Filter[] additionalFilters) {
            this.fi = filterInvocation;
            this.additionalFilters = additionalFilters;
        }

        private VirtualFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.currentPosition == this.additionalFilters.length) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.fi.getRequestUrl() + " reached end of additional filter chain; proceeding with original chain"));
                }
                this.fi.getChain().doFilter(request, response);
            } else {
                ++this.currentPosition;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.fi.getRequestUrl() + " at position " + this.currentPosition + " of " + this.additionalFilters.length + " in additional filter chain; firing Filter: '" + this.additionalFilters[this.currentPosition - 1] + "'"));
                }
                this.additionalFilters[this.currentPosition - 1].doFilter(request, response, (FilterChain)this);
            }
        }
    }
}

