/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.captcha;

import org.acegisecurity.captcha.CaptchaSecurityContext;
import org.acegisecurity.context.SecurityContextImpl;

public class CaptchaSecurityContextImpl
extends SecurityContextImpl
implements CaptchaSecurityContext {
    private boolean human = false;
    private int humanRestrictedResourcesRequestsCount = 0;
    private long lastPassedCaptchaDate = 0L;

    public boolean equals(Object obj) {
        if (obj instanceof CaptchaSecurityContextImpl) {
            CaptchaSecurityContextImpl rhs = (CaptchaSecurityContextImpl)obj;
            if (this.isHuman() != rhs.isHuman()) {
                return false;
            }
            if (this.getHumanRestrictedResourcesRequestsCount() != rhs.getHumanRestrictedResourcesRequestsCount()) {
                return false;
            }
            if (this.getLastPassedCaptchaDateInMillis() != rhs.getLastPassedCaptchaDateInMillis()) {
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    public int getHumanRestrictedResourcesRequestsCount() {
        return this.humanRestrictedResourcesRequestsCount;
    }

    public long getLastPassedCaptchaDateInMillis() {
        return this.lastPassedCaptchaDate;
    }

    public int hashCode() {
        int code = super.hashCode();
        code ^= this.humanRestrictedResourcesRequestsCount;
        code = (int)((long)code ^ this.lastPassedCaptchaDate);
        if (this.isHuman()) {
            code ^= 0xFFFFFFDB;
        }
        return code;
    }

    public void incrementHumanRestrictedRessoucesRequestsCount() {
        ++this.humanRestrictedResourcesRequestsCount;
    }

    public boolean isHuman() {
        return this.human;
    }

    public void setHuman() {
        this.human = true;
        this.lastPassedCaptchaDate = System.currentTimeMillis();
        this.humanRestrictedResourcesRequestsCount = 0;
    }
}

