/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import sunlabs.brazil.util.regexp.Regexp;
import tcl.lang.BackSlashResult;
import tcl.lang.Expression;
import tcl.lang.FindElemResult;
import tcl.lang.FormatCmd;
import tcl.lang.Interp;
import tcl.lang.PrecTraceProc;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRegexp;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

public class Util {
    static final int TCL_DONT_USE_BRACES = 1;
    static final int USE_BRACES = 2;
    static final int BRACES_UNMATCHED = 4;
    static final String intTooBigCode = "ARITH IOVERFLOW {integer value too large to represent}";
    static final String fpTooBigCode = "ARITH OVERFLOW {floating-point value too large to represent}";
    static char[] cvtIn = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', 'd', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#'};
    static final int maxExponent = 511;
    static final double[] powersOf10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    static final int DEFAULT_PRECISION = 12;
    static int precision = 12;

    private Util() {
    }

    static void strtoul(String s, int start, int base, StrtoulResult strtoulResult) {
        int digit;
        int i;
        long result = 0L;
        boolean anyDigits = false;
        boolean negative = false;
        int len = s.length();
        char c = '\u0000';
        for (i = start; i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c)); ++i) {
        }
        if (i >= len) {
            strtoulResult.update(0L, 0, -1);
            return;
        }
        if (c == '-') {
            negative = true;
        }
        if (c == '-' || c == '+') {
            if (++i >= len) {
                strtoulResult.update(0L, 0, -1);
                return;
            }
            c = s.charAt(i);
        }
        if (base == 0) {
            if (c == '0') {
                if (i < len - 1 && ((c = s.charAt(++i)) == 'x' || c == 'X')) {
                    ++i;
                    base = 16;
                }
                if (base == 0) {
                    anyDigits = true;
                    base = 8;
                }
            } else {
                base = 10;
            }
        } else if (base == 16 && i < len - 2 && c == '0' && s.charAt(i + 1) == 'x') {
            i += 2;
        }
        long max = 0x100000000L / (long)base;
        boolean overflowed = false;
        while (i < len && (digit = s.charAt(i) - 48) >= 0 && digit <= 74 && (digit = cvtIn[digit]) < base) {
            if (result > max) {
                overflowed = true;
            }
            result = result * (long)base + (long)digit;
            anyDigits = true;
            ++i;
        }
        if (!anyDigits) {
            strtoulResult.update(0L, 0, -1);
        } else if (overflowed) {
            strtoulResult.update(0L, i, -2);
        } else {
            strtoulResult.update(negative ? -result : result, i, 0);
        }
    }

    static int getInt(Interp interp, String s) throws TclException {
        int len = s.length();
        int i = 0;
        StrtoulResult res = interp == null ? new StrtoulResult() : interp.strtoulResult;
        Util.strtoul(s, i, 0, res);
        if (res.errno < 0) {
            if (res.errno == -2) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance((String)intTooBigCode));
                }
                throw new TclException(interp, "integer value too large to represent");
            }
            throw new TclException(interp, "expected integer but got \"" + s + "\"" + Util.checkBadOctal(interp, s));
        }
        if (res.index < len) {
            for (i = res.index; i < len; ++i) {
                char c = s.charAt(i);
                if (c == ' ' || Character.isWhitespace(c)) continue;
                throw new TclException(interp, "expected integer but got \"" + s + "\"" + Util.checkBadOctal(interp, s));
            }
        }
        return (int)res.value;
    }

    static final int getIntForIndex(Interp interp, TclObject tobj, int endValue) throws TclException {
        if (tobj.isIntType()) {
            return TclInteger.get((Interp)interp, (TclObject)tobj);
        }
        String bytes = tobj.toString();
        int length = bytes.length();
        if (length == 0 || !"end".regionMatches(0, bytes, 0, length > 3 ? 3 : length)) {
            int offset;
            try {
                offset = TclInteger.get(null, (TclObject)tobj);
            }
            catch (TclException e) {
                throw new TclException(interp, "bad index \"" + bytes + "\": must be integer or end?-integer?" + Util.checkBadOctal(interp, bytes));
            }
            return offset;
        }
        if (length <= 3) {
            return endValue;
        }
        if (length > 4 && bytes.charAt(3) == '-') {
            try {
                int offset = Util.getInt(interp, bytes.substring(4));
                offset = -offset;
                return endValue + offset;
            }
            catch (TclException ex) {
                // empty catch block
            }
        }
        throw new TclException(interp, "bad index \"" + bytes + "\": must be integer or end?-integer?" + Util.checkBadOctal(interp, bytes.substring(3)));
    }

    static final String checkBadOctal(Interp interp, String value) {
        int p;
        int len = value.length();
        for (p = 0; p < len && Character.isWhitespace(value.charAt(p)); ++p) {
        }
        if (p < len && (value.charAt(p) == '+' || value.charAt(p) == '-')) {
            ++p;
        }
        if (p < len && value.charAt(p) == '0') {
            while (p < len && Character.isDigit(value.charAt(p))) {
                ++p;
            }
            while (p < len && Character.isWhitespace(value.charAt(p))) {
                ++p;
            }
            if (p >= len && interp != null) {
                return " (looks like invalid octal number)";
            }
        }
        return "";
    }

    static void strtod(String s, int start, int len, StrtodResult strtodResult) {
        String sub;
        int decPt = -1;
        int i = start < 0 ? 0 : start;
        boolean negative = false;
        char c = '\u0000';
        if (len < 0) {
            len = s.length();
        }
        while (i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c))) {
            ++i;
        }
        if (i >= len) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        if (c == 'N' || c == 'n') {
            String string = sub = i == 0 ? s : s.substring(i);
            if (sub.toLowerCase().startsWith("nan")) {
                strtodResult.update(Double.NaN, i + 3, 0);
                return;
            }
        }
        if (c == '-') {
            negative = true;
        }
        if (c == '-' || c == '+') {
            if (++i >= len) {
                strtodResult.update(0.0, 0, -3);
                return;
            }
            c = s.charAt(i);
        }
        if (c == 'I') {
            int infLen = 0;
            String string = sub = i == 0 ? s : s.substring(i);
            if (sub.startsWith("Infinity")) {
                infLen = "Infinity".length();
            } else if (sub.startsWith("Inf")) {
                infLen = "Inf".length();
            }
            if (infLen > 0) {
                strtodResult.update(negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY, i + infLen, 0);
                return;
            }
        }
        int si = i;
        boolean maybeZero = true;
        int mantSize = 0;
        while (true) {
            if (!(c >= '0' && c <= '9' || Character.isDigit(c))) {
                if (c != '.' || decPt >= 0) break;
                decPt = mantSize;
            }
            if (c != '0' && c != '.') {
                maybeZero = false;
            }
            if (++i >= len) break;
            c = s.charAt(i);
            ++mantSize;
        }
        if (i < len) {
            if (si != i) {
                c = s.charAt(i);
            }
            if ((c == 'E' || c == 'e') && ++i < len) {
                c = s.charAt(i);
                if (c == '-') {
                    ++i;
                } else if (c == '+') {
                    ++i;
                }
                boolean notdigit = false;
                if (!(i >= len || (c = s.charAt(i)) >= '0' && c <= '9' || Character.isDigit(c))) {
                    notdigit = true;
                }
                if (i >= len || notdigit) {
                    if (c == '-' || c == '+') {
                        --i;
                    }
                    --i;
                } else {
                    while (i < len && ((c = s.charAt(i)) >= '0' && c <= '9' || Character.isDigit(c))) {
                        ++i;
                    }
                }
            }
        }
        if (si == i) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        s = s.substring(si, i);
        double result = 0.0;
        try {
            result = Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        if (result == Double.NEGATIVE_INFINITY || result == Double.POSITIVE_INFINITY || result == 0.0 && !maybeZero) {
            strtodResult.update(result, i, -4);
            return;
        }
        if (result == Double.NaN) {
            strtodResult.update(0.0, 0, -3);
            return;
        }
        strtodResult.update(negative ? -result : result, i, 0);
    }

    static double getDouble(Interp interp, String s) throws TclException {
        int len = s.length();
        int i = 0;
        StrtodResult res = interp == null ? new StrtodResult() : interp.strtodResult;
        Util.strtod(s, i, len, res);
        if (res.errno != 0) {
            if (res.errno == -4) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance((String)fpTooBigCode));
                }
                throw new TclException(interp, "floating-point value too large to represent");
            }
            throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
        }
        if (res.index < len) {
            for (i = res.index; i < len; ++i) {
                char c = s.charAt(i);
                if (c == ' ' || Character.isWhitespace(c)) continue;
                throw new TclException(interp, "expected floating-point number but got \"" + s + "\"");
            }
        }
        return res.value;
    }

    static TclObject concat(int from, int to, TclObject[] objv) throws TclException {
        int elemLength;
        String element;
        TclObject obj;
        int i;
        if (from > objv.length) {
            return TclString.newInstance((String)"");
        }
        if (to <= objv.length) {
            to = objv.length - 1;
        }
        boolean allList = true;
        for (i = from; i <= to; ++i) {
            obj = objv[i];
            if (obj.hasNoStringRep() && obj.isListType()) continue;
            allList = false;
            break;
        }
        if (allList) {
            TclObject tlist = TclList.newInstance();
            for (i = from; i <= to; ++i) {
                obj = objv[i];
                TclObject[] elements = TclList.getElements(null, obj);
                TclList.replace(null, tlist, Integer.MAX_VALUE, 0, elements, 0, elements.length - 1);
            }
            return tlist;
        }
        int allocSize = 0;
        for (i = from; i <= to; ++i) {
            obj = objv[i];
            element = obj.toString();
            elemLength = element.length();
            if (element == null || elemLength <= 0) continue;
            allocSize += elemLength + 1;
        }
        if (allocSize == 0) {
            allocSize = 1;
        }
        StringBuffer concatStr = new StringBuffer(allocSize);
        for (i = from; i <= to; ++i) {
            char c;
            int j;
            obj = objv[i];
            element = obj.toString();
            element = Util.TrimLeft(element, " ");
            elemLength = element.length();
            for (j = elemLength - 1; !(j < 0 || (c = element.charAt(j)) != ' ' && !Character.isWhitespace(c) || j > 0 && element.charAt(j - 1) == '\\'); --j) {
            }
            if (j != elemLength - 1) {
                element = element.substring(0, j + 1);
            }
            if (element.length() == 0) {
                if (i != to || concatStr.length() <= 0) continue;
                concatStr.setLength(concatStr.length() - 1);
                continue;
            }
            concatStr.append(element);
            if (i >= to) continue;
            concatStr.append(' ');
        }
        return TclString.newInstance((StringBuffer)concatStr);
    }

    public static final boolean stringMatch(String str, String pat) {
        char[] strArr = str.toCharArray();
        char[] patArr = pat.toCharArray();
        int strLen = str.length();
        int patLen = pat.length();
        int pIndex = 0;
        int sIndex = 0;
        boolean incrIndex = false;
        while (true) {
            if (incrIndex) {
                ++pIndex;
                ++sIndex;
                incrIndex = false;
            }
            if (pIndex == patLen) {
                return sIndex == strLen;
            }
            if (sIndex == strLen && patArr[pIndex] != '*') {
                return false;
            }
            if (patArr[pIndex] == '*') {
                if (++pIndex == patLen) {
                    return true;
                }
                while (true) {
                    if (Util.stringMatch(str.substring(sIndex), pat.substring(pIndex))) {
                        return true;
                    }
                    if (sIndex == strLen) {
                        return false;
                    }
                    ++sIndex;
                }
            }
            if (patArr[pIndex] == '?') {
                incrIndex = true;
                continue;
            }
            if (patArr[pIndex] == '[') {
                ++pIndex;
                while (true) {
                    if (pIndex == patLen || patArr[pIndex] == ']') {
                        return false;
                    }
                    if (sIndex == strLen) {
                        return false;
                    }
                    char ch1 = patArr[pIndex];
                    char strch = strArr[sIndex];
                    if (pIndex + 1 != patLen && patArr[pIndex + 1] == '-') {
                        if ((pIndex += 2) == patLen) {
                            return false;
                        }
                        char ch2 = patArr[pIndex];
                        if (ch1 <= strch && ch2 >= strch || ch1 >= strch && ch2 <= strch) {
                            break;
                        }
                    } else if (ch1 == strch) break;
                    ++pIndex;
                }
                ++pIndex;
                while (pIndex != patLen && patArr[pIndex] != ']') {
                    ++pIndex;
                }
                if (pIndex == patLen) {
                    --pIndex;
                }
                incrIndex = true;
                continue;
            }
            if (patArr[pIndex] == '\\' && ++pIndex == patLen) {
                return false;
            }
            if (sIndex == strLen || patArr[pIndex] != strArr[sIndex]) {
                return false;
            }
            incrIndex = true;
        }
    }

    static String toTitle(String str) {
        int length = str.length();
        if (length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(length);
        buf.append(Character.toTitleCase(str.charAt(0)));
        buf.append(str.substring(1).toLowerCase());
        return buf.toString();
    }

    static final boolean regExpMatch(Interp interp, String string, TclObject pattern) throws TclException {
        Regexp r = TclRegexp.compile(interp, pattern, false);
        return r.match(string, (String[])null);
    }

    static final void appendElement(Interp interp, StringBuffer sbuf, String s) throws TclException {
        if (sbuf.length() > 0) {
            sbuf.append(' ');
        }
        int flags = Util.scanElement(interp, s);
        Util.convertElement(s, flags, sbuf);
    }

    static final boolean findElement(Interp interp, String s, int i, int len, FindElemResult fer) throws TclException {
        int openBraces = 0;
        boolean inQuotes = false;
        char c = '\u0000';
        int size = 0;
        while (i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c))) {
            ++i;
        }
        if (i >= len) {
            return false;
        }
        if (c == '{') {
            openBraces = 1;
            ++i;
        } else if (c == '\"') {
            inQuotes = true;
            ++i;
        }
        StringBuffer sbuf = null;
        int simpleEnd = -1;
        int elemStart = i;
        int simpleStart = i;
        block8: while (true) {
            if (i >= len) {
                String elem;
                int elemEnd = i;
                size = elemEnd - elemStart;
                if (openBraces != 0) {
                    throw new TclException(interp, "unmatched open brace in list");
                }
                if (inQuotes) {
                    throw new TclException(interp, "unmatched open quote in list");
                }
                if (sbuf == null) {
                    elem = s.substring(elemStart, elemEnd);
                } else {
                    sbuf.append(s.substring(simpleStart, elemEnd));
                    elem = sbuf.toString();
                }
                fer.update(elemStart, elemEnd, elem, size);
                return true;
            }
            c = s.charAt(i);
            switch (c) {
                case '{': {
                    if (openBraces != 0) {
                        ++openBraces;
                    }
                    ++i;
                    continue block8;
                }
                case '}': {
                    if (openBraces == 1) {
                        int errEnd;
                        int elemEnd = i;
                        size = elemEnd - elemStart;
                        if (i == len - 1 || Character.isWhitespace(s.charAt(i + 1))) {
                            String elem;
                            if (sbuf == null) {
                                elem = s.substring(elemStart, elemEnd);
                            } else {
                                sbuf.append(s.substring(simpleStart, elemEnd));
                                elem = sbuf.toString();
                            }
                            fer.update(elemStart, elemEnd + 1, elem, size);
                            return true;
                        }
                        for (errEnd = i + 1; errEnd < len && !Character.isWhitespace(s.charAt(errEnd)); ++errEnd) {
                        }
                        throw new TclException(interp, "list element in braces followed by \"" + s.substring(i + 1, errEnd) + "\" instead of space");
                    }
                    if (openBraces != 0) {
                        --openBraces;
                    }
                    ++i;
                    continue block8;
                }
                case '\\': {
                    BackSlashResult bs = Interp.backslash(s, i, len);
                    if (openBraces <= 0) {
                        if (sbuf == null) {
                            sbuf = new StringBuffer();
                        }
                        sbuf.append(s.substring(simpleStart, i));
                        sbuf.append(bs.c);
                        simpleStart = bs.nextIndex;
                    }
                    i = bs.nextIndex;
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (openBraces == 0 && !inQuotes) {
                        String elem;
                        int elemEnd = i;
                        size = elemEnd - elemStart;
                        if (sbuf == null) {
                            elem = s.substring(elemStart, elemEnd);
                        } else {
                            sbuf.append(s.substring(simpleStart, elemEnd));
                            elem = sbuf.toString();
                        }
                        fer.update(elemStart, elemEnd, elem, size);
                        return true;
                    }
                    ++i;
                    continue block8;
                }
                case '\"': {
                    if (inQuotes) {
                        int errEnd;
                        int elemEnd = i;
                        size = elemEnd - elemStart;
                        if (i == len - 1 || Character.isWhitespace(s.charAt(i + 1))) {
                            String elem;
                            if (sbuf == null) {
                                elem = s.substring(elemStart, elemEnd);
                            } else {
                                sbuf.append(s.substring(simpleStart, elemEnd));
                                elem = sbuf.toString();
                            }
                            fer.update(elemStart, elemEnd + 1, elem, size);
                            return true;
                        }
                        for (errEnd = i + 1; errEnd < len && !Character.isWhitespace(s.charAt(errEnd)); ++errEnd) {
                        }
                        throw new TclException(interp, "list element in quotes followed by \"" + s.substring(i + 1, errEnd) + "\" instead of space");
                    }
                    ++i;
                    continue block8;
                }
            }
            ++i;
        }
    }

    static int scanElement(Interp interp, String string) throws TclException {
        char c;
        boolean debug = false;
        int nestingLevel = 0;
        int flags = 0;
        int i = 0;
        int len = string.length();
        if (len == 0) {
            string = String.valueOf('\u0000');
        }
        if ((c = string.charAt(i)) == '{' || c == '\"' || c == '\u0000') {
            flags |= 2;
        }
        while (i < len) {
            c = string.charAt(i);
            switch (c) {
                case '{': {
                    ++nestingLevel;
                    break;
                }
                case '}': {
                    if (--nestingLevel >= 0) break;
                    flags |= 5;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '$': 
                case ';': 
                case '[': {
                    flags |= 2;
                    break;
                }
                case '\\': {
                    if (i >= len - 1 || string.charAt(i + 1) == '\n') {
                        flags = 5;
                        break;
                    }
                    BackSlashResult bs = Interp.backslash(string, i, len);
                    i = bs.nextIndex - 1;
                    flags |= 2;
                }
            }
            ++i;
        }
        if (nestingLevel != 0) {
            flags = 5;
        }
        return flags;
    }

    /*
     * Enabled aggressive block sorting
     */
    static void convertElement(String s, int flags, StringBuffer sbuf) {
        int i = 0;
        int len = s.length();
        if (s == null || s.length() == 0 || s.charAt(0) == '\u0000') {
            sbuf.append("{}");
            return;
        }
        if ((flags & 2) != 0 && (flags & 1) == 0) {
            sbuf.append('{');
            sbuf.append(s);
            sbuf.append('}');
            return;
        }
        char c = s.charAt(0);
        if (c == '{') {
            sbuf.append('\\');
            sbuf.append('{');
            ++i;
            flags |= 4;
        }
        while (i < len) {
            block13: {
                c = s.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '$': 
                    case ';': 
                    case '[': 
                    case '\\': 
                    case ']': {
                        sbuf.append('\\');
                        break;
                    }
                    case '{': 
                    case '}': {
                        if ((flags & 4) == 0) break;
                        sbuf.append('\\');
                        break;
                    }
                    case '\f': {
                        sbuf.append('\\');
                        sbuf.append('f');
                        break block13;
                    }
                    case '\n': {
                        sbuf.append('\\');
                        sbuf.append('n');
                        break block13;
                    }
                    case '\r': {
                        sbuf.append('\\');
                        sbuf.append('r');
                        break block13;
                    }
                    case '\t': {
                        sbuf.append('\\');
                        sbuf.append('t');
                        break block13;
                    }
                    case '\u000b': {
                        sbuf.append('\\');
                        sbuf.append('v');
                        break block13;
                    }
                }
                sbuf.append(c);
            }
            ++i;
        }
    }

    static String TrimLeft(String str, String pattern) {
        int i;
        char[] strArray = str.toCharArray();
        char[] patternArray = pattern.toCharArray();
        int strLen = strArray.length;
        int patLen = patternArray.length;
        for (i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            boolean done = true;
            for (int j = 0; j < patLen; ++j) {
                char p = pattern.charAt(j);
                if (c != p && (p != ' ' || !Character.isWhitespace(c))) continue;
                done = false;
                break;
            }
            if (done) break;
        }
        return str.substring(i, strLen);
    }

    static String TrimLeft(String str) {
        return Util.TrimLeft(str, " \n\t\r");
    }

    static String TrimRight(String str, String pattern) {
        int last;
        char[] strArray = str.toCharArray();
        char[] patternArray = pattern.toCharArray();
        int patLen = patternArray.length;
        for (last = strArray.length - 1; last >= 0; --last) {
            char c = strArray[last];
            boolean done = true;
            for (int j = 0; j < patLen; ++j) {
                char p = patternArray[j];
                if (c != p && (p != ' ' || !Character.isWhitespace(c))) continue;
                done = false;
                break;
            }
            if (done) break;
        }
        return str.substring(0, last + 1);
    }

    static String TrimRight(String str) {
        return Util.TrimRight(str, " \n\t\r");
    }

    static boolean getBoolean(Interp interp, String string) throws TclException {
        String s = string.toLowerCase();
        int slen = s.length();
        if (slen > 0) {
            char c = s.charAt(0);
            switch (c) {
                case '0': {
                    if (slen != 1) break;
                    return false;
                }
                case '1': {
                    if (slen != 1) break;
                    return true;
                }
                case 'f': {
                    if (!"false".startsWith(s)) break;
                    return false;
                }
                case 'o': {
                    if (slen > 1 && "on".startsWith(s)) {
                        return true;
                    }
                    if (slen <= 1 || !"off".startsWith(s)) break;
                    return false;
                }
                case 'n': {
                    if (!"no".startsWith(s)) break;
                    return false;
                }
                case 't': {
                    if (!"true".startsWith(s)) break;
                    return true;
                }
                case 'y': {
                    if (!"yes".startsWith(s)) break;
                    return true;
                }
            }
        }
        throw new TclException(interp, "expected boolean value but got \"" + string + "\"");
    }

    static final int getActualPlatform() {
        if (Util.isWindows()) {
            return 1;
        }
        if (Util.isMac()) {
            return 2;
        }
        return 0;
    }

    static final boolean isUnix() {
        return !Util.isMac() && !Util.isWindows();
    }

    static final boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("mac") && !os.endsWith("x");
    }

    static final boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("win");
    }

    static boolean isJacl() {
        return true;
    }

    static boolean looksLikeInt(String s) {
        return Expression.looksLikeInt(s, s.length(), 0, true);
    }

    static void setupPrecisionTrace(Interp interp) {
        try {
            interp.traceVar("tcl_precision", (VarTrace)new PrecTraceProc(), 113);
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    static String printDouble(double number) {
        String s = FormatCmd.toString(number, precision, 10);
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) != '.' && !Character.isLetter(s.charAt(i))) continue;
            return s;
        }
        return s + ".0";
    }

    static String tryGetSystemProperty(String propName, String defautlValue) {
        try {
            return System.getProperty(propName);
        }
        catch (SecurityException e) {
            return defautlValue;
        }
    }
}

