/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import tcl.lang.ChannelBuffer;
import tcl.lang.EncodingCmd;
import tcl.lang.TclByteArray;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class TclInputStream {
    private InputStream input;
    private char eofChar;
    private boolean eofCond = false;
    private boolean stickyEofCond = false;
    protected int translation;
    protected String encoding;
    protected CharsetDecoder csd = null;
    protected int buffering;
    protected boolean blocking;
    protected boolean blocked = false;
    protected int bufSize;
    protected boolean needNL = false;
    protected boolean sawCR = false;
    protected boolean needMoreData = false;
    boolean encodingStart = true;
    boolean encodingEnd = false;
    ChannelBuffer inQueueHead = null;
    ChannelBuffer inQueueTail = null;
    ChannelBuffer saveInBuf = null;
    static Integer oneInteger = new Integer(1);
    static Integer twoInteger = new Integer(2);
    static Integer threeInteger = new Integer(3);
    private final int TCL_CONVERT_MULTIBYTE = -1;
    private final int TCL_CONVERT_SYNTAX = -2;
    private final int TCL_CONVERT_UNKNOWN = -3;
    private final int TCL_CONVERT_NOSPACE = -4;

    TclInputStream(InputStream inInput) {
        this.input = inInput;
    }

    static int decodedNumBytes(ArrayList charToBytes, int start, int end) {
        int numBytes = 0;
        for (int i = start; i < end; ++i) {
            Integer iobj = (Integer)charToBytes.get(i);
            numBytes += iobj.intValue();
        }
        return numBytes;
    }

    /*
     * Enabled aggressive block sorting
     */
    int getsObj(TclObject tobj) {
        int dst;
        boolean in_binary_encoding = false;
        boolean debug = false;
        ChannelBuffer buf = this.inQueueHead;
        int oldLength = 0;
        boolean oldEncodingStart = this.encodingStart;
        boolean oldEncodingEnd = this.encodingEnd;
        int oldRemoved = 16;
        if (buf != null) {
            oldRemoved = buf.nextRemoved;
        }
        if (this.encoding == null) {
            in_binary_encoding = true;
            this.encoding = EncodingCmd.getJavaName("iso8859-1");
        }
        GetsState gs = new GetsState();
        gs.obj = tobj;
        gs.charToBytes = new ArrayList(128);
        gs.encoding = this.encoding;
        gs.buf = buf;
        gs.rawRead.i = 0;
        gs.charsWrote.i = 0;
        gs.totalChars = 0;
        TclString.empty((TclObject)tobj);
        StringBuffer obj_sbuf = ((TclString)tobj.getInternalRep()).sbuf;
        int dstEnd = dst = 0;
        int skip = 0;
        int eof = -1;
        char inEofChar = this.eofChar;
        boolean restore = false;
        boolean goteol = false;
        int eol = -1;
        int copiedTotal = -1;
        block6: while (true) {
            if (dst >= dstEnd) {
                if (this.filterBytes(gs) != 0) {
                    restore = true;
                    break;
                }
                dstEnd += gs.charsWrote.i;
            }
            if (inEofChar != '\u0000') {
                for (eol = dst; eol < dstEnd; ++eol) {
                    if (obj_sbuf.charAt(eol) != inEofChar) continue;
                    dstEnd = eol;
                    eof = eol;
                    break;
                }
            }
            switch (this.translation) {
                case 2: {
                    for (eol = dst; eol < dstEnd; ++eol) {
                        if (obj_sbuf.charAt(eol) != '\n') continue;
                        skip = 1;
                        goteol = true;
                        break block6;
                    }
                    break;
                }
                case 3: {
                    for (eol = dst; eol < dstEnd; ++eol) {
                        if (obj_sbuf.charAt(eol) != '\r') continue;
                        skip = 1;
                        goteol = true;
                        break block6;
                    }
                    break;
                }
                case 4: {
                    for (eol = dst; eol < dstEnd; ++eol) {
                        if (obj_sbuf.charAt(eol) != '\r') continue;
                        if (++eol >= dstEnd) {
                            if (eol != eof) {
                                dst = dstEnd;
                                if (this.filterBytes(gs) != 0) {
                                    restore = true;
                                    break block6;
                                }
                                dstEnd += gs.charsWrote.i;
                            }
                            if (eol >= dstEnd) {
                                skip = 0;
                                goteol = true;
                                break block6;
                            }
                        }
                        if (obj_sbuf.charAt(eol) != '\n') continue;
                        --eol;
                        skip = 2;
                        goteol = true;
                        break block6;
                    }
                    break;
                }
                case 0: {
                    eol = dst;
                    skip = 1;
                    if (this.sawCR) {
                        this.sawCR = false;
                        if (eol < dstEnd && obj_sbuf.charAt(eol) == '\n') {
                            IntPtr rawRead = new IntPtr();
                            buf = gs.buf;
                            rawRead.i = TclInputStream.decodedNumBytes(gs.charToBytes, eol, eol + 1);
                            buf.nextRemoved += rawRead.i;
                            gs.rawRead.i -= rawRead.i;
                            --gs.charsWrote.i;
                            obj_sbuf.deleteCharAt(eol);
                            --dstEnd;
                        }
                    }
                    for (eol = dst; eol < dstEnd; ++eol) {
                        if (obj_sbuf.charAt(eol) == '\r') {
                            if (++eol == dstEnd) {
                                if (eol != eof) {
                                    dst = dstEnd;
                                    this.peekAhead(gs);
                                    dstEnd += gs.charsWrote.i;
                                }
                                if (eol >= dstEnd) {
                                    --eol;
                                    this.sawCR = true;
                                    goteol = true;
                                    break block6;
                                }
                            }
                            if (obj_sbuf.charAt(eol) == '\n') {
                                ++skip;
                            }
                            --eol;
                            goteol = true;
                            break block6;
                        }
                        if (obj_sbuf.charAt(eol) != '\n') continue;
                        goteol = true;
                        break block6;
                    }
                }
            }
            if (eof != -1) {
                dstEnd = eof;
                this.eofCond = true;
                this.stickyEofCond = true;
                this.encodingEnd = true;
            }
            if (this.eofCond) {
                skip = 0;
                eol = dstEnd;
                if (eol == oldLength) {
                    obj_sbuf.setLength(oldLength);
                    this.commonGetsCleanup();
                    copiedTotal = -1;
                    break;
                }
                goteol = true;
                break;
            }
            dst = dstEnd;
        }
        if (goteol) {
            int linelen = eol - dst + skip;
            buf = gs.buf;
            int numBytes = TclInputStream.decodedNumBytes(gs.charToBytes, dst, dst + linelen);
            buf.nextRemoved += numBytes;
            gs.charsWrote.i = dst + linelen - dst;
            obj_sbuf.setLength(eol);
            this.commonGetsCleanup();
            this.blocked = false;
            copiedTotal = gs.totalChars + gs.charsWrote.i - skip;
        }
        if (restore) {
            buf = this.inQueueHead;
            buf.nextRemoved = oldRemoved;
            buf = buf.next;
            while (buf != null) {
                buf.nextRemoved = 16;
                buf = buf.next;
            }
            this.commonGetsCleanup();
            this.encodingStart = oldEncodingStart;
            this.encodingEnd = oldEncodingEnd;
            obj_sbuf.setLength(oldLength);
            this.needMoreData = true;
            copiedTotal = -1;
        }
        if (in_binary_encoding) {
            this.encoding = null;
        }
        this.updateInterest();
        tobj.invalidateStringRep();
        String srep = tobj.toString();
        if (copiedTotal > 0) {
            int len = srep.length();
            if (len == copiedTotal) return copiedTotal;
            throw new TclRuntimeError("copiedTotal " + copiedTotal + " != " + len);
        } else {
            if (srep.equals("")) return copiedTotal;
            throw new TclRuntimeError("expected empty TclObject result since copiedTotal is " + copiedTotal);
        }
    }

    int filterBytes(GetsState gs) {
        ChannelBuffer buf;
        block13: {
            ChannelBuffer next;
            int rawLen;
            byte[] raw;
            int rawStart;
            int ENCODING_LINESIZE = 20;
            boolean goto_read = false;
            boolean debug = false;
            TclObject obj = gs.obj;
            buf = gs.buf;
            if (buf != null) {
                buf.nextRemoved += gs.rawRead.i;
                if (buf.nextRemoved >= buf.nextAdded) {
                    buf = buf.next;
                }
            }
            gs.totalChars += gs.charsWrote.i;
            while (true) {
                block15: {
                    block14: {
                        if (goto_read || buf == null) break block14;
                        if (buf.nextAdded != 16) break block15;
                    }
                    if (this.blocked) {
                        if (!this.blocking) {
                            gs.charsWrote.i = 0;
                            gs.rawRead.i = 0;
                            return -1;
                        }
                        this.blocked = false;
                    }
                    if (this.getInput() != 0) {
                        gs.charsWrote.i = 0;
                        gs.rawRead.i = 0;
                        return -1;
                    }
                    gs.buf = buf = this.inQueueTail;
                }
                rawStart = buf.nextRemoved;
                raw = buf.buf;
                int toRead = 20;
                int rawEnd = buf.nextAdded;
                rawLen = rawEnd - rawStart;
                if (toRead > rawLen) {
                    toRead = rawLen;
                }
                char[] dst = new char[toRead];
                int result = this.externalToUnicode(raw, rawStart, rawLen, dst, 0, toRead, gs.rawRead, null, gs.charsWrote, gs.charToBytes);
                TclString.append((TclObject)gs.obj, (char[])dst, (int)0, (int)gs.charsWrote.i);
                this.encodingStart = false;
                if (result != -1) break block13;
                next = buf.next;
                if (buf.nextAdded >= buf.bufLength) break;
                if (gs.rawRead.i > 0) break block13;
                if (this.eofCond) {
                    buf.nextRemoved = buf.nextAdded;
                    break block13;
                }
                goto_read = true;
            }
            if (next == null) {
                buf.next = next = new ChannelBuffer(this.bufSize);
                this.inQueueTail = next;
            }
            int extra = rawLen - gs.rawRead.i;
            System.arraycopy(raw, rawStart + gs.rawRead.i, next.buf, 16 - extra, extra);
            next.nextRemoved -= extra;
            buf.nextAdded -= extra;
        }
        gs.buf = buf;
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    void peekAhead(GetsState gs) {
        goto_cleanup = false;
        buf = gs.buf;
        if (buf.next != null || (bytesLeft = buf.nextAdded - (buf.nextRemoved + gs.rawRead.i)) != 0) ** GOTO lbl9
        if (buf.nextAdded < buf.bufLength) {
            goto_cleanup = true;
        } else {
            if (this.blocking) {
                // empty if block
            }
lbl9:
            // 4 sources

            this.filterBytes(gs);
        }
        if (goto_cleanup) {
            buf.nextRemoved += gs.rawRead.i;
            gs.rawRead.i = 0;
            gs.totalChars += gs.charsWrote.i;
            gs.charsWrote.i = 0;
        }
    }

    void commonGetsCleanup() {
        ChannelBuffer next;
        ChannelBuffer buf = this.inQueueHead;
        while (buf != null) {
            next = buf.next;
            if (buf.nextRemoved < buf.nextAdded) break;
            this.recycleBuffer(buf, false);
            buf = next;
        }
        this.inQueueHead = buf;
        if (buf == null) {
            this.inQueueTail = null;
        } else {
            next = buf.next;
            while (next != null) {
                int extra = buf.bufLength - buf.nextAdded;
                if (extra > 0) {
                    System.arraycopy(next.buf, 16 - extra, buf.buf, buf.nextAdded, extra);
                    buf.nextAdded += extra;
                    next.nextRemoved = 16;
                }
                buf = next;
                next = buf.next;
            }
        }
        if (this.encoding != null) {
            // empty if block
        }
    }

    void close() throws IOException {
        this.discardQueued(true);
    }

    boolean eof() {
        return this.eofCond;
    }

    void setEncoding(String inEncoding) {
        this.encoding = inEncoding;
    }

    void setEofChar(char inEofChar) {
        this.eofChar = inEofChar;
    }

    void setTranslation(int inTranslation) {
        this.translation = inTranslation;
    }

    void setBuffering(int inBuffering) {
        this.buffering = inBuffering;
    }

    void setBufferSize(int inBufSize) {
        this.bufSize = inBufSize;
    }

    void setBlocking(boolean inBlocking) {
        this.blocking = inBlocking;
    }

    boolean isBlocked() {
        return this.blocked;
    }

    boolean sawCR() {
        return this.sawCR;
    }

    int doReadChars(TclObject obj, int toRead) throws IOException {
        int copied;
        block14: {
            boolean debug = false;
            IntPtr offset = new IntPtr();
            if (this.encoding == null) {
                TclByteArray.setLength(null, obj, 0);
            } else {
                TclString.empty((TclObject)obj);
            }
            offset.i = 0;
            if (toRead < 0) {
                toRead = Integer.MAX_VALUE;
            }
            copied = 0;
            while (toRead > 0) {
                int copiedNow = -1;
                if (this.inQueueHead != null) {
                    copiedNow = this.encoding == null ? this.readBytes(obj, toRead, offset) : this.readChars(obj, toRead);
                    ChannelBuffer buf = this.inQueueHead;
                    if (buf.nextRemoved == buf.nextAdded) {
                        ChannelBuffer next = buf.next;
                        this.recycleBuffer(buf, false);
                        this.inQueueHead = next;
                        if (next == null) {
                            this.inQueueTail = null;
                        }
                    }
                }
                if (copiedNow < 0) {
                    int result;
                    if (this.eofCond) break;
                    if (this.blocked) {
                        if (!this.blocking) break;
                        this.blocked = false;
                    }
                    if ((result = this.getInput()) == 0) continue;
                    if (result == 35) break;
                    copied = -1;
                    break block14;
                }
                copied += copiedNow;
                toRead -= copiedNow;
            }
            this.blocked = false;
            if (this.encoding == null) {
                TclByteArray.setLength(null, obj, offset.i);
            }
        }
        this.updateInterest();
        obj.invalidateStringRep();
        String srep = obj.toString();
        if (copied > 0) {
            int len = srep.length();
            if (len != copied) {
                throw new TclRuntimeError("copied " + copied + " != " + len);
            }
        } else if (!srep.equals("")) {
            throw new TclRuntimeError("expected empty TclObject result since copied is " + copied);
        }
        return copied;
    }

    int readBytes(TclObject obj, int bytesToRead, IntPtr offsetPtr) {
        IntPtr srcRead;
        IntPtr dstWrote;
        boolean debug = false;
        int offset = offsetPtr.i;
        ChannelBuffer buf = this.inQueueHead;
        byte[] src = buf.buf;
        int srcOff = buf.nextRemoved;
        int toRead = bytesToRead;
        int srcLen = buf.nextAdded - buf.nextRemoved;
        if (toRead > srcLen) {
            toRead = srcLen;
        }
        int length = TclByteArray.getLength(null, obj);
        byte[] dst = TclByteArray.getBytes(null, obj);
        if (toRead > length - offset - 1) {
            length = offset * 2;
            if (offset < toRead) {
                length = offset + toRead + 1;
            }
            dst = TclByteArray.setLength(null, obj, length);
        }
        if (this.needNL) {
            this.needNL = false;
            if (srcLen == 0 || src[srcOff] != 10) {
                dst[offset] = 13;
                ++offsetPtr.i;
                return 1;
            }
            dst[offset++] = 10;
            ++srcOff;
            --srcLen;
            --toRead;
        }
        if (this.translateEOL(dst, offset, src, srcOff, dstWrote = new IntPtr(toRead), srcRead = new IntPtr(srcLen)) != 0 && dstWrote.i == 0) {
            return -1;
        }
        buf.nextRemoved += srcRead.i;
        offsetPtr.i += dstWrote.i;
        return dstWrote.i;
    }

    int readChars(TclObject tobj, int charsToRead) throws IOException {
        boolean debug = false;
        IntPtr srcRead = new IntPtr();
        IntPtr numChars = new IntPtr();
        IntPtr dstRead = new IntPtr();
        IntPtr dstWrote = new IntPtr();
        ChannelBuffer buf = this.inQueueHead;
        byte[] src = buf.buf;
        int srcOff = buf.nextRemoved;
        int srcLen = buf.nextAdded - buf.nextRemoved;
        if (srcLen == 0) {
            if (this.needNL) {
                this.needNL = false;
                TclString.append((TclObject)tobj, (String)"\r");
                return 1;
            }
            return -1;
        }
        if (this.eofCond) {
            return -1;
        }
        int toRead = charsToRead;
        if (toRead > srcLen) {
            toRead = srcLen;
        }
        int dstNeeded = toRead;
        char[] dst = new char[dstNeeded];
        int dstOff = 0;
        if (this.needNL) {
            this.needNL = false;
            this.externalToUnicode(src, srcOff, srcLen, dst, dstOff, 1, srcRead, dstWrote, numChars, null);
            if (numChars.i > 0 && dst[dstOff] == '\n') {
                buf.nextRemoved += srcRead.i;
            } else {
                dst[dstOff] = 13;
            }
            this.encodingStart = false;
            TclString.append((TclObject)tobj, (char[])dst, (int)dstOff, (int)1);
            return 1;
        }
        ArrayList charToBytes = new ArrayList(dstNeeded);
        this.externalToUnicode(src, srcOff, srcLen, dst, dstOff, dstNeeded, srcRead, dstWrote, numChars, charToBytes);
        if (srcRead.i == 0) {
            ChannelBuffer next = buf.next;
            if (next == null) {
                if (srcLen > 0) {
                    this.needMoreData = true;
                }
                return -1;
            }
            if (next.nextRemoved - srcLen < 0) {
                throw new TclRuntimeError("Buffer Underflow, BUFFER_PADDING not enough");
            }
            next.nextRemoved -= srcLen;
            System.arraycopy(src, srcOff, next.buf, next.nextRemoved, srcLen);
            this.recycleBuffer(buf, false);
            this.inQueueHead = next;
            return this.readChars(tobj, charsToRead);
        }
        dstRead.i = dstWrote.i;
        if (this.translateEOL(dst, dstOff, dst, dstOff, dstWrote, dstRead) != 0) {
            int numBytes;
            if (dstWrote.i == 0) {
                return -1;
            }
            srcRead.i = numBytes = TclInputStream.decodedNumBytes(charToBytes, dstOff, dstRead.i);
            numChars.i = dstWrote.i = dstWrote.i;
            this.translateEOL(dst, dstOff, dst, dstOff, dstWrote, dstRead);
        }
        numChars.i -= dstRead.i - dstWrote.i;
        if (numChars.i > toRead) {
            throw new TclRuntimeError("got more chars " + numChars.i + " than requested " + toRead);
        }
        this.encodingStart = false;
        buf.nextRemoved += srcRead.i;
        TclString.append((TclObject)tobj, (char[])dst, (int)dstOff, (int)numChars.i);
        return numChars.i;
    }

    int externalToUnicode(byte[] src, int srcOff, int srcLen, char[] dst, int dstOff, int dstLen, IntPtr srcReadPtr, IntPtr dstWrotePtr, IntPtr dstCharsPtr, ArrayList charToBytes) {
        boolean atEOF;
        boolean debug = false;
        boolean debug_decode_loop = false;
        int result = 0;
        if (this.encoding == null) {
            throw new TclRuntimeError("externalToUnicode called with null encoding");
        }
        if (srcLen == 0 && !this.encodingEnd) {
            srcReadPtr.i = 0;
            if (dstWrotePtr != null) {
                dstWrotePtr.i = 0;
            }
            if (dstCharsPtr != null) {
                dstCharsPtr.i = 0;
            }
            return 0;
        }
        if (this.csd == null) {
            Charset chrset = Charset.forName(this.encoding);
            this.csd = chrset.newDecoder();
        }
        if (this.encodingStart) {
            this.csd.reset();
        }
        int bytes_read = 0;
        int chars_written = 0;
        int dstOffI = dstOff;
        ByteBuffer srcb = ByteBuffer.wrap(src, srcOff, srcLen);
        CharBuffer oneChar = CharBuffer.allocate(1);
        while (srcb.remaining() > 0 && dstOffI < dstLen) {
            int srcbStartPos = srcb.position();
            oneChar.rewind();
            CoderResult cresult = this.csd.decode(srcb, oneChar, false);
            if (cresult == CoderResult.UNDERFLOW) {
                if (oneChar.position() == 0 && srcb.remaining() > 0) {
                    result = -1;
                    break;
                }
            } else if (cresult != CoderResult.OVERFLOW) {
                result = -1;
                break;
            }
            int bytes_this_char = srcb.position() - srcbStartPos;
            if (oneChar.position() != 1) {
                throw new TclRuntimeError("expected 1 char to be decoded, got " + oneChar.position());
            }
            char c = oneChar.get(0);
            dst[dstOffI++] = c;
            if (charToBytes != null) {
                Integer iobj = bytes_this_char == 1 ? oneInteger : (bytes_this_char == 2 ? twoInteger : (bytes_this_char == 3 ? threeInteger : new Integer(bytes_this_char)));
                charToBytes.add(iobj);
            }
            bytes_read += bytes_this_char;
            ++chars_written;
        }
        if (dstOffI >= dstLen && srcb.remaining() > 0) {
            result = -4;
        }
        boolean bl = atEOF = this.eofCond && this.encodingEnd;
        if (atEOF && dstOffI >= dstLen) {
            result = -4;
        }
        if (atEOF && result == 0) {
            ByteBuffer emptyBytes = ByteBuffer.allocate(0);
            CharBuffer dstb = CharBuffer.wrap(dst, dstOffI, dstLen - dstOffI);
            int dstbStartPos = dstb.position();
            CoderResult cresult1 = this.csd.decode(emptyBytes, dstb, true);
            CoderResult cresult2 = this.csd.flush(dstb);
            if (cresult2 == CoderResult.OVERFLOW) {
                result = -4;
            } else {
                this.encodingEnd = false;
            }
            int chars_flushed = dstb.position() - chars_written;
            chars_written += chars_flushed;
        }
        srcReadPtr.i = bytes_read;
        if (dstWrotePtr != null) {
            dstWrotePtr.i = chars_written;
        }
        if (dstCharsPtr != null) {
            dstCharsPtr.i = chars_written;
        }
        return result;
    }

    private int getInput() {
        int nread;
        int toRead;
        boolean debug = false;
        ChannelBuffer buf = this.inQueueTail;
        if (buf != null && buf.nextAdded < buf.bufLength) {
            toRead = buf.bufLength - buf.nextAdded;
        } else {
            buf = this.saveInBuf;
            this.saveInBuf = null;
            if (buf != null) {
                if (buf.bufLength - 16 < this.bufSize) {
                    buf = null;
                }
            }
            if (buf == null) {
                buf = new ChannelBuffer(this.bufSize);
            }
            buf.next = null;
            toRead = buf.bufLength - buf.nextAdded;
            if (this.inQueueTail == null) {
                this.inQueueHead = buf;
            } else {
                this.inQueueTail.next = buf;
            }
            this.inQueueTail = buf;
        }
        if (this.eofCond) {
            return 0;
        }
        if (!this.blocking) {
            return 35;
        }
        int result = 0;
        int numAvailable = 0;
        if (!this.blocking && numAvailable < toRead) {
            result = 35;
            nread = -1;
        } else {
            try {
                nread = this.input.read(buf.buf, buf.nextAdded, toRead);
                if (nread == -1) {
                    nread = 0;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                nread = -1;
            }
        }
        if (nread > 0) {
            buf.nextAdded += nread;
            if (nread < toRead) {
                this.blocked = true;
            }
        } else if (nread == 0) {
            this.eofCond = true;
            this.encodingEnd = true;
        } else if (nread < 0) {
            if (result == 35 || result == 35) {
                this.blocked = true;
                result = 35;
            }
            return result;
        }
        return 0;
    }

    private void recycleBuffer(ChannelBuffer buf, boolean mustDiscard) {
        if (mustDiscard) {
            return;
        }
        if (buf.bufLength - 16 < this.bufSize) {
            return;
        }
        if (this.inQueueHead == null) {
            this.inQueueHead = buf;
            this.inQueueTail = buf;
            buf.nextRemoved = 16;
            buf.nextAdded = 16;
            buf.next = null;
            return;
        }
        if (this.saveInBuf == null) {
            this.saveInBuf = buf;
            buf.nextRemoved = 16;
            buf.nextAdded = 16;
            buf.next = null;
            return;
        }
    }

    private void discardQueued(boolean discardSavedBuffers) {
        ChannelBuffer buf = this.inQueueHead;
        this.inQueueHead = null;
        this.inQueueTail = null;
        while (buf != null) {
            ChannelBuffer nxt = buf.next;
            this.recycleBuffer(buf, discardSavedBuffers);
            buf = nxt;
        }
        if (discardSavedBuffers && this.saveInBuf != null) {
            this.saveInBuf = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    int translateEOL(Object dstArray, int dstStart, Object srcArray, int srcStart, IntPtr dstLenPtr, IntPtr srcLenPtr) {
        void var14_19;
        int srcLen;
        void index;
        void var11_11;
        void var9_9;
        void var8_8;
        byte[] dstArrayByte;
        byte[] srcArrayByte;
        char[] dstArrayChar;
        char[] srcArrayChar;
        boolean isCharType;
        boolean debug = false;
        if (srcArray instanceof char[] && dstArray instanceof char[]) {
            isCharType = true;
            srcArrayChar = (char[])srcArray;
            dstArrayChar = (char[])dstArray;
            srcArrayByte = null;
            dstArrayByte = null;
        } else if (srcArray instanceof byte[] && dstArray instanceof byte[]) {
            isCharType = false;
            srcArrayChar = null;
            dstArrayChar = null;
            srcArrayByte = (byte[])srcArray;
            dstArrayByte = (byte[])dstArray;
        } else {
            throw new TclRuntimeError("unknown array argument types");
        }
        int dstLen = dstLenPtr.i;
        int eof = -1;
        char inEofChar = this.eofChar;
        if (inEofChar != '\u0000') {
            int srcMax = srcStart + srcLenPtr.i;
            for (int src = srcStart; src < srcMax; ++src) {
                index = var8_8 != false ? var9_9[src] : var11_11[src];
                if (index != inEofChar) continue;
                eof = src;
                srcLen = src - srcStart;
                if (srcLen < dstLen) {
                    dstLen = srcLen;
                }
                srcLenPtr.i = srcLen;
                break;
            }
        }
        switch (this.translation) {
            case 2: {
                if (dstArray != srcArray || dstArray == srcArray && dstStart != srcStart) {
                    System.arraycopy(srcArray, srcStart, dstArray, dstStart, dstLen);
                }
                srcLen = dstLen;
                break;
            }
            case 3: {
                int dst;
                if (dstArray != srcArray || dstArray == srcArray && dstStart != srcStart) {
                    System.arraycopy(srcArray, srcStart, dstArray, dstStart, dstLen);
                }
                int dstEnd = dstStart + dstLen;
                if (var8_8 != false) {
                    for (dst = dstStart; dst < dstEnd; ++dst) {
                        void var10_10;
                        if (var10_10[dst] != 13) continue;
                        var10_10[dst] = 10;
                    }
                } else {
                    for (dst = dstStart; dst < dstEnd; ++dst) {
                        void var12_12;
                        if (var12_12[dst] != 13) continue;
                        var12_12[dst] = 10;
                    }
                }
                srcLen = dstLen;
                break;
            }
            case 4: {
                int dst = dstStart;
                int src = srcStart;
                int srcEnd = srcStart + dstLen;
                int srcMax = srcStart + srcLenPtr.i;
                if (var8_8 != false) {
                    while (src < srcEnd) {
                        if (var9_9[src] == 13) {
                            if (++src >= srcMax) {
                                this.needNL = true;
                                continue;
                            }
                            if (var9_9[src] == 10) {
                                var10_10[dst++] = var9_9[src++];
                                continue;
                            }
                            var10_10[dst++] = 13;
                            continue;
                        }
                        var10_10[dst++] = var9_9[src++];
                    }
                } else {
                    while (src < srcEnd) {
                        if (var11_11[src] == 13) {
                            if (++src >= srcMax) {
                                this.needNL = true;
                                continue;
                            }
                            if (var11_11[src] == 10) {
                                var12_12[dst++] = var11_11[src++];
                                continue;
                            }
                            var12_12[dst++] = 13;
                            continue;
                        }
                        var12_12[dst++] = var11_11[src++];
                    }
                }
                srcLen = src - srcStart;
                dstLen = dst - dstStart;
                break;
            }
            case 0: {
                int dst = dstStart;
                int src = srcStart;
                int srcEnd = srcStart + dstLen;
                int srcMax = srcStart + srcLenPtr.i;
                if (this.sawCR && src < srcMax) {
                    index = var8_8 != false ? var9_9[src] : var11_11[src];
                    if (index == 10) {
                        ++src;
                    }
                    this.sawCR = false;
                }
                if (var8_8 != false) {
                    while (src < srcEnd) {
                        if (var9_9[src] == 13) {
                            if (++src >= srcMax) {
                                this.sawCR = true;
                            } else if (var9_9[src] == 10) {
                                if (srcEnd < srcMax) {
                                    ++srcEnd;
                                }
                                ++src;
                            }
                            var10_10[dst++] = 10;
                            continue;
                        }
                        var10_10[dst++] = var9_9[src++];
                    }
                } else {
                    while (src < srcEnd) {
                        if (var11_11[src] == 13) {
                            if (++src >= srcMax) {
                                this.sawCR = true;
                            } else if (var11_11[src] == 10) {
                                if (srcEnd < srcMax) {
                                    ++srcEnd;
                                }
                                ++src;
                            }
                            var12_12[dst++] = 10;
                            continue;
                        }
                        var12_12[dst++] = var11_11[src++];
                    }
                }
                srcLen = src - srcStart;
                dstLen = dst - dstStart;
                break;
            }
            default: {
                throw new TclRuntimeError("invalid translation");
            }
        }
        dstLenPtr.i = dstLen;
        if (eof != -1 && srcStart + var14_19 >= eof) {
            this.eofCond = true;
            this.stickyEofCond = true;
            this.encodingEnd = true;
            this.sawCR = false;
            this.needNL = false;
            return 1;
        }
        srcLenPtr.i = var14_19;
        return 0;
    }

    void updateInterest() {
    }

    int getNumBufferedBytes() {
        int IOQueued = 0;
        ChannelBuffer buf = this.inQueueHead;
        while (buf != null) {
            IOQueued += buf.nextAdded - buf.nextRemoved;
            buf = buf.next;
        }
        return IOQueued;
    }

    void seekReset() {
        this.discardQueued(false);
        this.eofCond = false;
        this.stickyEofCond = false;
        this.blocked = false;
        this.sawCR = false;
    }

    private class IntPtr {
        int i;

        IntPtr() {
        }

        IntPtr(int value) {
            this.i = value;
        }
    }

    private class GetsState {
        TclObject obj;
        ArrayList charToBytes;
        String encoding;
        ChannelBuffer buf;
        IntPtr rawRead;
        IntPtr charsWrote;
        int totalChars;

        private GetsState() {
            this.rawRead = new IntPtr();
            this.charsWrote = new IntPtr();
        }
    }
}

