/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import tcl.lang.CallFrame;
import tcl.lang.ImportRef;
import tcl.lang.ImportedCmdData;
import tcl.lang.Interp;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class Namespace {
    public String name;
    public String fullName;
    public DeleteProc deleteProc;
    public Namespace parent;
    public HashMap childTable;
    public long nsId;
    public Interp interp;
    public int flags;
    public int activationCount;
    public int refCount;
    public HashMap cmdTable;
    public HashMap varTable;
    public String[] exportArray;
    public int numExportPatterns;
    public int maxExportPatterns;
    public Resolver resolver;
    public static final int FIND_ONLY_NS = 4096;
    private static final int NUM_TRAIL_ELEMS = 5;
    private static long numNsCreated = 0L;
    private static Object nsMutex = new Object();
    static final int NS_DYING = 1;
    static final int NS_DEAD = 2;
    public static final int CREATE_NS_IF_UNKNOWN = 2048;

    public String toString() {
        return this.fullName;
    }

    public static Namespace getCurrentNamespace(Interp interp) {
        if (interp.varFrame != null) {
            return interp.varFrame.ns;
        }
        return interp.globalNs;
    }

    public static Namespace getGlobalNamespace(Interp interp) {
        return interp.globalNs;
    }

    public static void pushCallFrame(Interp interp, CallFrame frame, Namespace namespace, boolean isProcCallFrame) {
        Namespace ns;
        if (namespace == null) {
            ns = Namespace.getCurrentNamespace(interp);
        } else {
            ns = namespace;
            if ((ns.flags & 2) != 0) {
                throw new TclRuntimeError("Trying to push call frame for dead namespace");
            }
        }
        ++ns.activationCount;
        frame.ns = ns;
        frame.isProcCallFrame = isProcCallFrame;
        frame.objv = null;
        frame.caller = interp.frame;
        frame.callerVar = interp.varFrame;
        frame.level = interp.varFrame != null ? interp.varFrame.level + 1 : 1;
        frame.varTable = null;
        interp.frame = frame;
        interp.varFrame = frame;
    }

    public static void popCallFrame(Interp interp) {
        CallFrame frame = interp.frame;
        interp.frame = frame.caller;
        interp.varFrame = frame.callerVar;
        int saveErrFlag = interp.flags & 2;
        if (frame.varTable != null) {
            Var.deleteVars(interp, frame.varTable);
            frame.varTable = null;
        }
        interp.flags |= saveErrFlag;
        Namespace ns = frame.ns;
        --ns.activationCount;
        if ((ns.flags & 1) != 0 && ns.activationCount == 0) {
            Namespace.deleteNamespace(ns);
        }
        frame.ns = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace createNamespace(Interp interp, String name, DeleteProc deleteProc) {
        String simpleName;
        Namespace parent;
        Namespace globalNs = Namespace.getGlobalNamespace(interp);
        if (globalNs == null && interp.varFrame == null) {
            parent = null;
            simpleName = "";
        } else {
            if (name.length() == 0) {
                interp.setResult("can't create namespace \"\": only global namespace can have empty name");
                return null;
            }
            GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
            Namespace.getNamespaceForQualName(interp, name, null, 2560, gnfqnr);
            parent = gnfqnr.ns;
            simpleName = gnfqnr.simpleName;
            if (simpleName.length() == 0) {
                return parent;
            }
            if (parent.childTable.get(simpleName) != null) {
                interp.setResult("can't create namespace \"" + name + "\": already exists");
                return null;
            }
        }
        Namespace ns = new Namespace();
        ns.name = simpleName;
        ns.fullName = null;
        ns.deleteProc = deleteProc;
        ns.parent = parent;
        ns.childTable = new HashMap();
        Object object = nsMutex;
        synchronized (object) {
            ns.nsId = ++numNsCreated;
        }
        ns.interp = interp;
        ns.flags = 0;
        ns.activationCount = 0;
        ns.refCount = 1;
        ns.cmdTable = new HashMap();
        ns.varTable = new HashMap();
        ns.exportArray = null;
        ns.numExportPatterns = 0;
        ns.maxExportPatterns = 0;
        ns.resolver = null;
        if (parent != null) {
            parent.childTable.put(simpleName, ns);
        }
        StringBuffer buffer1 = new StringBuffer();
        StringBuffer buffer2 = new StringBuffer();
        Namespace ancestor = ns;
        while (ancestor != null) {
            if (ancestor != globalNs) {
                buffer1.append("::");
                buffer1.append(ancestor.name);
            }
            buffer1.append(buffer2);
            buffer2.setLength(0);
            buffer2.append(buffer1);
            buffer1.setLength(0);
            ancestor = ancestor.parent;
        }
        ns.fullName = name = buffer2.toString();
        return ns;
    }

    public static void deleteNamespace(Namespace namespace) {
        Namespace ns = namespace;
        Interp interp = ns.interp;
        Namespace globalNs = Namespace.getGlobalNamespace(interp);
        if (ns.activationCount > 0) {
            ns.flags |= 1;
            if (ns.parent != null) {
                ns.parent.childTable.remove(ns.name);
            }
            ns.parent = null;
        } else {
            Namespace.teardownNamespace(ns);
            if (ns != globalNs || (interp.flags & 1) != 0) {
                Var.deleteVars(ns.interp, ns.varTable);
                ns.childTable.clear();
                ns.cmdTable.clear();
                if (ns.refCount == 0) {
                    Namespace.free(ns);
                } else {
                    ns.flags |= 2;
                }
            }
        }
    }

    static void teardownNamespace(Namespace ns) {
        WrappedCommand cmd;
        Namespace childNs;
        Interp interp = ns.interp;
        Namespace globalNs = Namespace.getGlobalNamespace(interp);
        if (ns == globalNs) {
            String errorCodeStr;
            String errorInfoStr;
            try {
                errorInfoStr = interp.getVar("errorInfo", 1).toString();
            }
            catch (TclException e) {
                errorInfoStr = null;
            }
            try {
                errorCodeStr = interp.getVar("errorCode", 1).toString();
            }
            catch (TclException e) {
                errorCodeStr = null;
            }
            Var.deleteVars(interp, ns.varTable);
            if (errorInfoStr != null) {
                try {
                    interp.setVar("errorInfo", errorInfoStr, 1);
                }
                catch (TclException e) {
                    // empty catch block
                }
            }
            if (errorCodeStr != null) {
                try {
                    interp.setVar("errorCode", errorCodeStr, 1);
                }
                catch (TclException e) {}
            }
        } else {
            Var.deleteVars(interp, ns.varTable);
        }
        if (ns.parent != null) {
            ns.parent.childTable.remove(ns.name);
        }
        ns.parent = null;
        while ((childNs = (Namespace)Namespace.FirstHashEntry(ns.childTable)) != null) {
            Namespace.deleteNamespace(childNs);
        }
        while ((cmd = (WrappedCommand)Namespace.FirstHashEntry(ns.cmdTable)) != null) {
            interp.deleteCommandFromToken(cmd);
        }
        if (ns.exportArray != null) {
            ns.exportArray = null;
            ns.numExportPatterns = 0;
            ns.maxExportPatterns = 0;
        }
        if (ns.deleteProc != null) {
            ns.deleteProc.delete();
        }
        ns.deleteProc = null;
        ns.nsId = 0L;
    }

    static void free(Namespace ns) {
        ns.name = null;
        ns.fullName = null;
    }

    public static void exportList(Interp interp, Namespace namespace, String pattern, boolean resetListFirst) throws TclException {
        int INIT_EXPORT_PATTERNS = 5;
        Namespace currNs = Namespace.getCurrentNamespace(interp);
        Namespace ns = namespace == null ? currNs : namespace;
        if (resetListFirst && ns.exportArray != null) {
            for (int i = 0; i < ns.numExportPatterns; ++i) {
                ns.exportArray[i] = null;
            }
            ns.exportArray = null;
            ns.numExportPatterns = 0;
            ns.maxExportPatterns = 0;
        }
        GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, pattern, ns, 512, gnfqnr);
        Namespace exportNs = gnfqnr.ns;
        String simplePattern = gnfqnr.simpleName;
        if (exportNs != ns || pattern.compareTo(simplePattern) != 0) {
            throw new TclException(interp, "invalid export pattern \"" + pattern + "\": pattern can't specify a namespace");
        }
        int neededElems = ns.numExportPatterns + 1;
        if (ns.exportArray == null) {
            ns.exportArray = new String[5];
            ns.numExportPatterns = 0;
            ns.maxExportPatterns = 5;
        } else if (neededElems > ns.maxExportPatterns) {
            int numNewElems = 2 * ns.maxExportPatterns;
            String[] newArray = new String[numNewElems];
            System.arraycopy(ns.exportArray, 0, newArray, 0, ns.numExportPatterns);
            ns.exportArray = newArray;
            ns.maxExportPatterns = numNewElems;
        }
        ns.exportArray[ns.numExportPatterns] = pattern;
        ++ns.numExportPatterns;
    }

    static void appendExportList(Interp interp, Namespace namespace, TclObject obj) throws TclException {
        Namespace ns = namespace == null ? Namespace.getCurrentNamespace(interp) : namespace;
        for (int i = 0; i < ns.numExportPatterns; ++i) {
            TclList.append(interp, obj, TclString.newInstance((String)ns.exportArray[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importList(Interp interp, Namespace namespace, String pattern, boolean allowOverwrite) throws TclException {
        WrappedCommand cmd;
        Namespace currNs = Namespace.getCurrentNamespace(interp);
        Namespace ns = namespace == null ? currNs : namespace;
        WrappedCommand autoCmd = Namespace.findCommand(interp, "auto_import", null, 1);
        if (autoCmd != null) {
            TclObject[] objv = new TclObject[2];
            objv[0] = TclString.newInstance((String)"auto_import");
            objv[0].preserve();
            objv[1] = TclString.newInstance((String)pattern);
            objv[1].preserve();
            cmd = autoCmd;
            try {
                cmd.cmd.cmdProc(interp, objv);
            }
            finally {
                objv[0].release();
                objv[1].release();
            }
            interp.resetResult();
        }
        if (pattern.length() == 0) {
            throw new TclException(interp, "empty import pattern");
        }
        GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, pattern, ns, 512, gnfqnr);
        Namespace importNs = gnfqnr.ns;
        String simplePattern = gnfqnr.simpleName;
        if (importNs == null) {
            throw new TclException(interp, "unknown namespace in import pattern \"" + pattern + "\"");
        }
        if (importNs == ns) {
            if (pattern == simplePattern) {
                throw new TclException(interp, "no namespace specified in import pattern \"" + pattern + "\"");
            }
            throw new TclException(interp, "import pattern \"" + pattern + "\" tries to import from namespace \"" + importNs.name + "\" into itself");
        }
        Iterator iter = importNs.cmdTable.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String cmdName = (String)entry.getKey();
            if (!Util.stringMatch(cmdName, simplePattern)) continue;
            boolean wasExported = false;
            for (int i = 0; i < importNs.numExportPatterns; ++i) {
                if (!Util.stringMatch(cmdName, importNs.exportArray[i])) continue;
                wasExported = true;
                break;
            }
            if (!wasExported) continue;
            if (ns.cmdTable.get(cmdName) == null || allowOverwrite) {
                WrappedCommand realCmd;
                StringBuffer ds = new StringBuffer();
                ds.append(ns.fullName);
                if (ns != interp.globalNs) {
                    ds.append("::");
                }
                ds.append(cmdName);
                cmd = (WrappedCommand)importNs.cmdTable.get(cmdName);
                if (cmd.cmd instanceof ImportedCmdData && (realCmd = Namespace.getOriginalCommand(cmd)) != null && realCmd.ns == currNs && currNs.cmdTable.get(cmdName) != null) {
                    throw new TclException(interp, "import pattern \"" + pattern + "\" would create a loop containing command \"" + ds.toString() + "\"");
                }
                ImportedCmdData data = new ImportedCmdData();
                interp.createCommand(ds.toString(), data);
                WrappedCommand importedCmd = Namespace.findCommand(interp, ds.toString(), ns, 514);
                data.realCmd = cmd;
                data.self = importedCmd;
                ImportRef ref = new ImportRef();
                ref.importedCmd = importedCmd;
                ref.next = cmd.importRef;
                cmd.importRef = ref;
                continue;
            }
            throw new TclException(interp, "can't import command \"" + cmdName + "\": already exists");
        }
    }

    static void forgetImport(Interp interp, Namespace namespace, String pattern) throws TclException {
        Namespace ns = namespace == null ? Namespace.getCurrentNamespace(interp) : namespace;
        GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, pattern, ns, 512, gnfqnr);
        Namespace importNs = gnfqnr.ns;
        Namespace actualCtx = gnfqnr.actualCxt;
        String simplePattern = gnfqnr.simpleName;
        if (importNs == null) {
            throw new TclException(interp, "unknown namespace in namespace forget pattern \"" + pattern + "\"");
        }
        Iterator iter = importNs.cmdTable.entrySet().iterator();
        while (iter.hasNext()) {
            WrappedCommand cmd;
            Map.Entry entry = iter.next();
            String cmdName = (String)entry.getKey();
            if (!Util.stringMatch(cmdName, simplePattern) || (cmd = (WrappedCommand)ns.cmdTable.get(cmdName)) == null || !(cmd.cmd instanceof ImportedCmdData)) continue;
            interp.deleteCommandFromToken(cmd);
        }
    }

    public static WrappedCommand getOriginalCommand(WrappedCommand command) {
        WrappedCommand cmd = command;
        if (!(cmd.cmd instanceof ImportedCmdData)) {
            return null;
        }
        while (cmd.cmd instanceof ImportedCmdData) {
            ImportedCmdData data = (ImportedCmdData)cmd.cmd;
            cmd = data.realCmd;
        }
        return cmd;
    }

    static void invokeImportedCmd(Interp interp, ImportedCmdData data, TclObject[] objv) throws TclException {
        WrappedCommand realCmd = data.realCmd;
        realCmd.cmd.cmdProc(interp, objv);
    }

    static void deleteImportedCmd(ImportedCmdData data) {
        WrappedCommand realCmd = data.realCmd;
        WrappedCommand self = data.self;
        ImportRef prev = null;
        ImportRef ref = realCmd.importRef;
        while (ref != null) {
            if (ref.importedCmd == self) {
                if (prev == null) {
                    realCmd.importRef = ref.next;
                } else {
                    prev.next = ref.next;
                }
                ref = null;
                data = null;
                return;
            }
            prev = ref;
            ref = ref.next;
        }
        throw new TclRuntimeError("DeleteImportedCmd: did not find cmd in real cmd's list of import references");
    }

    /*
     * Enabled aggressive block sorting
     */
    static void getNamespaceForQualName(Interp interp, String qualName, Namespace cxtNs, int flags, GetNamespaceForQualNameResult gnfqnr) {
        gnfqnr.ns = null;
        gnfqnr.altNs = null;
        gnfqnr.actualCxt = null;
        gnfqnr.simpleName = null;
        Namespace ns = cxtNs;
        Namespace globalNs = Namespace.getGlobalNamespace(interp);
        if ((flags & 1) != 0) {
            ns = globalNs;
        } else if (ns == null) {
            ns = interp.varFrame != null ? interp.varFrame.ns : interp.globalNs;
        }
        int start_ind = 0;
        int name_len = qualName.length();
        if (name_len >= 2 && qualName.charAt(0) == ':' && qualName.charAt(1) == ':') {
            for (start_ind = 2; start_ind < name_len && qualName.charAt(start_ind) == ':'; ++start_ind) {
            }
            ns = globalNs;
            if (start_ind >= name_len) {
                gnfqnr.ns = globalNs;
                gnfqnr.altNs = null;
                gnfqnr.actualCxt = globalNs;
                gnfqnr.simpleName = "";
                return;
            }
        }
        gnfqnr.actualCxt = ns;
        Namespace altNs = globalNs;
        if (ns == globalNs || (flags & 0x1002) != 0) {
            altNs = null;
        }
        int end_ind = start_ind;
        while (true) {
            String nsName;
            int len;
            if (start_ind < name_len) {
                len = 0;
            } else {
                gnfqnr.simpleName = (flags & 0x1000) != 0 || end_ind > start_ind && qualName.charAt(end_ind - 1) != ':' ? null : qualName.substring(end_ind);
                if ((flags & 0x1000) != 0 && name_len == 0 && ns != globalNs) {
                    ns = null;
                }
                gnfqnr.ns = ns;
                gnfqnr.altNs = altNs;
                return;
            }
            for (end_ind = start_ind; end_ind < name_len; ++len, ++end_ind) {
                if (name_len - end_ind <= 1 || qualName.charAt(end_ind) != ':' || qualName.charAt(end_ind + 1) != ':') continue;
                end_ind += 2;
                while (end_ind < name_len && qualName.charAt(end_ind) == ':') {
                    ++end_ind;
                }
                break;
            }
            if (end_ind == name_len && (end_ind - start_ind < 2 || qualName.charAt(end_ind - 1) != ':' || qualName.charAt(end_ind - 2) != ':')) {
                if ((flags & 0x1000) == 0) {
                    gnfqnr.ns = ns;
                    gnfqnr.altNs = altNs;
                    gnfqnr.simpleName = qualName.substring(start_ind);
                    return;
                }
                nsName = qualName.substring(start_ind);
            } else {
                nsName = qualName.substring(start_ind, start_ind + len);
            }
            if (ns != null) {
                Namespace entryNs = (Namespace)ns.childTable.get(nsName);
                if (entryNs != null) {
                    ns = entryNs;
                } else if ((flags & 0x800) != 0) {
                    CallFrame frame = interp.newCallFrame();
                    Namespace.pushCallFrame(interp, frame, ns, false);
                    ns = Namespace.createNamespace(interp, nsName, null);
                    Namespace.popCallFrame(interp);
                    if (ns == null) {
                        throw new RuntimeException("Could not create namespace " + nsName);
                    }
                } else {
                    ns = null;
                }
            }
            if (altNs != null) {
                altNs = (Namespace)altNs.childTable.get(nsName);
            }
            if (ns == null && altNs == null) {
                gnfqnr.ns = null;
                gnfqnr.altNs = null;
                gnfqnr.simpleName = null;
                return;
            }
            start_ind = end_ind;
        }
    }

    public static Namespace findNamespace(Interp interp, String name, Namespace contextNs, int flags) {
        GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, name, contextNs, flags | 0x1000, gnfqnr);
        Namespace ns = gnfqnr.ns;
        if (ns != null) {
            return ns;
        }
        if ((flags & 0x200) != 0) {
            interp.setResult("unknown namespace \"" + name + "\"");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static WrappedCommand findCommand(Interp interp, String name, Namespace contextNs, int flags) throws TclException {
        WrappedCommand cmd;
        Namespace cxtNs = (flags & 1) != 0 ? Namespace.getGlobalNamespace(interp) : (contextNs != null ? contextNs : Namespace.getCurrentNamespace(interp));
        if (cxtNs.resolver != null || interp.resolvers != null) {
            try {
                cmd = cxtNs.resolver != null ? cxtNs.resolver.resolveCmd(interp, name, cxtNs, flags) : null;
                if (cmd == null && interp.resolvers != null) {
                    ListIterator iter = interp.resolvers.listIterator();
                    while (cmd == null && iter.hasNext()) {
                        Interp.ResolverScheme res = (Interp.ResolverScheme)iter.next();
                        cmd = res.resolver.resolveCmd(interp, name, cxtNs, flags);
                    }
                }
                if (cmd != null) {
                    return cmd;
                }
            }
            catch (TclException e) {
                return null;
            }
        }
        GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, name, contextNs, flags, gnfqnr);
        Namespace ns0 = gnfqnr.ns;
        Namespace ns1 = gnfqnr.altNs;
        cxtNs = gnfqnr.actualCxt;
        String simpleName = gnfqnr.simpleName;
        cmd = null;
        for (int search = 0; search < 2 && cmd == null; ++search) {
            void var12_13;
            Namespace ns;
            if (search == 0) {
                ns = ns0;
            } else if (search == 1) {
                ns = ns1;
            } else {
                throw new TclRuntimeError("bad search value" + search);
            }
            if (var12_13 == null || simpleName == null) continue;
            cmd = (WrappedCommand)var12_13.cmdTable.get(simpleName);
        }
        if (cmd != null) {
            return cmd;
        }
        if ((flags & 0x200) != 0) {
            throw new TclException(interp, "unknown command \"" + name + "\"");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Var findNamespaceVar(Interp interp, String name, Namespace contextNs, int flags) throws TclException {
        Var var;
        Namespace cxtNs = (flags & 1) != 0 ? Namespace.getGlobalNamespace(interp) : (contextNs != null ? contextNs : Namespace.getCurrentNamespace(interp));
        if (cxtNs.resolver != null || interp.resolvers != null) {
            try {
                var = cxtNs.resolver != null ? cxtNs.resolver.resolveVar(interp, name, cxtNs, flags) : null;
                if (var == null && interp.resolvers != null) {
                    ListIterator iter = interp.resolvers.listIterator();
                    while (var == null && iter.hasNext()) {
                        Interp.ResolverScheme res = (Interp.ResolverScheme)iter.next();
                        var = res.resolver.resolveVar(interp, name, cxtNs, flags);
                    }
                }
                if (var != null) {
                    return var;
                }
            }
            catch (TclException e) {
                return null;
            }
        }
        GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
        Namespace.getNamespaceForQualName(interp, name, contextNs, flags, gnfqnr);
        Namespace ns0 = gnfqnr.ns;
        Namespace ns1 = gnfqnr.altNs;
        cxtNs = gnfqnr.actualCxt;
        String simpleName = gnfqnr.simpleName;
        var = null;
        for (int search = 0; search < 2 && var == null; ++search) {
            void var12_13;
            Namespace ns;
            if (search == 0) {
                ns = ns0;
            } else if (search == 1) {
                ns = ns1;
            } else {
                throw new TclRuntimeError("bad search value" + search);
            }
            if (var12_13 == null || simpleName == null) continue;
            var = (Var)var12_13.varTable.get(simpleName);
        }
        if (var != null) {
            return var;
        }
        if ((flags & 0x200) != 0) {
            interp.setResult("unknown variable \"" + name + "\"");
        }
        return null;
    }

    static void resetShadowedCmdRefs(Interp interp, WrappedCommand newCmd) {
        Namespace globalNs = Namespace.getGlobalNamespace(interp);
        Namespace[] trailArray = null;
        int trailFront = -1;
        int trailSize = 5;
        String cmdName = newCmd.hashKey;
        Namespace ns = newCmd.ns;
        while (ns != null && ns != globalNs) {
            WrappedCommand wcmd;
            boolean found = true;
            Namespace shadowNs = globalNs;
            for (int i = trailFront; i >= 0; --i) {
                void trailNs = trailArray[i];
                Namespace tmpNs = (Namespace)shadowNs.childTable.get(trailNs.name);
                if (tmpNs == null) {
                    found = false;
                    break;
                }
                shadowNs = tmpNs;
            }
            if (found && (wcmd = (WrappedCommand)shadowNs.cmdTable.get(cmdName)) != null) {
                Iterator iter = ns.cmdTable.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    wcmd = (WrappedCommand)entry.getValue();
                    wcmd.incrEpoch();
                }
            }
            if (trailArray == null) {
                trailArray = new Namespace[5];
            }
            if (++trailFront == trailSize) {
                int size = trailSize * 2;
                Namespace[] tmp = new Namespace[size];
                System.arraycopy(trailArray, 0, tmp, 0, trailArray.length);
                trailArray = tmp;
                trailSize = size;
            }
            trailArray[trailFront] = ns;
            ns = ns.parent;
        }
    }

    public static void setNamespaceResolver(Namespace namespace, Resolver resolver) {
        namespace.resolver = resolver;
    }

    static Resolver getNamespaceResolver(Namespace namespace) {
        return namespace.resolver;
    }

    static Object FirstHashEntry(HashMap table) {
        Set eset = table.entrySet();
        if (eset.size() == 0) {
            return null;
        }
        Iterator iter = eset.iterator();
        if (!iter.hasNext()) {
            throw new TclRuntimeError("no next() object but set size was " + eset.size());
        }
        Map.Entry entry = iter.next();
        Object retVal = entry.getValue();
        if (retVal == null) {
            throw new TclRuntimeError("entry value should not be null");
        }
        return retVal;
    }

    static class GetNamespaceForQualNameResult {
        Namespace ns;
        Namespace altNs;
        Namespace actualCxt;
        String simpleName;

        GetNamespaceForQualNameResult() {
        }
    }

    static class ResolvedNsName {
        Namespace ns;
        long nsId;
        Namespace refNs;
        int refCount;

        ResolvedNsName() {
        }
    }

    public static interface DeleteProc {
        public void delete();
    }
}

