/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import tcl.lang.Channel;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;

class FileChannel
extends Channel {
    private RandomAccessFile file = null;

    FileChannel() {
    }

    String open(Interp interp, String fileName, int modeFlags) throws IOException, TclException {
        this.mode = modeFlags;
        File fileObj = FileUtil.getNewFileObj(interp, fileName);
        if ((modeFlags & 0x10) != 0 && (modeFlags & 0x20) != 0 && fileObj.exists()) {
            throw new TclException(interp, "couldn't open \"" + fileName + "\": file exists");
        }
        if ((modeFlags & 0x10) != 0 && !fileObj.exists()) {
            this.file = new RandomAccessFile(fileObj, "rw");
            this.file.close();
        }
        if ((modeFlags & 4) != 0) {
            this.checkFileExists(interp, fileObj);
            this.checkReadWritePerm(interp, fileObj, 0);
            if (fileObj.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + fileName + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(fileObj, "rw");
        } else if ((modeFlags & 1) != 0) {
            this.checkFileExists(interp, fileObj);
            this.checkReadWritePerm(interp, fileObj, -1);
            if (fileObj.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + fileName + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(fileObj, "r");
        } else if ((modeFlags & 2) != 0) {
            this.checkFileExists(interp, fileObj);
            this.checkReadWritePerm(interp, fileObj, 1);
            if (fileObj.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + fileName + "\": illegal operation on a directory");
            }
            if (!fileObj.canRead()) {
                throw new TclException(interp, "Java IO limitation: Cannot open a file that has only write permissions set.");
            }
            this.file = new RandomAccessFile(fileObj, "rw");
        } else {
            throw new TclRuntimeError("FileChannel.java: invalid mode value");
        }
        if ((modeFlags & 8) != 0) {
            this.file.seek(this.file.length());
        }
        if ((modeFlags & 0x40) != 0) {
            java.nio.channels.FileChannel chan = this.file.getChannel();
            chan.truncate(0L);
        }
        String fName = TclIO.getNextDescriptor(interp, "file");
        this.setChanName(fName);
        return fName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.close(): null file object");
        }
        try {
            super.close();
        }
        finally {
            this.file.close();
            this.file = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    void seek(Interp interp, long offset, int inmode) throws IOException, TclException {
        void var8_7;
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.seek(): null file object");
        }
        int inputBuffered = this.getNumBufferedInputBytes();
        int outputBuffered = this.getNumBufferedOutputBytes();
        if (inputBuffered != 0 && outputBuffered != 0) {
            throw new TclPosixException(interp, 14, true, "error during seek on \"" + this.getChanName() + "\"");
        }
        if (inmode == 2) {
            offset -= (long)inputBuffered;
        }
        if (this.input != null) {
            this.input.seekReset();
        }
        boolean wasAsync = false;
        if (this.output != null) {
            this.output.seekCheckBuferReady();
        }
        if (this.output != null && this.output.flushChannel(null, false) != 0) {
            throw new IOException("flush error while seeking");
        }
        switch (inmode) {
            case 1: {
                long actual_offset = offset;
                break;
            }
            case 2: {
                long actual_offset = this.file.getFilePointer() + offset;
                break;
            }
            case 3: {
                long actual_offset = this.file.length() + offset;
                break;
            }
            default: {
                throw new TclRuntimeError("invalid seek mode");
            }
        }
        if (var8_7 < 0L) {
            throw new TclPosixException(interp, 22, true, "error during seek on \"" + this.getChanName() + "\"");
        }
        this.file.seek((long)var8_7);
        if (wasAsync) {
            this.setBlocking(false);
        }
    }

    long tell() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.tell(): null file object");
        }
        int inputBuffered = this.getNumBufferedInputBytes();
        int outputBuffered = this.getNumBufferedOutputBytes();
        if (inputBuffered != 0 && outputBuffered != 0) {
            return -1L;
        }
        long curPos = this.file.getFilePointer();
        if (curPos == -1L) {
            return -1L;
        }
        if (inputBuffered != 0) {
            return curPos - (long)inputBuffered;
        }
        return curPos + (long)outputBuffered;
    }

    private void checkFileExists(Interp interp, File fileObj) throws TclException {
        if (!fileObj.exists()) {
            throw new TclPosixException(interp, 2, true, "couldn't open \"" + fileObj.getName() + "\"");
        }
    }

    private void checkReadWritePerm(Interp interp, File fileObj, int inmode) throws TclException {
        boolean error = false;
        if (inmode <= 0 && !fileObj.canRead()) {
            error = true;
        }
        if (inmode >= 0 && !fileObj.canWrite()) {
            error = true;
        }
        if (error) {
            throw new TclPosixException(interp, 13, true, "couldn't open \"" + fileObj.getName() + "\"");
        }
    }

    String getChanType() {
        return "file";
    }

    protected InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file.getFD());
    }

    protected OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file.getFD());
    }
}

