/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.EncodingCmd;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class FconfigureCmd
implements Command {
    private static final String[] validCmds = new String[]{"-blocking", "-buffering", "-buffersize", "-encoding", "-eofchar", "-translation"};
    static final int OPT_BLOCKING = 0;
    static final int OPT_BUFFERING = 1;
    static final int OPT_BUFFERSIZE = 2;
    static final int OPT_ENCODING = 3;
    static final int OPT_EOFCHAR = 4;
    static final int OPT_TRANSLATION = 5;

    FconfigureCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        String javaEncoding;
        if (argv.length < 2 || argv.length % 2 == 1 && argv.length != 3) {
            throw new TclNumArgsException(interp, 1, argv, "channelId ?optionName? ?value? ?optionName value?...");
        }
        Channel chan = TclIO.getChannel(interp, argv[1].toString());
        if (chan == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[1].toString() + "\"");
        }
        if (argv.length == 2) {
            char eofChar;
            TclObject list = TclList.newInstance();
            TclList.append(interp, list, TclString.newInstance((String)"-blocking"));
            TclList.append(interp, list, TclBoolean.newInstance((boolean)chan.getBlocking()));
            TclList.append(interp, list, TclString.newInstance((String)"-buffering"));
            TclList.append(interp, list, TclString.newInstance((String)TclIO.getBufferingString(chan.getBuffering())));
            TclList.append(interp, list, TclString.newInstance((String)"-buffersize"));
            TclList.append(interp, list, TclInteger.newInstance((int)chan.getBufferSize()));
            TclList.append(interp, list, TclString.newInstance((String)"-encoding"));
            javaEncoding = chan.getEncoding();
            String tclEncoding = javaEncoding == null ? "binary" : EncodingCmd.getTclName(javaEncoding);
            TclList.append(interp, list, TclString.newInstance((String)tclEncoding));
            TclList.append(interp, list, TclString.newInstance((String)"-eofchar"));
            if (chan.isReadOnly()) {
                eofChar = chan.getInputEofChar();
                TclList.append(interp, list, eofChar == '\u0000' ? TclString.newInstance((String)"") : TclString.newInstance((char)eofChar));
            } else if (chan.isWriteOnly()) {
                eofChar = chan.getOutputEofChar();
                TclList.append(interp, list, eofChar == '\u0000' ? TclString.newInstance((String)"") : TclString.newInstance((char)eofChar));
            } else if (chan.isReadWrite()) {
                char inEofChar = chan.getInputEofChar();
                char outEofChar = chan.getOutputEofChar();
                TclObject eofchar_pair = TclList.newInstance();
                TclList.append(interp, eofchar_pair, inEofChar == '\u0000' ? TclString.newInstance((String)"") : TclString.newInstance((char)inEofChar));
                TclList.append(interp, eofchar_pair, outEofChar == '\u0000' ? TclString.newInstance((String)"") : TclString.newInstance((char)outEofChar));
                TclList.append(interp, list, eofchar_pair);
            }
            TclList.append(interp, list, TclString.newInstance((String)"-translation"));
            if (chan.isReadOnly()) {
                TclList.append(interp, list, TclString.newInstance((String)TclIO.getTranslationString(chan.getInputTranslation())));
            } else if (chan.isWriteOnly()) {
                TclList.append(interp, list, TclString.newInstance((String)TclIO.getTranslationString(chan.getOutputTranslation())));
            } else if (chan.isReadWrite()) {
                TclObject translation_pair = TclList.newInstance();
                TclList.append(interp, translation_pair, TclString.newInstance((String)TclIO.getTranslationString(chan.getInputTranslation())));
                TclList.append(interp, translation_pair, TclString.newInstance((String)TclIO.getTranslationString(chan.getOutputTranslation())));
                TclList.append(interp, list, translation_pair);
            }
            interp.setResult(list);
        }
        if (argv.length == 3) {
            int index = TclIndex.get((Interp)interp, (TclObject)argv[2], (String[])validCmds, (String)"option", (int)0);
            switch (index) {
                case 0: {
                    interp.setResult(chan.getBlocking());
                    break;
                }
                case 1: {
                    interp.setResult(TclIO.getBufferingString(chan.getBuffering()));
                    break;
                }
                case 2: {
                    interp.setResult(chan.getBufferSize());
                    break;
                }
                case 3: {
                    javaEncoding = chan.getEncoding();
                    if (javaEncoding == null) {
                        interp.setResult("binary");
                        break;
                    }
                    interp.setResult(EncodingCmd.getTclName(javaEncoding));
                    break;
                }
                case 4: {
                    if (chan.isReadOnly()) {
                        char eofChar = chan.getInputEofChar();
                        interp.setResult(eofChar == '\u0000' ? TclString.newInstance((String)"") : TclString.newInstance((char)eofChar));
                        break;
                    }
                    if (chan.isWriteOnly()) {
                        char eofChar = chan.getOutputEofChar();
                        interp.setResult(eofChar == '\u0000' ? TclString.newInstance((String)"") : TclString.newInstance((char)eofChar));
                        break;
                    }
                    if (!chan.isReadWrite()) break;
                    char inEofChar = chan.getInputEofChar();
                    char outEofChar = chan.getOutputEofChar();
                    TclObject eofchar_pair = TclList.newInstance();
                    TclList.append(interp, eofchar_pair, inEofChar == '\u0000' ? TclString.newInstance((String)"") : TclString.newInstance((char)inEofChar));
                    TclList.append(interp, eofchar_pair, outEofChar == '\u0000' ? TclString.newInstance((String)"") : TclString.newInstance((char)outEofChar));
                    interp.setResult(eofchar_pair);
                    break;
                }
                case 5: {
                    if (chan.isReadOnly()) {
                        interp.setResult(TclIO.getTranslationString(chan.getInputTranslation()));
                        break;
                    }
                    if (chan.isWriteOnly()) {
                        interp.setResult(TclIO.getTranslationString(chan.getOutputTranslation()));
                        break;
                    }
                    if (!chan.isReadWrite()) break;
                    TclObject translation_pair = TclList.newInstance();
                    TclList.append(interp, translation_pair, TclString.newInstance((String)TclIO.getTranslationString(chan.getInputTranslation())));
                    TclList.append(interp, translation_pair, TclString.newInstance((String)TclIO.getTranslationString(chan.getOutputTranslation())));
                    interp.setResult(translation_pair);
                    break;
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
        }
        block16: for (int i = 3; i < argv.length; i += 2) {
            int index = TclIndex.get((Interp)interp, (TclObject)argv[i - 1], (String[])validCmds, (String)"option", (int)0);
            switch (index) {
                case 0: {
                    chan.setBlocking(TclBoolean.get((Interp)interp, (TclObject)argv[i]));
                    continue block16;
                }
                case 1: {
                    int id = TclIO.getBufferingID(argv[i].toString());
                    if (id == -1) {
                        throw new TclException(interp, "bad value for -buffering: must be one of full, line, or none");
                    }
                    chan.setBuffering(id);
                    continue block16;
                }
                case 2: {
                    chan.setBufferSize(TclInteger.get((Interp)interp, (TclObject)argv[i]));
                    continue block16;
                }
                case 3: {
                    String tclEncoding = argv[i].toString();
                    if (tclEncoding.equals("") || tclEncoding.equals("binary")) {
                        chan.setEncoding(null);
                        continue block16;
                    }
                    String javaEncoding2 = EncodingCmd.getJavaName(tclEncoding);
                    if (javaEncoding2 == null) {
                        throw new TclException(interp, "unknown encoding \"" + tclEncoding + "\"");
                    }
                    if (!EncodingCmd.isSupported(javaEncoding2)) {
                        throw new TclException(interp, "unsupported encoding \"" + tclEncoding + "\"");
                    }
                    chan.setEncoding(javaEncoding2);
                    continue block16;
                }
                case 4: {
                    String s;
                    char inputEofChar;
                    char outputEofChar;
                    int length = TclList.getLength(interp, argv[i]);
                    if (length > 2) {
                        throw new TclException(interp, "bad value for -eofchar: should be a list of zero, one, or two elements");
                    }
                    if (length == 0) {
                        outputEofChar = '\u0000';
                        inputEofChar = '\u0000';
                    } else if (length == 1) {
                        s = TclList.index(interp, argv[i], 0).toString();
                        inputEofChar = outputEofChar = s.charAt(0);
                    } else {
                        s = TclList.index(interp, argv[i], 0).toString();
                        inputEofChar = s.charAt(0);
                        s = TclList.index(interp, argv[i], 1).toString();
                        outputEofChar = s.charAt(0);
                    }
                    chan.setInputEofChar(inputEofChar);
                    chan.setOutputEofChar(outputEofChar);
                    continue block16;
                }
                case 5: {
                    int outputTranslation;
                    String outputTranslationArg;
                    int inputTranslation;
                    String inputTranslationArg;
                    int length = TclList.getLength(interp, argv[i]);
                    if (length < 1 || length > 2) {
                        throw new TclException(interp, "bad value for -translation: must be a one or two element list");
                    }
                    if (length == 2) {
                        inputTranslationArg = TclList.index(interp, argv[i], 0).toString();
                        inputTranslation = TclIO.getTranslationID(inputTranslationArg);
                        outputTranslationArg = TclList.index(interp, argv[i], 1).toString();
                        outputTranslation = TclIO.getTranslationID(outputTranslationArg);
                    } else {
                        outputTranslationArg = inputTranslationArg = argv[i].toString();
                        outputTranslation = inputTranslation = TclIO.getTranslationID(outputTranslationArg);
                    }
                    if (inputTranslation == -1 || outputTranslation == -1) {
                        throw new TclException(interp, "bad value for -translation: must be one of auto, binary, cr, lf, crlf, or platform");
                    }
                    if (outputTranslation == 0) {
                        outputTranslation = TclIO.TRANS_PLATFORM;
                    }
                    if (chan.isReadOnly()) {
                        chan.setInputTranslation(inputTranslation);
                        if (!inputTranslationArg.equals("binary")) continue block16;
                        chan.setEncoding(null);
                        continue block16;
                    }
                    if (chan.isWriteOnly()) {
                        chan.setOutputTranslation(outputTranslation);
                        if (!outputTranslationArg.equals("binary")) continue block16;
                        chan.setEncoding(null);
                        continue block16;
                    }
                    if (!chan.isReadWrite()) continue block16;
                    chan.setInputTranslation(inputTranslation);
                    chan.setOutputTranslation(outputTranslation);
                    if (!inputTranslationArg.equals("binary") && !outputTranslationArg.equals("binary")) continue block16;
                    chan.setEncoding(null);
                    continue block16;
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
        }
    }
}

