/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import tcl.lang.Command;
import tcl.lang.ExecInputStreamReader;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class ExecCmd
implements Command {
    private static boolean debug = false;

    ExecCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        String argStr;
        int firstWord;
        int argLen = argv.length;
        boolean background = false;
        boolean keepNewline = false;
        for (firstWord = 1; firstWord < argLen && (argStr = argv[firstWord].toString()).length() > 0 && argStr.charAt(0) == '-'; ++firstWord) {
            if (!argStr.equals("-keepnewline")) {
                if (argStr.equals("--")) {
                    ++firstWord;
                    break;
                }
                throw new TclException(interp, "bad switch \"" + argStr + "\": must be -keepnewline or --");
            }
            keepNewline = true;
        }
        if (argLen <= firstWord) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? arg ?arg ...?");
        }
        if (argv[argLen - 1].toString().equals("&")) {
            --argLen;
            background = true;
        }
        try {
            int errorBytes;
            Process p = this.execCmd(interp, argv, firstWord, argLen);
            if (background) {
                interp.setResult("pid0");
                return;
            }
            StringBuffer sbuf = new StringBuffer();
            ExecInputStreamReader stdout_reader = new ExecInputStreamReader(p.getInputStream());
            ExecInputStreamReader stderr_reader = new ExecInputStreamReader(p.getErrorStream());
            stdout_reader.start();
            stderr_reader.start();
            if (debug) {
                System.out.println("started reader threads, invoking waitFor()");
            }
            int exit = p.waitFor();
            if (debug) {
                System.out.println("waitFor() returned " + exit);
                System.out.println("joining reader threads");
            }
            stdout_reader.join();
            stderr_reader.join();
            int numBytes = stdout_reader.appendBytes(sbuf);
            if (debug) {
                System.out.println("appended " + numBytes + " bytes from stdout stream");
            }
            numBytes = stderr_reader.appendBytes(sbuf);
            if (debug) {
                System.out.println("appended " + numBytes + " bytes from stderr stream");
            }
            if ((errorBytes = stderr_reader.getInBytes()) == 0 && exit != 0) {
                sbuf.append("child process exited abnormally");
            }
            int length = sbuf.length();
            if (!keepNewline && length > 0 && sbuf.charAt(length - 1) == '\n') {
                sbuf.setLength(length - 1);
            }
            if (exit != 0) {
                TclObject childstatus = TclList.newInstance();
                TclList.append(interp, childstatus, TclString.newInstance((String)"CHILDSTATUS"));
                TclList.append(interp, childstatus, TclString.newInstance((String)"?PID?"));
                TclList.append(interp, childstatus, TclInteger.newInstance((int)exit));
                interp.setErrorCode(childstatus);
            }
            if (exit != 0 || errorBytes != 0) {
                throw new TclException(interp, sbuf.toString());
            }
            interp.setResult(sbuf.toString());
        }
        catch (IOException e) {
            throw new TclException(interp, "couldn't execute \"" + argv[firstWord].toString() + "\": no such file or directory");
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static int readStreamIntoBuffer(InputStream in, StringBuffer sbuf) {
        int numRead;
        block12: {
            numRead = 0;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            while (line != null) {
                sbuf.append(line);
                numRead += line.length();
                sbuf.append('\n');
                ++numRead;
                line = br.readLine();
            }
            Object var6_6 = null;
            try {
                br.close();
            }
            catch (IOException e2) {
                if (debug) {
                    System.out.println("IOException during stream close()");
                    e2.printStackTrace(System.out);
                }
                break block12;
            }
            {
                catch (IOException e) {
                    if (debug) {
                        System.out.println("IOException during stream read()");
                        e.printStackTrace(System.out);
                    }
                    Object var6_7 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        if (debug) {
                            System.out.println("IOException during stream close()");
                            e2.printStackTrace(System.out);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block13: {
                    Object var6_8 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        if (!debug) break block13;
                        System.out.println("IOException during stream close()");
                        e2.printStackTrace(System.out);
                    }
                }
                throw throwable;
            }
        }
        return numRead;
    }

    private Process execCmd(Interp interp, TclObject[] argv, int first, int last) throws IOException {
        String[] strv = new String[last - first];
        int j = 0;
        for (int i = first; i < last; ++i) {
            strv[j] = argv[i].toString();
            ++j;
        }
        return Runtime.getRuntime().exec(strv, null, interp.getWorkingDir());
    }
}

