/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

class ChannelBuffer {
    int nextAdded;
    int nextRemoved;
    int bufLength;
    ChannelBuffer next;
    byte[] buf;
    static final int BUFFER_PADDING = 16;

    ChannelBuffer(int length) {
        int n = length + 16 + 16;
        this.buf = new byte[n];
        this.nextAdded = 16;
        this.nextRemoved = 16;
        this.bufLength = length + 16;
        this.next = null;
    }

    public String toString() {
        int numBytes = this.nextAdded - this.nextRemoved;
        StringBuffer sb = new StringBuffer(256);
        sb.append("ChannelBuffer contains " + numBytes + " bytes" + "\n");
        for (int i = 0; i < numBytes; ++i) {
            byte ival = this.buf[this.nextRemoved + i];
            String srep = (char)ival == '\r' ? "\\r" : ((char)ival == '\n' ? "\\n" : "" + (char)ival);
            sb.append("bytes[" + i + "] = '" + srep + "'" + ", (int) " + ival + " , " + "0x" + Integer.toHexString(ival) + "\n");
        }
        return sb.toString();
    }
}

