/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.SearchId;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TclVarException;
import tcl.lang.Util;
import tcl.lang.Var;

class ArrayCmd
implements Command {
    static Class procClass = null;
    private static final String[] validCmds = new String[]{"anymore", "donesearch", "exists", "get", "names", "nextelement", "set", "size", "startsearch", "unset"};
    static final int OPT_ANYMORE = 0;
    static final int OPT_DONESEARCH = 1;
    static final int OPT_EXISTS = 2;
    static final int OPT_GET = 3;
    static final int OPT_NAMES = 4;
    static final int OPT_NEXTELEMENT = 5;
    static final int OPT_SET = 6;
    static final int OPT_SIZE = 7;
    static final int OPT_STARTSEARCH = 8;
    static final int OPT_UNSET = 9;

    ArrayCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        String msg;
        Var var = null;
        Var array = null;
        boolean notArray = false;
        if (objv.length < 3) {
            throw new TclNumArgsException(interp, 1, objv, "option arrayName ?arg ...?");
        }
        int index = TclIndex.get((Interp)interp, (TclObject)objv[1], (String[])validCmds, (String)"option", (int)0);
        String varName = objv[2].toString();
        Var[] retArray = Var.lookupVar(interp, varName, null, 0, null, false, false);
        if (retArray != null) {
            var = retArray[0];
            array = retArray[1];
        }
        if (var == null || !var.isVarArray() || var.isVarUndefined()) {
            notArray = true;
        }
        if (var != null && var.traces != null && (msg = Var.callTraces(interp, array, var, varName, null, 2563)) != null) {
            throw new TclVarException(interp, varName, null, "trace array", msg);
        }
        switch (index) {
            case 0: {
                Iterator iter;
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName searchId");
                }
                if (notArray) {
                    ArrayCmd.errorNotArray(interp, objv[2].toString());
                }
                if (var.sidVec == null) {
                    ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                }
                if ((iter = var.getSearch(objv[3].toString())) == null) {
                    ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                }
                if (iter.hasNext()) {
                    interp.setResult(true);
                    break;
                }
                interp.setResult(false);
                break;
            }
            case 1: {
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName searchId");
                }
                if (notArray) {
                    ArrayCmd.errorNotArray(interp, objv[2].toString());
                }
                boolean rmOK = true;
                if (var.sidVec != null) {
                    rmOK = var.removeSearch(objv[3].toString());
                }
                if (var.sidVec != null && rmOK) break;
                ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                break;
            }
            case 2: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName");
                }
                interp.setResult(!notArray);
                break;
            }
            case 3: {
                if (objv.length != 3 && objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName ?pattern?");
                }
                if (notArray) {
                    return;
                }
                String pattern = null;
                if (objv.length == 4) {
                    pattern = objv[3].toString();
                }
                HashMap table = var.arraymap;
                TclObject tobj = TclList.newInstance();
                String arrayName = objv[2].toString();
                Iterator iter = table.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String key = (String)entry.getKey();
                    Var var2 = (Var)entry.getValue();
                    if (var2.isVarUndefined() || pattern != null && !Util.stringMatch(key, pattern)) continue;
                    String strValue = interp.getVar(arrayName, key, 0).toString();
                    TclList.append(interp, tobj, TclString.newInstance((String)key));
                    TclList.append(interp, tobj, TclString.newInstance((String)strValue));
                }
                interp.setResult(tobj);
                break;
            }
            case 4: {
                if (objv.length != 3 && objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName ?pattern?");
                }
                if (notArray) {
                    return;
                }
                String pattern = null;
                if (objv.length == 4) {
                    pattern = objv[3].toString();
                }
                HashMap table = var.arraymap;
                TclObject tobj = TclList.newInstance();
                Iterator iter = table.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String key = (String)entry.getKey();
                    Var elem = (Var)entry.getValue();
                    if (elem.isVarUndefined() || pattern != null && !Util.stringMatch(key, pattern)) continue;
                    TclList.append(interp, tobj, TclString.newInstance((String)key));
                }
                interp.setResult(tobj);
                break;
            }
            case 5: {
                Iterator iter;
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName searchId");
                }
                if (notArray) {
                    ArrayCmd.errorNotArray(interp, objv[2].toString());
                }
                if (var.sidVec == null) {
                    ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                }
                if ((iter = var.getSearch(objv[3].toString())) == null) {
                    ArrayCmd.errorIllegalSearchId(interp, objv[2].toString(), objv[3].toString());
                }
                if (!iter.hasNext()) break;
                Map.Entry entry = (Map.Entry)iter.next();
                String key = (String)entry.getKey();
                Var elem = (Var)entry.getValue();
                if (!elem.isVarUndefined()) {
                    interp.setResult(key);
                    break;
                }
                interp.setResult("");
                break;
            }
            case 6: {
                if (objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName list");
                }
                int size = TclList.getLength(interp, objv[3]);
                if (size % 2 != 0) {
                    throw new TclException(interp, "list must have an even number of elements");
                }
                String name1 = objv[2].toString();
                for (int i = 0; i < size; ++i) {
                    String name2 = TclList.index(interp, objv[3], i++).toString();
                    String strValue = TclList.index(interp, objv[3], i).toString();
                    interp.setVar(name1, name2, TclString.newInstance((String)strValue), 0);
                }
                break;
            }
            case 7: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName");
                }
                if (notArray) {
                    interp.setResult(0);
                    break;
                }
                HashMap table = var.arraymap;
                int size = 0;
                Iterator iter = table.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String key = (String)entry.getKey();
                    Var elem = (Var)entry.getValue();
                    if (elem.isVarUndefined()) continue;
                    ++size;
                }
                interp.setResult(size);
                break;
            }
            case 8: {
                if (objv.length != 3) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName");
                }
                if (notArray) {
                    ArrayCmd.errorNotArray(interp, objv[2].toString());
                }
                if (var.sidVec == null) {
                    var.sidVec = new ArrayList();
                }
                int i = var.getNextIndex();
                String s = "s-" + i + "-" + objv[2].toString();
                HashMap table = var.arraymap;
                Iterator iter = table.entrySet().iterator();
                var.sidVec.add(new SearchId(iter, s, i));
                interp.setResult(s);
                break;
            }
            case 9: {
                if (objv.length != 3 && objv.length != 4) {
                    throw new TclNumArgsException(interp, 2, objv, "arrayName ?pattern?");
                }
                if (notArray) {
                    ArrayCmd.errorNotArray(interp, objv[2].toString());
                }
                if (objv.length == 3) {
                    interp.unsetVar(objv[2], 0);
                    break;
                }
                String pattern = objv[3].toString();
                HashMap table = var.arraymap;
                Iterator iter = table.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String name = (String)entry.getKey();
                    Var elem = (Var)entry.getValue();
                    if (elem.isVarUndefined() || !Util.stringMatch(name, pattern)) continue;
                    interp.unsetVar(varName, name, 0);
                    iter = table.entrySet().iterator();
                }
                break;
            }
        }
    }

    private static void errorNotArray(Interp interp, String var) throws TclException {
        throw new TclException(interp, "\"" + var + "\" isn't an array");
    }

    static void errorIllegalSearchId(Interp interp, String varName, String sid) throws TclException {
        int val = ArrayCmd.validSearchId(sid.toCharArray(), varName);
        if (val == 1) {
            throw new TclException(interp, "couldn't find search \"" + sid + "\"");
        }
        if (val == 0) {
            throw new TclException(interp, "illegal search identifier \"" + sid + "\"");
        }
        throw new TclException(interp, "search identifier \"" + sid + "\" isn't for variable \"" + varName + "\"");
    }

    private static int validSearchId(char[] pattern, String varName) {
        int i;
        if (pattern[0] != 's' || pattern[1] != '-' || pattern[2] < '0' || pattern[2] > '9') {
            return 0;
        }
        for (i = 3; i < pattern.length && pattern[i] != '-'; ++i) {
            if (pattern[i] >= '0' && pattern[i] <= '9') continue;
            return 0;
        }
        if (++i >= pattern.length) {
            return 0;
        }
        if (varName.equals(new String(pattern, i, pattern.length - i))) {
            return 1;
        }
        return -1;
    }
}

