/*
 * Decompiled with CFR 0.152.
 */
package net.somta.common.utils.io;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import net.somta.common.utils.encrypt.Base64;
import net.somta.common.utils.io.FileUtil;
import net.somta.common.utils.io.ImageUtil;

public class QRCodeUtil {
    private static final String CHARSET = "utf-8";
    private static final String FORMAT_NAME = "PNG";
    public static final String PIC_PNG = "data:image/png;base64,";
    private static final int QRCODE_SIZE = 200;
    private static final int WIDTH = 60;
    private static final int HEIGHT = 60;

    private static BufferedImage createImage(String content, String imgPath, boolean needCompress) throws Exception {
        return QRCodeUtil.createImage(content, imgPath, needCompress, 200);
    }

    public static BufferedImage createImage(String content, String imgPath, boolean needCompress, int qrcodeSize) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, qrcodeSize, qrcodeSize, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        if (imgPath != null && !"".equals(imgPath)) {
            QRCodeUtil.insertImage(image, imgPath, needCompress, qrcodeSize);
            return image;
        }
        return image;
    }

    public static BufferedImage createImages(String content, boolean needCompress, int qrcodeSize) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, qrcodeSize, qrcodeSize, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static InputStream converStream(BufferedImage image, String Type) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, Type, os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    public static void insertImage(BufferedImage source, String imgPath, boolean needCompress, int qrcodeSize) throws Exception {
        File file = new File(imgPath);
        if (file.exists()) {
            Image src = ImageIO.read(new File(imgPath));
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            if (needCompress) {
                if (width > qrcodeSize / 200 * 60) {
                    width = qrcodeSize / 200 * 60;
                }
                if (height > qrcodeSize / 200 * 60) {
                    height = qrcodeSize / 200 * 60;
                }
                Image image = src.getScaledInstance(width, height, 4);
                BufferedImage tag = new BufferedImage(width, height, 1);
                Graphics g = tag.getGraphics();
                g.drawImage(image, 0, 0, null);
                g.dispose();
                src = image;
            }
            Graphics2D graph = source.createGraphics();
            int x = (qrcodeSize - width) / 2;
            int y = (qrcodeSize - height) / 2;
            graph.drawImage(src, x, y, width, height, null);
            RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
            graph.setStroke(new BasicStroke(3.0f));
            graph.draw(shape);
            graph.dispose();
        }
    }

    public static void encode(String content, String imgPath, String destPath, boolean needCompress) throws Exception {
        BufferedImage image = QRCodeUtil.createImage(content, imgPath, needCompress);
        FileUtil.makeDir(destPath, false);
        ImageIO.write((RenderedImage)image, FORMAT_NAME, new File(destPath));
    }

    public static void encode(String content, String imgPath, String destPath, boolean needCompress, int qrcodeSize) throws Exception {
        BufferedImage image = QRCodeUtil.createImage(content, imgPath, needCompress, qrcodeSize);
        FileUtil.makeDir(destPath, false);
        ImageIO.write((RenderedImage)image, FORMAT_NAME, new File(destPath));
    }

    public static void encode(String content, String imgPath, String destPath) throws Exception {
        QRCodeUtil.encode(content, imgPath, destPath, false);
    }

    public static void encode(String content, String imgPath, String destPath, int qrcodeSize) throws Exception {
        QRCodeUtil.encode(content, imgPath, destPath, false);
    }

    public static void encode(String content, String destPath, boolean needCompress) throws Exception {
        QRCodeUtil.encode(content, (String)null, destPath, needCompress);
    }

    public static void encode(String content, String destPath) throws Exception {
        QRCodeUtil.encode(content, (String)null, destPath, false);
    }

    public static void encode(String content, String imgPath, OutputStream output, boolean needCompress) throws Exception {
        BufferedImage image = QRCodeUtil.createImage(content, imgPath, needCompress);
        ImageIO.write((RenderedImage)image, FORMAT_NAME, output);
    }

    public static void encode(String content, String imgPath, OutputStream output, boolean needCompress, int qrcodeSize) throws Exception {
        BufferedImage image = QRCodeUtil.createImage(content, imgPath, needCompress, qrcodeSize);
        ImageIO.write((RenderedImage)image, FORMAT_NAME, output);
    }

    public static String encode(String content, boolean needCompress, int qrcodeSize) {
        BufferedImage image = null;
        try {
            image = QRCodeUtil.createImages(content, needCompress, qrcodeSize);
        }
        catch (Exception var11) {
            var11.printStackTrace();
        }
        byte[] btSt = ImageUtil.getBytes(image);
        byte[] byteStream = Base64.encodeByte(btSt).getBytes();
        StringBuilder sb = new StringBuilder(PIC_PNG);
        byte[] var10 = byteStream;
        int var9 = byteStream.length;
        for (int var8 = 0; var8 < var9; ++var8) {
            byte b = var10[var8];
            sb.append((char)b);
        }
        return sb.toString();
    }

    public static void encode(String content, OutputStream output, int qrcodeSize) throws Exception {
        QRCodeUtil.encode(content, (String)null, output, false, qrcodeSize);
    }

    public static void encode(String content, OutputStream output) throws Exception {
        QRCodeUtil.encode(content, (String)null, output, false);
    }

    public static String decode(File file) throws Exception {
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            return null;
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, CHARSET);
        Result result = new MultiFormatReader().decode(bitmap, hints);
        String resultStr = result.getText();
        return resultStr;
    }

    public static String decode(BufferedImage image) throws Exception {
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, CHARSET);
        Result result = new MultiFormatReader().decode(bitmap, hints);
        String resultStr = result.getText();
        return resultStr;
    }

    public static String decode(String path) throws Exception {
        return QRCodeUtil.decode(new File(path));
    }
}

