/*
 * Decompiled with CFR 0.152.
 */
package net.somta.common.utils.io;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import org.apache.commons.lang3.StringUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ImageUtil {
    private static String[] imgTypes = new String[]{"gif", "jpeg", "jpg", "png", "bmp"};

    public static boolean checkType(String imageType) {
        boolean flag = false;
        if (Arrays.asList(imgTypes).contains(imageType.toLowerCase())) {
            flag = true;
        }
        return flag;
    }

    public static InputStream compress(InputStream in, Integer width, Integer height, Float quality, Double scale) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{in});
        if (width != null && height != null) {
            builder.size(width.intValue(), height.intValue());
        }
        if (scale != null) {
            builder.scale(scale.doubleValue());
        }
        if (quality != null) {
            builder.outputQuality(quality.floatValue());
        }
        builder.toOutputStream((OutputStream)os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        in.close();
        os.close();
        return is;
    }

    public static InputStream getInputStream(BufferedImage image, String readImageFormat) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, readImageFormat, os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        os.close();
        return is;
    }

    public static void inputstreamToFile(InputStream ins, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
            ((OutputStream)os).write(buffer, 0, bytesRead);
        }
        ((OutputStream)os).close();
        ins.close();
    }

    public static void imgThumb(String source, String output, int width, int height, float quality) throws IOException {
        Thumbnails.of((String[])new String[]{source}).size(width, height).outputQuality(quality).outputFormat("jpg").toFile(output);
    }

    public static void imgThumb(File source, String output, int width, int height, float quality) throws IOException {
        Thumbnails.of((File[])new File[]{source}).size(width, height).outputQuality(quality).outputFormat("jpg").toFile(output);
    }

    public static void imgScale(String source, String output, double scale) throws IOException {
        Thumbnails.of((String[])new String[]{source}).scale(scale).outputFormat("jpg").toFile(output);
    }

    public static void imgScale(File source, String output, double scale) throws IOException {
        Thumbnails.of((File[])new File[]{source}).scale(scale).outputFormat("jpg").toFile(output);
    }

    public static void imgNoScale(String source, String output, int width, int height, boolean keepAspectRatio) throws IOException {
        Thumbnails.of((String[])new String[]{source}).size(width, height).keepAspectRatio(keepAspectRatio).outputFormat("jpg").toFile(output);
    }

    public static void imgNoScale(File source, String output, int width, int height, boolean keepAspectRatio) throws IOException {
        Thumbnails.of((File[])new File[]{source}).size(width, height).keepAspectRatio(keepAspectRatio).outputFormat("jpg").toFile(output);
    }

    public static InputStream imgWatermark(InputStream in, Integer width, Integer height, Position position, String watermark, Float transparency, Float quality) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{in});
        if (width != null && height != null) {
            builder.size(width.intValue(), height.intValue());
        }
        if (position != null && StringUtils.isNotEmpty((CharSequence)watermark) && transparency != null) {
            builder.watermark(position, ImageUtil.stringToBufferedImage(watermark), transparency.floatValue());
        }
        if (quality != null) {
            builder.outputQuality(quality.floatValue());
        }
        builder.scale(1.0);
        builder.toOutputStream((OutputStream)os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        in.close();
        os.close();
        return is;
    }

    public static void imgWatermark(String source, String output, int width, int height, Position position, String watermark, float transparency, float quality) throws IOException {
        Thumbnails.of((String[])new String[]{source}).size(width, height).watermark(position, ImageIO.read(new File(watermark)), transparency).outputQuality(0.8f).outputFormat("jpg").toFile(output);
    }

    public static void imgWatermark(File source, String output, int width, int height, Position position, String watermark, float transparency, float quality) throws IOException {
        Thumbnails.of((File[])new File[]{source}).size(width, height).watermark(position, ImageIO.read(new File(watermark)), transparency).outputQuality(0.8f).outputFormat("jpg").toFile(output);
    }

    public static void imgSourceRegion(String source, String output, Position position, int x, int y, int width, int height, boolean keepAspectRatio) throws IOException {
        Thumbnails.of((String[])new String[]{source}).sourceRegion(position, x, y).size(width, height).keepAspectRatio(keepAspectRatio).outputFormat("jpg").toFile(output);
    }

    public static void imgSourceRegion(File source, String output, Position position, int x, int y, int width, int height, boolean keepAspectRatio) throws IOException {
        Thumbnails.of((File[])new File[]{source}).sourceRegion(position, x, y).size(width, height).keepAspectRatio(keepAspectRatio).outputFormat("jpg").toFile(output);
    }

    public static void imgSourceRegion(String source, String output, int x, int y, int x1, int y1, int width, int height, boolean keepAspectRatio) throws IOException {
        Thumbnails.of((String[])new String[]{source}).sourceRegion(x, y, x1, y1).size(width, height).keepAspectRatio(keepAspectRatio).toFile(output);
    }

    public static void imgSourceRegion(File source, String output, int x, int y, int x1, int y1, int width, int height, boolean keepAspectRatio) throws IOException {
        Thumbnails.of((File[])new File[]{source}).sourceRegion(x, y, x1, y1).size(width, height).keepAspectRatio(keepAspectRatio).outputFormat("jpg").toFile(output);
    }

    public static void imgFormat(String source, String output, int width, int height, String format) throws IOException {
        Thumbnails.of((String[])new String[]{source}).size(width, height).outputFormat(format).toFile(output);
    }

    public static void imgFormat(File source, String output, int width, int height, String format) throws IOException {
        Thumbnails.of((File[])new File[]{source}).size(width, height).outputFormat(format).outputFormat("jpg").toFile(output);
    }

    public static OutputStream imgOutputStream(String source, String output, int width, int height) throws IOException {
        FileOutputStream os = new FileOutputStream(output);
        Thumbnails.of((String[])new String[]{source}).size(width, height).outputFormat("jpg").toOutputStream((OutputStream)os);
        return os;
    }

    public static OutputStream imgOutputStream(File source, String output, int width, int height) throws IOException {
        FileOutputStream os = new FileOutputStream(output);
        Thumbnails.of((File[])new File[]{source}).size(width, height).outputFormat("jpg").toOutputStream((OutputStream)os);
        return os;
    }

    public static BufferedImage imgBufferedImage(String source, String output, int width, int height, String format) throws IOException {
        BufferedImage buf = Thumbnails.of((String[])new String[]{source}).size(width, height).outputFormat("jpg").asBufferedImage();
        ImageIO.write((RenderedImage)buf, format, new File(output));
        return buf;
    }

    public static BufferedImage imgBufferedImage(File source, String output, int width, int height, String format) throws IOException {
        BufferedImage buf = Thumbnails.of((File[])new File[]{source}).size(width, height).outputFormat("jpg").asBufferedImage();
        ImageIO.write((RenderedImage)buf, format, new File(output));
        return buf;
    }

    public static BufferedImage stringToBufferedImage(String str) throws IOException {
        int width = 200;
        int height = 40;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        image = g.getDeviceConfiguration().createCompatibleImage(width, height, 3);
        g.dispose();
        g = image.createGraphics();
        g.setColor(new Color(192, 192, 192));
        g.setStroke(new BasicStroke(1.0f));
        g.setFont(new Font("\u5b8b\u4f53", 2, 22));
        g.drawString(str, 6, 15);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imageToString(String imgPath) {
        String imgFile = imgPath;
        FileInputStream in = null;
        byte[] data = null;
        String encode = null;
        BASE64Encoder encoder = new BASE64Encoder();
        try {
            in = new FileInputStream(imgFile);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            encode = encoder.encode(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return encode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stringToImage(String imgStr, String imgFilePath) throws IOException {
        if (imgStr == null) {
            return false;
        }
        File file = new File(imgFilePath);
        if (!file.exists()) {
            new File(file.getParent()).mkdirs();
        }
        BASE64Decoder decoder = new BASE64Decoder();
        OutputStream out = null;
        try {
            out = new FileOutputStream(imgFilePath);
            imgStr = imgStr.substring(imgStr.indexOf(",") + 1);
            byte[] b = decoder.decodeBuffer(imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            out.write(b);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            out.flush();
            out.close();
            return true;
        }
    }

    public static byte[] getBytes(BufferedImage image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", baos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }
}

