/*
 * Decompiled with CFR 0.152.
 */
package net.somta.common.utils.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FileUtil {
    public static String FILE_READING_ENCODING = "UTF-8";
    public static String FILE_WRITING_ENCODING = "UTF-8";

    public static String readFile(String _sFileName, String _sEncoding) throws Exception {
        StringBuffer buffContent = null;
        FileInputStream fis = null;
        BufferedReader buffReader = null;
        if (_sEncoding == null || "".equals(_sEncoding)) {
            _sEncoding = FILE_READING_ENCODING;
        }
        try {
            String sLine;
            fis = new FileInputStream(_sFileName);
            buffReader = new BufferedReader(new InputStreamReader((InputStream)fis, _sEncoding));
            boolean zFirstLine = "UTF-8".equalsIgnoreCase(_sEncoding);
            while ((sLine = buffReader.readLine()) != null) {
                if (buffContent == null) {
                    buffContent = new StringBuffer();
                } else {
                    buffContent.append("\n");
                }
                if (zFirstLine) {
                    sLine = FileUtil.removeBomHeaderIfExists(sLine);
                    zFirstLine = false;
                }
                buffContent.append(sLine);
            }
            String string = buffContent == null ? "" : buffContent.toString();
            return string;
        }
        catch (FileNotFoundException ex) {
            throw new Exception("\u8981\u8bfb\u53d6\u7684\u6587\u4ef6\u6ca1\u6709\u627e\u5230!", ex);
        }
        catch (IOException ex) {
            throw new Exception("\u8bfb\u53d6\u6587\u4ef6\u65f6\u9519\u8bef!", ex);
        }
        finally {
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String extractFilePath(String _sFilePathName) {
        int nPos = _sFilePathName.lastIndexOf(47);
        if (nPos < 0) {
            nPos = _sFilePathName.lastIndexOf(92);
        }
        return nPos >= 0 ? _sFilePathName.substring(0, nPos + 1) : "";
    }

    public static String extractFileName(String _sFilePathName) {
        return FileUtil.extractFileName(_sFilePathName, File.separator);
    }

    public static String extractFileName(String _sFilePathName, String _sFileSeparator) {
        int nPos = -1;
        if (_sFileSeparator == null) {
            nPos = _sFilePathName.lastIndexOf(File.separatorChar);
            if (nPos < 0) {
                nPos = _sFilePathName.lastIndexOf(File.separatorChar == '/' ? 92 : 47);
            }
        } else {
            nPos = _sFilePathName.lastIndexOf(_sFileSeparator);
        }
        if (nPos < 0) {
            return _sFilePathName;
        }
        return _sFilePathName.substring(nPos + 1);
    }

    public static boolean pathExists(String _sPathFileName) {
        String sPath = FileUtil.extractFilePath(_sPathFileName);
        return FileUtil.fileExists(sPath);
    }

    public static boolean fileExists(String _sPathFileName) {
        File file = new File(_sPathFileName);
        return file.exists();
    }

    public static boolean makeDir(String _sDir, boolean _bCreateParentDir) {
        boolean zResult = false;
        File file = new File(_sDir);
        zResult = _bCreateParentDir ? file.mkdirs() : file.mkdir();
        if (!zResult) {
            zResult = file.exists();
        }
        return zResult;
    }

    private static String removeBomHeaderIfExists(String _sLine) {
        if (_sLine == null) {
            return null;
        }
        String line = _sLine;
        if (line.length() > 0) {
            char ch = line.charAt(0);
            while ((ch == '\ufeff' || ch == '\ufffe') && (line = line.substring(1)).length() != 0) {
                ch = line.charAt(0);
            }
        }
        return line;
    }

    public static String getFileExtension(String fileName) {
        int idx = fileName.lastIndexOf(".");
        if (idx == -1) {
            return "";
        }
        return fileName.substring(idx);
    }

    public static String getFileNameSuffix(String fileName) {
        String suffix = null;
        if (fileName.indexOf(".") >= 0) {
            suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return suffix;
    }
}

