/*
 * Decompiled with CFR 0.152.
 */
package net.somta.common.utils.httpclient;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;

public class ParamHelper {
    public static void buildFormParams(HttpUriRequestBase httpRequest, String url, Map<String, Object> params) {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (Map.Entry<String, Object> param : params.entrySet()) {
                nvps.add(new BasicNameValuePair(param.getKey(), String.valueOf(param.getValue())));
            }
            try {
                URI uri = new URIBuilder(new URI(url)).addParameters(nvps).build();
                httpRequest.setUri(uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static HttpPost setParamsToPost(HttpPost httpPost, Map<String, Object> params) {
        if (params == null) {
            return httpPost;
        }
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            BasicNameValuePair pair = null;
            pair = entry.getValue() == null ? new BasicNameValuePair(entry.getKey(), null) : new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
            pairList.add(pair);
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        return httpPost;
    }

    public static HttpPut setParamsToPut(HttpPut httpPut, Map<String, Object> params) {
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            BasicNameValuePair pair = null;
            pair = entry.getValue() == null ? new BasicNameValuePair(entry.getKey(), null) : new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
            pairList.add(pair);
        }
        httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
        return httpPut;
    }
}

