/*
 * Decompiled with CFR 0.152.
 */
package net.somta.common.utils.httpclient;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.somta.common.utils.httpclient.HeaderHelper;
import net.somta.common.utils.httpclient.ParamHelper;
import net.somta.common.utils.httpclient.ResponseHelper;
import net.somta.core.protocol.ResponseDataResult;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public class HttpClientUtil {
    private static PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    private static CloseableHttpClient httpClient;
    private static final int MAX_TIMEOUT = 7000;
    private static final String ENCODING_CODE = "UTF-8";

    public static ResponseDataResult doGet(String url) {
        return HttpClientUtil.doGet(url, new HashMap<String, Object>(), new HashMap<String, String>());
    }

    public static ResponseDataResult doGet(String url, Map<String, Object> params) {
        return HttpClientUtil.doGet(url, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseDataResult doGet(String url, Map<String, Object> params, Map<String, String> headers) {
        ResponseDataResult responseDataResult = new ResponseDataResult();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            ParamHelper.buildFormParams((HttpUriRequestBase)httpGet, url, params);
            httpGet = HeaderHelper.setHeadersToGet(httpGet, headers);
            response = httpClient.execute((ClassicHttpRequest)httpGet);
            ResponseDataResult responseDataResult2 = ResponseHelper.buildResponse(response, responseDataResult);
            return responseDataResult2;
        }
        catch (Exception e) {
            responseDataResult.setSuccess(false);
            responseDataResult.setErrorMsg(e.getMessage());
            ResponseDataResult responseDataResult3 = responseDataResult;
            return responseDataResult3;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ResponseDataResult doFormPost(String url) {
        return HttpClientUtil.doFormPost(url, null);
    }

    public static ResponseDataResult doFormPost(String url, Map<String, Object> params) {
        return HttpClientUtil.doFormPost(url, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseDataResult doFormPost(String url, Map<String, Object> params, Map<String, String> headers) {
        ResponseDataResult responseDataResult = new ResponseDataResult();
        HttpPost httpPost = new HttpPost(url);
        ParamHelper.buildFormParams((HttpUriRequestBase)httpPost, url, params);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            httpPost = HeaderHelper.setHeadersToPost(httpPost, headers);
            response = httpClient.execute((ClassicHttpRequest)httpPost);
            ResponseDataResult responseDataResult2 = ResponseHelper.buildResponse(response, responseDataResult);
            return responseDataResult2;
        }
        catch (Exception e) {
            responseDataResult.setSuccess(false);
            responseDataResult.setErrorMsg(e.getMessage());
            ResponseDataResult responseDataResult3 = responseDataResult;
            return responseDataResult3;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ResponseDataResult doPost(String url) {
        return HttpClientUtil.doPost(url, null);
    }

    public static ResponseDataResult doPost(String url, String json) {
        return HttpClientUtil.doPost(url, json, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseDataResult doPost(String url, String json, Map<String, String> headers) {
        ResponseDataResult responseDataResult = new ResponseDataResult();
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            httpPost = HeaderHelper.setHeadersToPost(httpPost, headers);
            StringEntity stringEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((ClassicHttpRequest)httpPost);
            ResponseDataResult responseDataResult2 = ResponseHelper.buildResponse(response, responseDataResult);
            return responseDataResult2;
        }
        catch (Exception e) {
            responseDataResult.setSuccess(false);
            responseDataResult.setErrorMsg(e.getMessage());
            ResponseDataResult responseDataResult3 = responseDataResult;
            return responseDataResult3;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ResponseDataResult doFormPut(String url) {
        return HttpClientUtil.doFormPut(url, null);
    }

    public static ResponseDataResult doFormPut(String url, Map<String, Object> params) {
        return HttpClientUtil.doFormPut(url, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseDataResult doFormPut(String url, Map<String, Object> params, Map<String, String> headers) {
        ResponseDataResult responseDataResult = new ResponseDataResult();
        HttpPut httpPut = new HttpPut(url);
        CloseableHttpResponse response = null;
        try {
            HeaderHelper.setHeadersToPut(httpPut, headers);
            ParamHelper.setParamsToPut(httpPut, params);
            response = httpClient.execute((ClassicHttpRequest)httpPut);
            ResponseDataResult responseDataResult2 = ResponseHelper.buildResponse(response, responseDataResult);
            return responseDataResult2;
        }
        catch (Exception e) {
            responseDataResult.setSuccess(false);
            responseDataResult.setErrorMsg(e.getMessage());
            ResponseDataResult responseDataResult3 = responseDataResult;
            return responseDataResult3;
        }
        finally {
            try {
                if (response != null) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ResponseDataResult doPut(String url) {
        return HttpClientUtil.doPut(url, null);
    }

    public static ResponseDataResult doPut(String url, String json) {
        return HttpClientUtil.doPut(url, json, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseDataResult doPut(String url, String json, Map<String, String> headers) {
        ResponseDataResult responseDataResult = new ResponseDataResult();
        HttpPut httpPut = new HttpPut(url);
        CloseableHttpResponse response = null;
        try {
            httpPut = HeaderHelper.setHeadersToPut(httpPut, headers);
            StringEntity stringEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPut.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((ClassicHttpRequest)httpPut);
            ResponseDataResult responseDataResult2 = ResponseHelper.buildResponse(response, responseDataResult);
            return responseDataResult2;
        }
        catch (Exception e) {
            responseDataResult.setSuccess(false);
            responseDataResult.setErrorMsg(e.getMessage());
            ResponseDataResult responseDataResult3 = responseDataResult;
            return responseDataResult3;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ResponseDataResult doDelete(String url) {
        return HttpClientUtil.doDelete(url, null);
    }

    public static ResponseDataResult doDelete(String url, Map<String, Object> params) {
        return HttpClientUtil.doDelete(url, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseDataResult doDelete(String url, Map<String, Object> params, Map<String, String> headers) {
        ResponseDataResult responseDataResult = new ResponseDataResult();
        CloseableHttpResponse response = null;
        try {
            HttpDelete httpDelete = new HttpDelete(url);
            HeaderHelper.setHeadersToDelete(httpDelete, headers);
            ParamHelper.buildFormParams((HttpUriRequestBase)httpDelete, url, params);
            response = httpClient.execute((ClassicHttpRequest)httpDelete);
            ResponseDataResult responseDataResult2 = ResponseHelper.buildResponse(response, responseDataResult);
            return responseDataResult2;
        }
        catch (Exception e) {
            responseDataResult.setSuccess(false);
            responseDataResult.setErrorMsg(e.getMessage());
            ResponseDataResult responseDataResult3 = responseDataResult;
            return responseDataResult3;
        }
        finally {
            try {
                if (response != null) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)7000L));
        configBuilder.setResponseTimeout(Timeout.ofMilliseconds((long)7000L));
        configBuilder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)7000L));
        configBuilder.setContentCompressionEnabled(true);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(configBuilder.build()).build();
    }
}

