/*
 * Decompiled with CFR 0.152.
 */
package net.somta.common.utils;

import net.somta.common.enums.CommonErrorEnum;
import net.somta.core.base.IBaseError;
import net.somta.core.exception.SysException;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdUtil {
    private Logger logger = LoggerFactory.getLogger(SnowflakeIdUtil.class);
    private final long startTime = 1655827200000L;
    private final long randomIdBits = 12L;
    private final long maxRandomId = 4095L;
    private final long sequenceBits = 10L;
    private final long randomIdShift = 10L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 1023L;
    private long randomId = RandomUtils.nextInt((int)1, (int)4096);
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public synchronized long nextId() {
        long currentTimestamp = this.getCurrentTimestamp();
        if (currentTimestamp < this.lastTimestamp) {
            throw new SysException((IBaseError)CommonErrorEnum.SNOW_FLAKE_ERROR, new Object[]{this.lastTimestamp - currentTimestamp});
        }
        if (this.lastTimestamp == currentTimestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp - 1655827200000L << 22 | this.randomId << 10 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.getCurrentTimestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentTimestamp();
        }
        return timestamp;
    }

    protected long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }
}

