/*
 * Decompiled with CFR 0.152.
 */
package net.somta.core.cache.redis.serialize;

import net.somta.core.cache.redis.serialize.InterfaceSerializable;
import net.somta.core.helper.JsonSerializeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializable
implements InterfaceSerializable {
    private static final Logger logger = LoggerFactory.getLogger(JsonSerializable.class);

    @Override
    public <T> String serialize(T value) {
        try {
            return JsonSerializeHelper.serialize(value);
        }
        catch (Exception e) {
            logger.error("json serialize error", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T deserialize(String data, Class<T> clazz) {
        try {
            return JsonSerializeHelper.deserialize(data, clazz);
        }
        catch (Exception e) {
            logger.error("json deserialize error", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T deserialize(String data, Class<T> clazz, Class<?> elementClasses) {
        try {
            return JsonSerializeHelper.deserialize(data, clazz, elementClasses);
        }
        catch (Exception e) {
            logger.error("json deserialize error", (Throwable)e);
            return null;
        }
    }
}

