/*
 * Decompiled with CFR 0.152.
 */
package net.somta.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MapUtil {
    public static Object mapToObject(Map<String, Object> map, Class<?> beanClass) {
        if (map == null) {
            return null;
        }
        Object object = null;
        try {
            Field[] fields;
            object = beanClass.newInstance();
            for (Field field : fields = beanClass.getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
                field.setAccessible(true);
                field.set(object, map.get(field.getName()));
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return object;
    }

    public static Map<String, Object> objectToMap(Object obj) {
        Field[] declaredFields;
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static void removeNullValue(Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            Object value = map.get(obj);
            MapUtil.remove(value, iterator);
        }
    }

    private static void remove(Object obj, Iterator iterator) {
        if (obj instanceof String) {
            String str = (String)obj;
            if (StringUtils.isEmpty((CharSequence)str)) {
                iterator.remove();
            }
        } else if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            if (col == null || col.isEmpty()) {
                iterator.remove();
            }
        } else if (obj instanceof Map) {
            Map temp = (Map)obj;
            if (temp == null || temp.isEmpty()) {
                iterator.remove();
            }
        } else if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            if (array == null || array.length <= 0) {
                iterator.remove();
            }
        } else if (obj == null) {
            iterator.remove();
        }
    }
}

