/*
 * Decompiled with CFR 0.152.
 */
package net.somta.common.encrypt;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.somta.common.encrypt.Base64Util;
import net.somta.common.encrypt.KeyModeEnum;

public final class AESUtil {
    private static final String ALGORITHM_NAME = "AES";
    public static final int DEFAULT_KEY_SIZE = 128;
    private static final String DEFAULT_IV = "y4b42e5XxSu4cy4R";

    public static String encrypt(String content, SecretKey secretKey) {
        return AESUtil.encrypt(content, secretKey, KeyModeEnum.ECB);
    }

    public static String encrypt(String content, SecretKey secretKey, KeyModeEnum keyMode) {
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        byte[] result = AESUtil.encrypt(contentBytes, secretKey, keyMode, DEFAULT_IV.getBytes());
        return Base64Util.encode(result);
    }

    public static String encrypt(String content, SecretKey secretKey, KeyModeEnum keyMode, String ivStr) {
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        byte[] result = AESUtil.encrypt(contentBytes, secretKey, keyMode, ivStr.getBytes());
        return Base64Util.encode(result);
    }

    public static byte[] encrypt(byte[] contentBytes, SecretKey secretKey, KeyModeEnum keyMode, byte[] ivByte) {
        try {
            Cipher cipher = Cipher.getInstance(String.format("%s/%s/PKCS5Padding", ALGORITHM_NAME, keyMode.getName()));
            if (KeyModeEnum.CBC.equals((Object)keyMode)) {
                IvParameterSpec iv = new IvParameterSpec(ivByte);
                cipher.init(1, (Key)secretKey, iv);
            } else {
                cipher.init(1, secretKey);
            }
            return cipher.doFinal(contentBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("AES " + e.getMessage());
        }
    }

    public static String decrypt(String base64Content, SecretKey secretKey) {
        byte[] contentBytes = Base64Util.decodeToByte(base64Content);
        byte[] result = AESUtil.decrypt(contentBytes, secretKey, KeyModeEnum.ECB, DEFAULT_IV.getBytes());
        return new String(result, StandardCharsets.UTF_8);
    }

    public static String decrypt(String base64Content, SecretKey secretKey, KeyModeEnum keyMode) {
        byte[] contentBytes = Base64Util.decodeToByte(base64Content);
        byte[] result = AESUtil.decrypt(contentBytes, secretKey, keyMode, DEFAULT_IV.getBytes());
        return new String(result, StandardCharsets.UTF_8);
    }

    public static String decrypt(String base64Content, SecretKey secretKey, KeyModeEnum keyMode, String ivStr) {
        byte[] contentBytes = Base64Util.decodeToByte(base64Content);
        byte[] result = AESUtil.decrypt(contentBytes, secretKey, keyMode, ivStr.getBytes());
        return new String(result, StandardCharsets.UTF_8);
    }

    public static byte[] decrypt(byte[] contentBytes, SecretKey secretKey, KeyModeEnum keyMode, byte[] ivByte) {
        try {
            Cipher cipher = Cipher.getInstance(String.format("%s/%s/PKCS5Padding", ALGORITHM_NAME, keyMode.getName()));
            if (KeyModeEnum.CBC.equals((Object)keyMode)) {
                IvParameterSpec iv = new IvParameterSpec(ivByte);
                cipher.init(2, (Key)secretKey, iv);
            } else {
                cipher.init(2, secretKey);
            }
            return cipher.doFinal(contentBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("AES decrypt exception:" + e.getMessage());
        }
    }

    public static SecretKey generateSecretKey(int keySize) {
        try {
            keySize = Math.max(keySize, 128);
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM_NAME);
            keyGenerator.init(keySize, new SecureRandom());
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("generate secret exception:" + e.getMessage());
        }
    }

    public static SecretKeySpec stringToSecretKey(String secretKeyStr) {
        if (secretKeyStr == null || secretKeyStr.length() != 16) {
            throw new IllegalArgumentException("Key string must be exactly 16 characters long");
        }
        byte[] keyBytes = secretKeyStr.getBytes(StandardCharsets.UTF_8);
        return new SecretKeySpec(keyBytes, ALGORITHM_NAME);
    }
}

